/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.client.renderer;

import com.jaquadro.minecraft.modularpots.block.BlockLargePot;
import com.jaquadro.minecraft.modularpots.client.ClientProxy;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityLargePot;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LargePotRenderer
implements ISimpleBlockRenderingHandler {
    private float[] baseColor = new float[3];
    private float[] activeRimColor = new float[3];
    private float[] activeInWallColor = new float[3];
    private float[] activeBottomColor = new float[3];
    private float[] activeSubstrateColor = new float[3];

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLargePot)) {
            return;
        }
        this.renderInventoryBlock((BlockLargePot)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockLargePot block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int damage = metadata;
        metadata &= 0xF;
        block.func_149683_g();
        renderer.func_147775_a((Block)block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 5, metadata));
        tessellator.func_78381_a();
        boolean blendEnabled = GL11.glIsEnabled((int)3042);
        if (!blendEnabled) {
            GL11.glEnable((int)3042);
        }
        if ((damage & 0xFF00) != 0) {
            IIcon icon = block.getOverlayIcon(damage >> 8 & 0xFF);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
        }
        if (!blendEnabled) {
            GL11.glDisable((int)3042);
        }
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        float dim = 0.0625f;
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, (double)dim);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 1, metadata));
        renderer.func_147782_a(0.0, 0.0, (double)(1.0f - dim), 1.0, 1.0, 1.0);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 1, metadata));
        renderer.func_147782_a(0.0, 0.0, 0.0, (double)dim, 1.0, 1.0);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 1, metadata));
        renderer.func_147782_a((double)(1.0f - dim), 0.0, 0.0, 1.0, 1.0, 1.0);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 1, metadata));
        tessellator.func_78381_a();
        block.func_149683_g();
        renderer.func_147775_a((Block)block);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c((Block)block, 0.0, 0.0, (double)(1.0f - dim), renderer.func_147787_a((Block)block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d((Block)block, 0.0, 0.0, (double)(dim - 1.0f), renderer.func_147787_a((Block)block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e((Block)block, (double)(1.0f - dim), 0.0, 0.0, renderer.func_147787_a((Block)block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f((Block)block, (double)(dim - 1.0f), 0.0, 0.0, renderer.func_147787_a((Block)block, 5, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b((Block)block, 0.0, (double)(dim - 1.0f), 0.0, renderer.func_147787_a((Block)block, 1, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLargePot)) {
            return false;
        }
        try {
            if (ClientProxy.renderPass == 0) {
                return this.renderWorldBlockPass0(world, x, y, z, (BlockLargePot)block, modelId, renderer);
            }
            if (ClientProxy.renderPass == 1) {
                return this.renderWorldBlockPass1(world, x, y, z, (BlockLargePot)block, modelId, renderer);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private void renderEmptyPlane(Block block, int x, int y, int z, RenderBlocks renderer) {
        renderer.func_147782_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, Blocks.field_150405_ch.func_149691_a(0, 0));
    }

    private boolean renderWorldBlockPass1(IBlockAccess world, int x, int y, int z, BlockLargePot block, int modelId, RenderBlocks renderer) {
        TileEntityLargePot tileEntity = block.getTileEntity(world, x, y, z);
        if (tileEntity == null) {
            this.renderEmptyPlane((Block)block, x, y, z, renderer);
            return true;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = block.getOverlayIcon(tileEntity.getCarving());
        boolean didRender = false;
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (icon != null) {
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            boolean connectZNeg = block.isCompatibleNeighbor(world, x, y, z, 0, -1);
            boolean connectZPos = block.isCompatibleNeighbor(world, x, y, z, 0, 1);
            boolean connectXNeg = block.isCompatibleNeighbor(world, x, y, z, -1, 0);
            boolean connectXPos = block.isCompatibleNeighbor(world, x, y, z, 1, 0);
            if (!connectXNeg) {
                renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, icon);
            }
            if (!connectXPos) {
                renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, icon);
            }
            if (!connectZNeg) {
                renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, icon);
            }
            if (!connectZPos) {
                renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, icon);
            }
            boolean bl = didRender = !connectXNeg || !connectXPos || !connectZNeg || !connectZPos;
        }
        if (tileEntity.getSubstrate() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)tileEntity.getSubstrate());
            int substrateData = tileEntity.getSubstrateData();
            if (substrate == Blocks.field_150355_j) {
                this.calculateBaseColor(this.activeSubstrateColor, substrate.func_149635_D());
                this.scaleColor(this.activeSubstrateColor, this.activeSubstrateColor, 0.9f);
                this.setTessellatorColor(tessellator, this.activeSubstrateColor);
                IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateData);
                renderer.func_147806_b((Block)block, (double)x, (double)((float)y - 0.0625f), (double)z, substrateIcon);
                didRender = true;
            }
        }
        if (!didRender) {
            this.renderEmptyPlane((Block)block, x, y, z, renderer);
        }
        return true;
    }

    private boolean renderWorldBlockPass0(IBlockAccess world, int x, int y, int z, BlockLargePot block, int modelId, RenderBlocks renderer) {
        TileEntityLargePot tileEntity;
        renderer.func_147784_q((Block)block, x, y, z);
        int data = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        IIcon icon = renderer.func_147787_a((Block)block, 1, data);
        this.calculateBaseColor(this.baseColor, block.func_149720_d(world, x, y, z));
        this.scaleColor(this.activeRimColor, this.baseColor, 0.8f);
        this.scaleColor(this.activeInWallColor, this.baseColor, 0.7f);
        this.scaleColor(this.activeBottomColor, this.baseColor, 0.6f);
        this.setTessellatorColor(tessellator, this.activeRimColor);
        float unit = 0.0625f;
        boolean connectZNeg = block.isCompatibleNeighbor(world, x, y, z, 0, -1);
        boolean connectZPos = block.isCompatibleNeighbor(world, x, y, z, 0, 1);
        boolean connectXNeg = block.isCompatibleNeighbor(world, x, y, z, -1, 0);
        boolean connectXPos = block.isCompatibleNeighbor(world, x, y, z, 1, 0);
        boolean connectZNegXNeg = block.isCompatibleNeighbor(world, x, y, z, -1, -1);
        boolean connectZNegXPos = block.isCompatibleNeighbor(world, x, y, z, 1, -1);
        boolean connectZPosXNeg = block.isCompatibleNeighbor(world, x, y, z, -1, 1);
        boolean connectZPosXPos = block.isCompatibleNeighbor(world, x, y, z, 1, 1);
        if (!connectZNeg) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, (double)unit);
            renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
        }
        if (!connectZPos) {
            renderer.func_147782_a(0.0, 0.0, (double)(1.0f - unit), 1.0, 1.0, 1.0);
            renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
        }
        if (!connectXNeg) {
            renderer.func_147782_a(0.0, 0.0, 0.0, (double)unit, 1.0, 1.0);
            renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
        }
        if (!connectXPos) {
            renderer.func_147782_a((double)(1.0f - unit), 0.0, 0.0, 1.0, 1.0, 1.0);
            renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
        }
        if (connectZNeg && connectXPos && !connectZNegXPos) {
            this.renderCorner(block, renderer, BlockLargePot.Direction.NorthEast, x, y, z, icon);
        }
        if (connectZNeg && connectXNeg && !connectZNegXNeg) {
            this.renderCorner(block, renderer, BlockLargePot.Direction.NorthWest, x, y, z, icon);
        }
        if (connectZPos && connectXPos && !connectZPosXPos) {
            this.renderCorner(block, renderer, BlockLargePot.Direction.SouthEast, x, y, z, icon);
        }
        if (connectZPos && connectXNeg && !connectZPosXNeg) {
            this.renderCorner(block, renderer, BlockLargePot.Direction.SouthWest, x, y, z, icon);
        }
        block.func_149683_g();
        renderer.func_147775_a((Block)block);
        this.setTessellatorColor(tessellator, this.activeInWallColor);
        if (!connectXNeg) {
            renderer.func_147764_f((Block)block, (double)((float)(x - 1) + unit), (double)y, (double)z, icon);
        }
        if (!connectXPos) {
            renderer.func_147798_e((Block)block, (double)((float)(x + 1) - unit), (double)y, (double)z, icon);
        }
        if (!connectZNeg) {
            renderer.func_147734_d((Block)block, (double)x, (double)y, (double)((float)(z - 1) + unit), icon);
        }
        if (!connectZPos) {
            renderer.func_147761_c((Block)block, (double)x, (double)y, (double)((float)(z + 1) - unit), icon);
        }
        if ((tileEntity = block.getTileEntity(world, x, y, z)) != null && tileEntity.getSubstrate() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)tileEntity.getSubstrate());
            int substrateData = tileEntity.getSubstrateData();
            if (substrate != Blocks.field_150355_j) {
                this.calculateBaseColor(this.activeSubstrateColor, substrate.func_149635_D());
                this.scaleColor(this.activeSubstrateColor, this.activeSubstrateColor, 0.8f);
                this.setTessellatorColor(tessellator, this.activeSubstrateColor);
                IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateData);
                renderer.func_147806_b((Block)block, (double)x, (double)((float)y - unit), (double)z, substrateIcon);
            } else {
                this.setTessellatorColor(tessellator, this.activeBottomColor);
                renderer.func_147806_b((Block)block, (double)x, (double)((float)(y - 1) + unit), (double)z, block.getBottomIcon(data));
            }
        } else {
            this.setTessellatorColor(tessellator, this.activeBottomColor);
            renderer.func_147806_b((Block)block, (double)x, (double)((float)(y - 1) + unit), (double)z, block.getBottomIcon(data));
        }
        return true;
    }

    private void renderCorner(BlockLargePot block, RenderBlocks renderer, BlockLargePot.Direction direction, int x, int y, int z, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float dim = 0.0625f;
        switch (direction) {
            case NorthEast: {
                block.func_149676_a(1.0f - dim, 0.0f, 0.0f, 1.0f, 1.0f, dim);
                renderer.func_147775_a((Block)block);
                this.setTessellatorColor(tessellator, this.activeRimColor);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
                this.setTessellatorColor(tessellator, this.activeInWallColor);
                renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, icon);
                renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case NorthWest: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, dim, 1.0f, dim);
                renderer.func_147775_a((Block)block);
                this.setTessellatorColor(tessellator, this.activeRimColor);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
                this.setTessellatorColor(tessellator, this.activeInWallColor);
                renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, icon);
                renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case SouthEast: {
                block.func_149676_a(1.0f - dim, 0.0f, 1.0f - dim, 1.0f, 1.0f, 1.0f);
                renderer.func_147775_a((Block)block);
                this.setTessellatorColor(tessellator, this.activeRimColor);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
                this.setTessellatorColor(tessellator, this.activeInWallColor);
                renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, icon);
                renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case SouthWest: {
                block.func_149676_a(0.0f, 0.0f, 1.0f - dim, dim, 1.0f, 1.0f);
                renderer.func_147775_a((Block)block);
                this.setTessellatorColor(tessellator, this.activeRimColor);
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, icon);
                this.setTessellatorColor(tessellator, this.activeInWallColor);
                renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, icon);
                renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, icon);
            }
        }
        block.func_149683_g();
        renderer.func_147775_a((Block)block);
    }

    private void calculateBaseColor(float[] target, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float gray = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float rg = (r * 30.0f + g * 70.0f) / 100.0f;
            float rb = (r * 30.0f + b * 70.0f) / 100.0f;
            r = gray;
            g = rg;
            b = rb;
        }
        target[0] = r;
        target[1] = g;
        target[2] = b;
    }

    private void scaleColor(float[] target, float[] source, float scale) {
        target[0] = source[0] * scale;
        target[1] = source[1] * scale;
        target[2] = source[2] * scale;
    }

    private void setTessellatorColor(Tessellator tessellator, float[] color) {
        tessellator.func_78386_a(color[0], color[1], color[2]);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.largePotRenderID;
    }
}

