/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block.support;

import com.google.common.base.Objects;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;

public final class UniqueMetaIdentifier {
    public final String modId;
    public final String name;
    public final int meta;

    public UniqueMetaIdentifier(String modId, String name, int meta) {
        this.modId = modId;
        this.name = name;
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String qualifiedName, int meta) {
        String[] parts = qualifiedName.split(":");
        this.modId = parts[0];
        this.name = parts[1];
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String compoundName) {
        String[] parts1 = compoundName.split(";");
        String[] parts2 = parts1[0].split(":");
        this.modId = parts2[0];
        this.name = parts2[1];
        this.meta = Integer.parseInt(parts1[1]);
    }

    public UniqueMetaIdentifier(String compoundName, char separator) {
        String[] parts1 = compoundName.split("[ ]*" + separator + "[ ]*");
        String[] parts2 = parts1[0].split(":");
        this.modId = parts2[0];
        this.name = parts2[1];
        this.meta = Integer.parseInt(parts1[1]);
    }

    public GameRegistry.UniqueIdentifier getUniqueIdentifier() {
        return new GameRegistry.UniqueIdentifier(this.modId + ":" + this.name);
    }

    public Block getBlock() {
        return GameRegistry.findBlock((String)this.modId, (String)this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UniqueMetaIdentifier other = (UniqueMetaIdentifier)obj;
        return Objects.equal((Object)this.modId, (Object)other.modId) && Objects.equal((Object)this.name, (Object)other.name) && this.meta == other.meta;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modId, this.name}) ^ this.meta * 37;
    }

    public String toString() {
        return String.format("%s:%s;%d", this.modId, this.name, this.meta);
    }
}

