/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block.support;

import com.jaquadro.minecraft.modularpots.block.support.UniqueMetaIdentifier;
import com.jaquadro.minecraft.modularpots.core.ModBlocks;
import com.jaquadro.minecraft.modularpots.core.ModItems;
import com.jaquadro.minecraft.modularpots.world.gen.feature.OrnamentalTreeFactory;
import com.jaquadro.minecraft.modularpots.world.gen.feature.OrnamentalTreeRegistry;
import com.jaquadro.minecraft.modularpots.world.gen.feature.WorldGenOrnamentalTree;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;

public class SaplingRegistry {
    private static final Map<UniqueMetaIdentifier, SaplingRecord> registry = new HashMap<UniqueMetaIdentifier, SaplingRecord>();

    public static boolean registerSapling(UniqueMetaIdentifier sapling, UniqueMetaIdentifier wood, UniqueMetaIdentifier leaf, String generatorName) {
        OrnamentalTreeFactory tree = OrnamentalTreeRegistry.getTree(generatorName);
        if (tree == null) {
            return false;
        }
        WorldGenOrnamentalTree generator = tree.create(wood.getBlock(), wood.meta, leaf.getBlock(), leaf.meta);
        SaplingRecord record = new SaplingRecord();
        record.saplingType = sapling;
        record.woodType = wood;
        record.leafType = leaf;
        record.generator = generator;
        registry.put(sapling, record);
        return true;
    }

    public static boolean registerSapling(Item sapling, int saplingMeta, Block wood, int woodMeta, Block leaf, int leafMeta, String generatorName) {
        return SaplingRegistry.registerSapling(ModItems.getUniqueMetaID(sapling, saplingMeta), ModBlocks.getUniqueMetaID(wood, woodMeta), ModBlocks.getUniqueMetaID(leaf, leafMeta), generatorName);
    }

    public static WorldGenOrnamentalTree getGenerator(Block block, int meta) {
        UniqueMetaIdentifier id = ModBlocks.getUniqueMetaID(block, meta);
        if (!registry.containsKey(id)) {
            return null;
        }
        SaplingRecord record = registry.get(id);
        return record.generator;
    }

    static {
        Item sapling = Item.func_150898_a((Block)Blocks.field_150345_g);
        SaplingRegistry.registerSapling(sapling, 0, Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0, "small_oak");
        SaplingRegistry.registerSapling(sapling, 1, Blocks.field_150364_r, 1, (Block)Blocks.field_150362_t, 1, "small_spruce");
        SaplingRegistry.registerSapling(sapling, 2, Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2, "small_oak");
        SaplingRegistry.registerSapling(sapling, 3, Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, "small_jungle");
        SaplingRegistry.registerSapling(sapling, 4, Blocks.field_150363_s, 0, (Block)Blocks.field_150361_u, 0, "small_acacia");
        SaplingRegistry.registerSapling(sapling, 5, Blocks.field_150363_s, 1, (Block)Blocks.field_150361_u, 1, "small_oak");
    }

    public static class SaplingRecord {
        public UniqueMetaIdentifier saplingType;
        public UniqueMetaIdentifier woodType;
        public UniqueMetaIdentifier leafType;
        public WorldGenOrnamentalTree generator;
    }
}

