/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block;

import com.jaquadro.minecraft.modularpots.ModularPots;
import com.jaquadro.minecraft.modularpots.block.support.UniqueMetaIdentifier;
import com.jaquadro.minecraft.modularpots.block.support.WoodRegistry;
import com.jaquadro.minecraft.modularpots.client.ClientProxy;
import com.jaquadro.minecraft.modularpots.core.ModBlocks;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityWoodProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockThinLog
extends BlockContainer {
    public static final String[] subNames = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};
    private int orientation;
    private int scratchDropMetadata;

    public BlockThinLog(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModularPots.tabModularPots);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.func_149683_g();
    }

    public float getMargin() {
        return 0.25f;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void func_149683_g() {
        float margin = this.getMargin();
        this.func_149676_a(margin, 0.0f, margin, 1.0f - margin, 1.0f, 1.0f - margin);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        int connectFlags = this.calcConnectionFlags((IBlockAccess)world, x, y, z);
        float margin = this.getMargin();
        float ys = (connectFlags & 1) != 0 ? 0.0f : margin;
        float ye = (connectFlags & 2) != 0 ? 1.0f : 1.0f - margin;
        float zs = (connectFlags & 4) != 0 ? 0.0f : margin;
        float ze = (connectFlags & 8) != 0 ? 1.0f : 1.0f - margin;
        float xs = (connectFlags & 0x10) != 0 ? 0.0f : margin;
        float xe = (connectFlags & 0x20) != 0 ? 1.0f : 1.0f - margin;
        this.func_149676_a(xs, ys, zs, xe, ye, ze);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int connectFlags = this.calcConnectionFlags(world, x, y, z);
        float margin = this.getMargin();
        float ys = (connectFlags & 1) != 0 ? 0.0f : margin;
        float ye = (connectFlags & 2) != 0 ? 1.0f : 1.0f - margin;
        float zs = (connectFlags & 4) != 0 ? 0.0f : margin;
        float ze = (connectFlags & 8) != 0 ? 1.0f : 1.0f - margin;
        float xs = (connectFlags & 0x10) != 0 ? 0.0f : margin;
        float xe = (connectFlags & 0x20) != 0 ? 1.0f : 1.0f - margin;
        this.func_149676_a(xs, ys, zs, xe, ye, ze);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public int func_149645_b() {
        return ClientProxy.thinLogRenderID;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityWoodProxy te;
        int range = 4;
        int height = range + 1;
        if (world.func_72904_c(x - height, y - height, z - height, x + height, y + height, z + height)) {
            for (int dx = -range; dx <= range; ++dx) {
                for (int dy = -range; dy <= range; ++dy) {
                    for (int dz = -range; dz <= range; ++dz) {
                        Block leaf = world.func_147439_a(x + dx, y + dy, z + dz);
                        if (!leaf.isLeaves((IBlockAccess)world, x + dx, y + dy, z + dz)) continue;
                        leaf.beginLeavesDecay(world, x + dx, y + dy, z + dz);
                    }
                }
            }
        }
        this.scratchDropMetadata = (te = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && te.getProtoBlock() != null ? TileEntityWoodProxy.composeMetadata(te.getProtoBlock(), te.getProtoMeta()) : 0;
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149692_a(int meta) {
        int damage = this.scratchDropMetadata > 0 ? this.scratchDropMetadata : meta;
        this.scratchDropMetadata = 0;
        return damage;
    }

    public int calcConnectionFlags(IBlockAccess world, int x, int y, int z) {
        boolean connectXPos;
        boolean connectXNeg;
        boolean connectZPos;
        int flagsY = this.calcConnectYFlags(world, x, y, z);
        int flagsZNeg = this.calcConnectYFlags(world, x, y, z - 1);
        int flagsZPos = this.calcConnectYFlags(world, x, y, z + 1);
        int flagsXNeg = this.calcConnectYFlags(world, x - 1, y, z);
        int flagsXPos = this.calcConnectYFlags(world, x + 1, y, z);
        int connectFlagsY = flagsY & 3;
        int connectFlagsZNeg = flagsZNeg & 3;
        int connectFlagsZPos = flagsZPos & 3;
        int connectFlagsXNeg = flagsXNeg & 3;
        int connectFlagsXPos = flagsXPos & 3;
        Block blockZNeg = world.func_147439_a(x, y, z - 1);
        Block blockZPos = world.func_147439_a(x, y, z + 1);
        Block blockXNeg = world.func_147439_a(x - 1, y, z);
        Block blockXPos = world.func_147439_a(x + 1, y, z);
        boolean hardZNeg = this.isNeighborHardConnection(blockZNeg) || blockZNeg instanceof BlockTorch;
        boolean hardZPos = this.isNeighborHardConnection(blockZPos) || blockZPos instanceof BlockTorch;
        boolean hardXNeg = this.isNeighborHardConnection(blockXNeg) || blockXNeg instanceof BlockTorch;
        boolean hardXPos = this.isNeighborHardConnection(blockXPos) || blockXPos instanceof BlockTorch;
        boolean hardConnection = (flagsY & 4) != 0;
        boolean hardConnectionZNeg = hardConnection && (flagsZNeg & 4) != 0;
        boolean hardConnectionZPos = hardConnection && (flagsZPos & 4) != 0;
        boolean hardConnectionXNeg = hardConnection && (flagsXNeg & 4) != 0;
        boolean hardConnectionXPos = hardConnection && (flagsXPos & 4) != 0;
        boolean connectZNeg = connectFlagsY == 0 && hardZNeg || blockZNeg == this && !hardConnectionZNeg && (connectFlagsY != 3 || connectFlagsZNeg != 3);
        boolean connectSide = connectZNeg | (connectZPos = connectFlagsY == 0 && hardZPos || blockZPos == this && !hardConnectionZPos && (connectFlagsY != 3 || connectFlagsZPos != 3)) | (connectXNeg = connectFlagsY == 0 && hardXNeg || blockXNeg == this && !hardConnectionXNeg && (connectFlagsY != 3 || connectFlagsXNeg != 3)) | (connectXPos = connectFlagsY == 0 && hardXPos || blockXPos == this && !hardConnectionXPos && (connectFlagsY != 3 || connectFlagsXPos != 3));
        if (!connectSide && (connectFlagsY & 1) == 0) {
            if (hardZNeg) {
                connectZNeg = true;
            }
            if (hardZPos) {
                connectZPos = true;
            }
            if (hardXNeg) {
                connectXNeg = true;
            }
            if (hardXPos) {
                connectXPos = true;
            }
        }
        if (!(connectZNeg | connectZPos | connectXNeg | connectXPos)) {
            connectFlagsY = 3;
        }
        if (connectFlagsY == 2 && hardZNeg) {
            connectZNeg = true;
        }
        if (connectFlagsY == 2 && hardZPos) {
            connectZPos = true;
        }
        if (connectFlagsY == 2 && hardXNeg) {
            connectXNeg = true;
        }
        if (connectFlagsY == 2 && hardXPos) {
            connectXPos = true;
        }
        return connectFlagsY | (connectZNeg ? 4 : 0) | (connectZPos ? 8 : 0) | (connectXNeg ? 16 : 0) | (connectXPos ? 32 : 0);
    }

    private int calcConnectYFlags(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return 0;
        }
        Block blockYNeg = world.func_147439_a(x, y - 1, z);
        boolean hardYNeg = this.isNeighborHardConnectionY(blockYNeg);
        boolean connectYNeg = hardYNeg || blockYNeg == this;
        Block blockYPos = world.func_147439_a(x, y + 1, z);
        boolean hardYPos = this.isNeighborHardConnectionY(blockYPos);
        boolean connectYPos = hardYPos || blockYPos == this || blockYPos instanceof BlockTorch;
        return (connectYNeg ? 1 : 0) | (connectYPos ? 2 : 0) | (hardYNeg ? 4 : 0) | (hardYPos ? 8 : 0);
    }

    private boolean isNeighborHardConnection(Block block) {
        if (block.func_149688_o().func_76218_k() && block.func_149686_d()) {
            return true;
        }
        return block == ModBlocks.largePot;
    }

    private boolean isNeighborHardConnectionY(Block block) {
        if (this.isNeighborHardConnection(block)) {
            return true;
        }
        return block instanceof BlockLeavesBase || block == ModBlocks.thinLogFence;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 6; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
        for (Map.Entry<UniqueMetaIdentifier, Block> entry : WoodRegistry.registeredTypes()) {
            int id = TileEntityWoodProxy.composeMetadata(entry.getValue(), entry.getKey().meta);
            blockList.add(new ItemStack(item, 1, id));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int ometa = 0;
        if (this.orientation == 1) {
            ometa |= 8;
        } else if (this.orientation == 2) {
            ometa |= 4;
        } else if (this.orientation == 3) {
            ometa |= 0xC;
        }
        int protoMeta = TileEntityWoodProxy.getMetaFromComposedMetadata(meta);
        Block protoBlock = TileEntityWoodProxy.getBlockFromComposedMetadata(meta);
        if (protoBlock == null) {
            protoBlock = this.getIconSource(meta);
        }
        return protoBlock.func_149691_a(side, protoMeta | ometa);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityWoodProxy te = this.getTileEntity(blockAccess, x, y, z);
        if (te == null || te.getProtoBlock() == null) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
        int ometa = 0;
        if (this.orientation == 1) {
            ometa |= 8;
        } else if (this.orientation == 2) {
            ometa |= 4;
        } else if (this.orientation == 3) {
            ometa |= 0xC;
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
        }
        return protoBlock.func_149691_a(side, protoMeta | ometa);
    }

    private Block getIconSource(int meta) {
        switch (meta / 4) {
            case 0: {
                return Blocks.field_150364_r;
            }
            case 1: {
                return Blocks.field_150363_s;
            }
        }
        return Blocks.field_150364_r;
    }

    private TileEntityWoodProxy getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityWoodProxy) {
            return (TileEntityWoodProxy)te;
        }
        return null;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWoodProxy();
    }
}

