/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.block;

import com.jaquadro.minecraft.modularpots.ModularPots;
import com.jaquadro.minecraft.modularpots.tileentity.TileEntityPotteryTable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockPotteryTable
extends BlockContainer {
    private final Random rand = new Random();
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;

    public BlockPotteryTable(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModularPots.tabModularPots);
        this.func_149711_c(2.5f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setBlockDirection(world, x, y, z);
    }

    private void setBlockDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block blockZNeg = world.func_147439_a(x, y, z - 1);
            Block blockZPos = world.func_147439_a(x, y, z + 1);
            Block blockXNeg = world.func_147439_a(x - 1, y, z);
            Block blockXPos = world.func_147439_a(x + 1, y, z);
            int dir = 3;
            if (blockZNeg.func_149730_j() && !blockZPos.func_149730_j()) {
                dir = 3;
            }
            if (blockZPos.func_149730_j() && !blockZNeg.func_149730_j()) {
                dir = 2;
            }
            if (blockXNeg.func_149730_j() && !blockXPos.func_149730_j()) {
                dir = 5;
            }
            if (blockXPos.func_149730_j() && !blockXNeg.func_149730_j()) {
                dir = 4;
            }
            world.func_72921_c(x, y, z, dir, 2);
        }
    }

    public TileEntity func_149915_a(World world, int data) {
        return new TileEntityPotteryTable();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        player.openGui((Object)ModularPots.instance, ModularPots.potteryTableGuiID, world, x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntityPotteryTable te = (TileEntityPotteryTable)world.func_147438_o(x, y, z);
        if (te != null) {
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack stack = te.func_70301_a(i);
                if (stack == null) continue;
                float ex = this.rand.nextFloat() * 0.8f + 0.1f;
                float ey = this.rand.nextFloat() * 0.8f + 0.1f;
                float ez = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int stackPartSize = this.rand.nextInt(21) + 10;
                    if (stackPartSize > stack.field_77994_a) {
                        stackPartSize = stack.field_77994_a;
                    }
                    stack.field_77994_a -= stackPartSize;
                    EntityItem entity = new EntityItem(world, (double)((float)x + ex), (double)((float)y + ey), (double)((float)z + ez), new ItemStack(stack.func_77973_b(), stackPartSize, stack.func_77960_j()));
                    float motionUnit = 0.05f;
                    entity.field_70159_w = this.rand.nextGaussian() * (double)motionUnit;
                    entity.field_70181_x = this.rand.nextGaussian() * (double)motionUnit + (double)0.2f;
                    entity.field_70179_y = this.rand.nextGaussian() * (double)motionUnit;
                    if (stack.func_77942_o()) {
                        entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entity);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int data) {
        if (side == 0) {
            return Blocks.field_150344_f.func_149733_h(side);
        }
        if (side == 1) {
            return this.iconTop;
        }
        if (side == data) {
            return this.field_149761_L;
        }
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("modularpots:pottery_table_front");
        this.iconSide = iconRegister.func_94245_a("modularpots:pottery_table_side");
        this.iconTop = iconRegister.func_94245_a("modularpots:pottery_table_top");
    }
}

