/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.addon;

import com.jaquadro.minecraft.modularpots.addon.IPlantHandler;
import com.jaquadro.minecraft.modularpots.addon.ModPlantMegaPackHandler;
import com.jaquadro.minecraft.modularpots.addon.ModPlantMegaPackLegacyHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;

public class PlantHandlerRegistry {
    private static final List<IPlantHandler> handlers = new ArrayList<IPlantHandler>();

    public static void init() {
        if (!PlantHandlerRegistry.register(new ModPlantMegaPackHandler())) {
            PlantHandlerRegistry.register(new ModPlantMegaPackLegacyHandler());
        }
    }

    public static boolean register(IPlantHandler handler) {
        if (handler.init()) {
            handlers.add(handler);
            return true;
        }
        return false;
    }

    public static boolean applyBonemeal(World world, int x, int y, int z) {
        for (IPlantHandler handler : handlers) {
            if (!handler.applyBonemeal(world, x, y, z)) continue;
            return true;
        }
        return false;
    }
}

