/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.addon;

import com.jaquadro.minecraft.modularpots.addon.IPlantHandler;
import com.jaquadro.minecraft.modularpots.block.BlockLargePotPlantProxy;
import com.jaquadro.minecraft.modularpots.core.ModBlocks;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class ModPlantMegaPackLegacyHandler
implements IPlantHandler {
    private static final String MOD_ID = "plantmegapack";
    private static final String PLANT_BLOCK_CLASS = "plantmegapack.bin.PMPBlockPlant";
    private static Class<?> plantBlockClass;
    private static Method plantGrowAction;

    @Override
    public boolean init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return false;
        }
        try {
            plantBlockClass = Class.forName(PLANT_BLOCK_CLASS);
            if (plantBlockClass == null) {
                return false;
            }
            plantGrowAction = plantBlockClass.getDeclaredMethod("growPlant", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            if (plantGrowAction == null) {
                return false;
            }
            FMLLog.log((String)"modularpots", (Level)Level.INFO, (String)"Initialized Plant Mega Pack legacy handler.", (Object[])new Object[0]);
            return true;
        }
        catch (Exception e) {
            FMLLog.log((String)"modularpots", (Level)Level.ERROR, (String)"Could not initialize the Plant Mega Pack legacy handler", (Object[])new Object[0]);
            FMLLog.log((String)"modularpots", (Level)Level.ERROR, (String)("Encountered load exception: " + e.getMessage()), (Object[])new Object[0]);
            return false;
        }
    }

    @Override
    public boolean applyBonemeal(World world, int x, int y, int z) {
        BlockLargePotPlantProxy proxy = (BlockLargePotPlantProxy)world.func_147439_a(x, y, z);
        if (proxy == null) {
            return false;
        }
        Block block = proxy.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            return false;
        }
        if (!plantBlockClass.isAssignableFrom(block.getClass())) {
            return false;
        }
        if (world.func_147439_a(x, y + 1, z) == ModBlocks.largePotPlantProxy) {
            world.func_147465_d(x, y + 1, z, block, world.func_72805_g(x, y + 1, z), 4);
        }
        world.func_147465_d(x, y, z, block, world.func_72805_g(x, y, z), 4);
        if (world.func_147439_a(x, y - 1, z) == ModBlocks.largePotPlantProxy) {
            world.func_147465_d(x, y - 1, z, block, world.func_72805_g(x, y - 1, z), 4);
        }
        Boolean result = false;
        try {
            result = (Boolean)plantGrowAction.invoke((Object)block, world, x, y, z);
        }
        catch (Exception e) {
            System.out.println("[MFP] Error encountered in Plant Mega Pack Legacy handler.");
            result = false;
        }
        if (world.func_147439_a(x, y + 1, z) == block) {
            world.func_147465_d(x, y + 1, z, (Block)ModBlocks.largePotPlantProxy, world.func_72805_g(x, y + 1, z), 2);
        }
        world.func_147465_d(x, y, z, (Block)ModBlocks.largePotPlantProxy, world.func_72805_g(x, y, z), 2);
        if (world.func_147439_a(x, y - 1, z) == block) {
            world.func_147465_d(x, y - 1, z, (Block)ModBlocks.largePotPlantProxy, world.func_72805_g(x, y - 1, z), 2);
        }
        return result;
    }
}

