/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.addon;

import com.jaquadro.minecraft.modularpots.addon.IPlantHandler;
import com.jaquadro.minecraft.modularpots.block.BlockLargePotPlantProxy;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class ModPlantMegaPackHandler
implements IPlantHandler {
    private static final String MOD_ID = "plantmegapack";
    private static final String PLANT_BLOCK_CLASS = "plantmegapack.bin.PMPBlockPlant";
    private static final String PLANT_API_EVENTS_CLASS = "plantmegapack.api.PMPEvents";
    private static Class<?> plantBlockClass;
    private static Class<?> apiEventClass;
    private static Method apiApplyBonemeal;

    @Override
    public boolean init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return false;
        }
        try {
            plantBlockClass = Class.forName(PLANT_BLOCK_CLASS);
            if (plantBlockClass == null) {
                return false;
            }
            apiEventClass = Class.forName(PLANT_API_EVENTS_CLASS);
            if (apiEventClass == null) {
                return false;
            }
            apiApplyBonemeal = apiEventClass.getDeclaredMethod("applyBoneMeal", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Block.class);
            if (apiApplyBonemeal == null) {
                return false;
            }
            FMLLog.log((String)"modularpots", (Level)Level.INFO, (String)"Initialized Plant Mega Pack handler.", (Object[])new Object[0]);
            return true;
        }
        catch (Exception e) {
            FMLLog.log((String)"modularpots", (Level)Level.ERROR, (String)"Could not initialize the Plant Mega Pack handler.", (Object[])new Object[0]);
            FMLLog.log((String)"modularpots", (Level)Level.ERROR, (String)("Encountered load exception: " + e.getMessage()), (Object[])new Object[0]);
            return false;
        }
    }

    @Override
    public boolean applyBonemeal(World world, int x, int y, int z) {
        BlockLargePotPlantProxy proxy = (BlockLargePotPlantProxy)world.func_147439_a(x, y, z);
        if (proxy == null) {
            return false;
        }
        Block block = proxy.getItemBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            return false;
        }
        if (!plantBlockClass.isAssignableFrom(block.getClass())) {
            return false;
        }
        Boolean result = false;
        try {
            result = (Boolean)apiApplyBonemeal.invoke(null, world, x, y, z, block);
        }
        catch (Exception e) {
            FMLLog.log((String)"modularpots", (Level)Level.ERROR, (Throwable)e, (String)"Failed to apply bonemeal in Plant Mega Pack handler.", (Object[])new Object[0]);
            result = false;
        }
        return result;
    }
}

