/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots;

import com.jaquadro.minecraft.modularpots.CommonProxy;
import com.jaquadro.minecraft.modularpots.addon.PlantHandlerRegistry;
import com.jaquadro.minecraft.modularpots.block.BlockLargePotPlantProxy;
import com.jaquadro.minecraft.modularpots.config.ConfigManager;
import com.jaquadro.minecraft.modularpots.config.PatternConfig;
import com.jaquadro.minecraft.modularpots.core.ModBlocks;
import com.jaquadro.minecraft.modularpots.core.ModIntegration;
import com.jaquadro.minecraft.modularpots.core.ModItems;
import com.jaquadro.minecraft.modularpots.core.ModRecipes;
import com.jaquadro.minecraft.modularpots.core.handlers.GuiHandler;
import com.jaquadro.minecraft.modularpots.core.handlers.VillagerTradeHandler;
import com.jaquadro.minecraft.modularpots.creativetab.ModularPotsCreativeTab;
import com.jaquadro.minecraft.modularpots.item.ItemThinLog;
import com.jaquadro.minecraft.modularpots.registry.PlantRegistry;
import com.jaquadro.minecraft.modularpots.registry.RegistryGroup;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;

@Mod(modid="modularpots", name="Modular Flower Pots", version="1.7.10.14")
public class ModularPots {
    public static final String MOD_ID = "modularpots";
    static final String MOD_NAME = "Modular Flower Pots";
    static final String MOD_VERSION = "1.7.10.14";
    static final String SOURCE_PATH = "com.jaquadro.minecraft.modularpots.";
    public static CreativeTabs tabModularPots = new ModularPotsCreativeTab("modularPots");
    public static final ModBlocks blocks = new ModBlocks();
    public static final ModItems items = new ModItems();
    public static final ModRecipes recipes = new ModRecipes();
    public static final ModIntegration integration = new ModIntegration();
    public static int potteryTableGuiID = 0;
    public static ConfigManager config;
    @Mod.Instance(value="modularpots")
    public static ModularPots instance;
    @SidedProxy(clientSide="com.jaquadro.minecraft.modularpots.client.ClientProxy", serverSide="com.jaquadro.minecraft.modularpots.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new ConfigManager(new File(event.getModConfigurationDirectory(), "modularpots.patterns.cfg"));
        blocks.init();
        items.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        for (int i = 1; i < 256; ++i) {
            if (!config.hasPattern(i)) continue;
            PatternConfig pattern = config.getPattern(i);
            for (int j = 0; j < pattern.getLocationCount(); ++j) {
                ChestGenHooks.addItem((String)pattern.getGenLocation(j), (WeightedRandomChestContent)new WeightedRandomChestContent((Item)ModItems.potteryPattern, i, 1, 1, pattern.getGenRarity(j)));
            }
        }
        VillagerTradeHandler.instance().load();
        integration.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PlantHandlerRegistry.init();
        integration.postInit();
        recipes.init();
    }

    @Mod.EventHandler
    public void interModComs(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equals("plantBlacklist")) {
                if (message.isItemStackMessage()) {
                    PlantRegistry.instance().addToBlacklist(message.getItemStackValue());
                    continue;
                }
                if (!message.isNBTMessage()) continue;
                PlantRegistry.instance().addToBlacklist(message.getNBTValue());
                continue;
            }
            if (!message.key.equals("bonemealBlacklist")) continue;
            if (message.isItemStackMessage()) {
                PlantRegistry.instance().addToBlacklist(message.getItemStackValue(), RegistryGroup.Bonemeal);
                continue;
            }
            if (!message.isNBTMessage()) continue;
            PlantRegistry.instance().addToBlacklist(message.getNBTValue(), RegistryGroup.Bonemeal);
        }
    }

    @SubscribeEvent
    public void applyBonemeal(BonemealEvent event) {
        if (event.block == ModBlocks.largePotPlantProxy) {
            BlockLargePotPlantProxy proxyBlock = ModBlocks.largePotPlantProxy;
            if (proxyBlock.applyBonemeal(event.world, event.x, event.y, event.z)) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void handleCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() instanceof ItemThinLog) {
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack item = event.craftMatrix.func_70301_a(i);
                if (item == null || !this.isValidAxe(item) || item.func_77960_j() >= item.func_77958_k()) continue;
                event.craftMatrix.func_70299_a(i, new ItemStack(item.func_77973_b(), item.field_77994_a + 1, item.func_77960_j() + 1));
            }
        }
    }

    private boolean isValidAxe(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item == Items.field_151053_p || item == Items.field_151049_t || item == Items.field_151036_c || item == Items.field_151006_E || item == Items.field_151056_x;
    }
}

