/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.UUID;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntitySlimelingEgg;
import micdoodle8.mods.miccore.MicdoodleTransformer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class VersionUtil {
    private static DefaultArtifactVersion mcVersion = null;
    private static boolean deobfuscated = true;
    private static HashMap<String, MicdoodleTransformer.ObfuscationEntry> nodemap = Maps.newHashMap();
    private static HashMap<Integer, Object> reflectionCache = Maps.newHashMap();
    private static final String KEY_CLASS_COMPRESSED_STREAM_TOOLS = "compressedStreamTools";
    private static final String KEY_CLASS_NBT_SIZE_TRACKER = "nbtSizeTracker";
    private static final String KEY_CLASS_YGG_CONVERTER = "preYggdrasilConverter";
    private static final String KEY_CLASS_TEXTURE_UTIL = "textureUtil";
    private static final String KEY_CLASS_COMMAND_BASE = "commandBase";
    private static final String KEY_CLASS_SCALED_RES = "scaledResolution";
    private static final String KEY_CLASS_RENDER_PLAYER = "renderPlayer";
    private static final String KEY_METHOD_SET_OWNER = "setOwner";
    private static final String KEY_METHOD_GET_OWNER = "getOwnerName";
    private static final String KEY_METHOD_CONVERT_UUID = "yggdrasilConvert";
    private static final String KEY_METHOD_DECOMPRESS_NBT = "decompress";
    private static final String KEY_METHOD_SET_MIPMAP = "setMipMap";
    private static final String KEY_METHOD_NOTIFY_ADMINS = "notifyAdmins";
    private static final String KEY_METHOD_PLAYER_FOR_NAME = "getPlayerForUsername";
    private static final String KEY_METHOD_PLAYER_IS_OPPED = "isPlayerOpped";
    private static final String KEY_METHOD_PLAYER_TEXTURE = "getEntityTexture";

    public static boolean mcVersionMatches(String version) {
        return VersionParser.parseRange((String)("[" + version + "]")).containsVersion((ArtifactVersion)mcVersion);
    }

    @Optional.Method(modid="GalacticraftMars")
    public static void setSlimelingOwner(EntitySlimeling slimeling, String ownerName) {
        try {
            Method m = (Method)reflectionCache.get(0);
            if (m == null) {
                m = slimeling.getClass().getSuperclass().getMethod(VersionUtil.getNameDynamic(KEY_METHOD_SET_OWNER), String.class);
                reflectionCache.put(0, m);
            }
            m.invoke((Object)slimeling, ownerName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String getSlimelingOwner(EntitySlimeling slimeling) {
        try {
            Method m = (Method)reflectionCache.get(1);
            if (m == null) {
                m = slimeling.getClass().getMethod(VersionUtil.getNameDynamic(KEY_METHOD_GET_OWNER), new Class[0]);
                reflectionCache.put(1, m);
            }
            return (String)m.invoke((Object)slimeling, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    public static void readSlimelingEggFromNBT(TileEntitySlimelingEgg egg, NBTTagCompound nbt) {
        try {
            String s = "";
            if (nbt.func_150297_b("OwnerUUID", 8)) {
                s = nbt.func_74779_i("OwnerUUID");
            } else if (VersionUtil.mcVersionMatches("1.7.10")) {
                Method m;
                Class<?> c = (Class<?>)reflectionCache.get(2);
                if (c == null) {
                    c = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_YGG_CONVERTER).replace('/', '.'));
                    reflectionCache.put(2, c);
                }
                if ((m = (Method)reflectionCache.get(3)) == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_CONVERT_UUID), String.class);
                    reflectionCache.put(3, m);
                }
                String s1 = nbt.func_74779_i("Owner");
                s = (String)m.invoke(null, s1);
            }
            if (s.length() > 0) {
                egg.lastTouchedPlayerUUID = s;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static NBTTagCompound decompressNBT(byte[] compressedNBT) {
        try {
            Class<?> c = (Class<?>)reflectionCache.get(4);
            if (c == null) {
                c = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_COMPRESSED_STREAM_TOOLS).replace('/', '.'));
                reflectionCache.put(4, c);
            }
            if (VersionUtil.mcVersionMatches("1.7.10")) {
                Class<?> c0 = (Class<?>)reflectionCache.get(5);
                Method m = (Method)reflectionCache.get(6);
                if (c0 == null) {
                    c0 = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_NBT_SIZE_TRACKER).replace('/', '.'));
                    reflectionCache.put(5, c0);
                }
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_DECOMPRESS_NBT), byte[].class, c0);
                    reflectionCache.put(6, m);
                }
                Object nbtSizeTracker = c0.getConstructor(Long.TYPE).newInstance(0x200000L);
                return (NBTTagCompound)m.invoke(null, compressedNBT, nbtSizeTracker);
            }
            if (VersionUtil.mcVersionMatches("1.7.2")) {
                Method m = (Method)reflectionCache.get(6);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_DECOMPRESS_NBT), byte[].class);
                    reflectionCache.put(6, m);
                }
                return (NBTTagCompound)m.invoke(null, new Object[]{compressedNBT});
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static void setMipMap(boolean b0, boolean b1) {
        try {
            Class<?> c = (Class<?>)reflectionCache.get(7);
            if (c == null) {
                c = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_TEXTURE_UTIL).replace('/', '.'));
                reflectionCache.put(7, c);
            }
            if (VersionUtil.mcVersionMatches("1.7.10")) {
                Method m = (Method)reflectionCache.get(8);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_SET_MIPMAP), Boolean.TYPE, Boolean.TYPE, Float.TYPE);
                    reflectionCache.put(8, m);
                }
                m.invoke(null, b0, b1, Float.valueOf(1.0f));
            } else if (VersionUtil.mcVersionMatches("1.7.2")) {
                Method m = (Method)reflectionCache.get(8);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_SET_MIPMAP), Boolean.TYPE, Boolean.TYPE);
                    reflectionCache.put(8, m);
                }
                m.invoke(null, b0, b1);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void notifyAdmins(ICommandSender sender, ICommand command, String name, Object ... objects) {
        try {
            Class<?> c = (Class<?>)reflectionCache.get(9);
            if (c == null) {
                c = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_COMMAND_BASE).replace('/', '.'));
                reflectionCache.put(9, c);
            }
            if (VersionUtil.mcVersionMatches("1.7.10")) {
                Method m = (Method)reflectionCache.get(10);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_NOTIFY_ADMINS), ICommandSender.class, ICommand.class, String.class, Object[].class);
                    reflectionCache.put(10, m);
                }
                m.invoke(null, sender, command, name, objects);
            } else if (VersionUtil.mcVersionMatches("1.7.2")) {
                Method m = (Method)reflectionCache.get(10);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_NOTIFY_ADMINS), ICommandSender.class, String.class, Object[].class);
                    reflectionCache.put(10, m);
                }
                m.invoke(null, sender, name, objects);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static EntityPlayerMP getPlayerForUsername(MinecraftServer server, String username) {
        try {
            Method m;
            Class<?> c = (Class<?>)reflectionCache.get(11);
            if (c == null) {
                c = server.func_71203_ab().getClass();
                reflectionCache.put(11, c);
            }
            if ((m = (Method)reflectionCache.get(12)) == null) {
                m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_PLAYER_FOR_NAME), String.class);
                reflectionCache.put(12, m);
            }
            return (EntityPlayerMP)m.invoke((Object)server.func_71203_ab(), username);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static boolean isPlayerOpped(EntityPlayerMP player) {
        try {
            Class<?> c = (Class<?>)reflectionCache.get(13);
            if (c == null) {
                c = player.field_71133_b.func_71203_ab().getClass();
                reflectionCache.put(13, c);
            }
            if (VersionUtil.mcVersionMatches("1.7.10")) {
                Method m = (Method)reflectionCache.get(14);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_PLAYER_IS_OPPED), GameProfile.class);
                    reflectionCache.put(14, m);
                }
                return (Boolean)m.invoke((Object)player.field_71133_b.func_71203_ab(), player.func_146103_bH());
            }
            if (VersionUtil.mcVersionMatches("1.7.2")) {
                Method m = (Method)reflectionCache.get(14);
                if (m == null) {
                    m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_PLAYER_IS_OPPED), String.class);
                    reflectionCache.put(14, m);
                }
                return (Boolean)m.invoke((Object)player.field_71133_b.func_71203_ab(), player.func_146103_bH().getName());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static ScaledResolution getScaledRes(Minecraft mc, int width, int height) {
        try {
            Class<?> c = (Class<?>)reflectionCache.get(15);
            if (c == null) {
                c = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_SCALED_RES).replace('/', '.'));
                reflectionCache.put(15, c);
            }
            if (VersionUtil.mcVersionMatches("1.7.10")) {
                Constructor<?> m = (Constructor<?>)reflectionCache.get(16);
                if (m == null) {
                    m = c.getConstructor(Minecraft.class, Integer.TYPE, Integer.TYPE);
                    reflectionCache.put(16, m);
                }
                return (ScaledResolution)m.newInstance(mc, width, height);
            }
            if (VersionUtil.mcVersionMatches("1.7.2")) {
                Constructor<?> m = (Constructor<?>)reflectionCache.get(16);
                if (m == null) {
                    m = c.getConstructor(GameSettings.class, Integer.TYPE, Integer.TYPE);
                    reflectionCache.put(16, m);
                }
                return (ScaledResolution)m.newInstance(mc.field_71474_y, width, height);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static Method getPlayerTextureMethod() {
        try {
            Method m;
            Class<?> c = (Class<?>)reflectionCache.get(17);
            if (c == null) {
                c = Class.forName(VersionUtil.getNameDynamic(KEY_CLASS_RENDER_PLAYER).replace('/', '.'));
                reflectionCache.put(17, c);
            }
            if ((m = (Method)reflectionCache.get(18)) == null) {
                m = c.getMethod(VersionUtil.getNameDynamic(KEY_METHOD_PLAYER_TEXTURE), AbstractClientPlayer.class);
                m.setAccessible(true);
                reflectionCache.put(18, m);
            }
            return m;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static String getName(String keyName) {
        return VersionUtil.nodemap.get((Object)keyName).name;
    }

    private static String getObfName(String keyName) {
        return VersionUtil.nodemap.get((Object)keyName).obfuscatedName;
    }

    private static String getNameDynamic(String keyName) {
        try {
            if (deobfuscated) {
                return VersionUtil.getName(keyName);
            }
            return VersionUtil.getObfName(keyName);
        }
        catch (NullPointerException e) {
            System.err.println("Could not find key: " + keyName);
            throw e;
        }
    }

    public static GameProfile constructGameProfile(UUID uuid, String strName) {
        try {
            Class<?> c = (Class<?>)reflectionCache.get(19);
            if (c == null) {
                c = Class.forName("com.mojang.authlib.GameProfile");
                reflectionCache.put(19, c);
            }
            if (VersionUtil.mcVersionMatches("1.7.10")) {
                return (GameProfile)c.getConstructor(UUID.class, String.class).newInstance(uuid, strName);
            }
            if (VersionUtil.mcVersionMatches("1.7.2")) {
                return (GameProfile)c.getConstructor(String.class, String.class).newInstance(uuid.toString().replaceAll("-", ""), strName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    static {
        mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
        try {
            deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (VersionUtil.mcVersionMatches("1.7.10")) {
            nodemap.put(KEY_CLASS_COMPRESSED_STREAM_TOOLS, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/nbt/CompressedStreamTools"));
            nodemap.put(KEY_CLASS_NBT_SIZE_TRACKER, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/nbt/NBTSizeTracker"));
            nodemap.put(KEY_CLASS_YGG_CONVERTER, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/server/management/PreYggdrasilConverter"));
            nodemap.put(KEY_CLASS_TEXTURE_UTIL, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/client/renderer/texture/TextureUtil"));
            nodemap.put(KEY_CLASS_COMMAND_BASE, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/command/CommandBase"));
            nodemap.put(KEY_CLASS_SCALED_RES, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/client/gui/ScaledResolution"));
            nodemap.put(KEY_CLASS_RENDER_PLAYER, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/client/renderer/entity/RenderPlayer"));
            nodemap.put(KEY_METHOD_SET_OWNER, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152115_b", "func_152115_b", ""));
            nodemap.put(KEY_METHOD_GET_OWNER, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152113_b", "func_152113_b", ""));
            nodemap.put(KEY_METHOD_CONVERT_UUID, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152719_a", "func_152719_a", ""));
            nodemap.put(KEY_METHOD_DECOMPRESS_NBT, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152457_a", "func_152457_a", ""));
            nodemap.put(KEY_METHOD_SET_MIPMAP, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152777_a", "func_152777_a", ""));
            nodemap.put(KEY_METHOD_NOTIFY_ADMINS, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152373_a", "func_152373_a", ""));
            nodemap.put(KEY_METHOD_PLAYER_FOR_NAME, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152612_a", "func_152612_a", ""));
            nodemap.put(KEY_METHOD_PLAYER_IS_OPPED, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_152596_g", "func_152596_g", ""));
            nodemap.put(KEY_METHOD_PLAYER_TEXTURE, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_PLAYER_TEXTURE, "func_110775_a", ""));
        } else if (VersionUtil.mcVersionMatches("1.7.2")) {
            nodemap.put(KEY_CLASS_COMPRESSED_STREAM_TOOLS, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/nbt/CompressedStreamTools"));
            nodemap.put(KEY_CLASS_NBT_SIZE_TRACKER, new MicdoodleTransformer.ObfuscationEntry("", ""));
            nodemap.put(KEY_CLASS_YGG_CONVERTER, new MicdoodleTransformer.ObfuscationEntry("", ""));
            nodemap.put(KEY_CLASS_TEXTURE_UTIL, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/client/renderer/texture/TextureUtil"));
            nodemap.put(KEY_CLASS_COMMAND_BASE, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/command/CommandBase"));
            nodemap.put(KEY_CLASS_SCALED_RES, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/client/gui/ScaledResolution"));
            nodemap.put(KEY_CLASS_RENDER_PLAYER, new MicdoodleTransformer.ObfuscationEntry("net/minecraft/client/renderer/entity/RenderPlayer"));
            nodemap.put(KEY_METHOD_SET_OWNER, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_SET_OWNER, "func_70910_a", ""));
            nodemap.put(KEY_METHOD_GET_OWNER, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_GET_OWNER, "func_70905_p", ""));
            nodemap.put(KEY_METHOD_CONVERT_UUID, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("", "", ""));
            nodemap.put(KEY_METHOD_DECOMPRESS_NBT, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_DECOMPRESS_NBT, "func_74792_a", ""));
            nodemap.put(KEY_METHOD_SET_MIPMAP, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry("func_147950_a", "func_147950_a", ""));
            nodemap.put(KEY_METHOD_NOTIFY_ADMINS, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_NOTIFY_ADMINS, "func_71522_a", ""));
            nodemap.put(KEY_METHOD_PLAYER_FOR_NAME, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_PLAYER_FOR_NAME, "func_72361_f", ""));
            nodemap.put(KEY_METHOD_PLAYER_IS_OPPED, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_PLAYER_IS_OPPED, "func_72353_e", ""));
            nodemap.put(KEY_METHOD_PLAYER_TEXTURE, (MicdoodleTransformer.ObfuscationEntry)new MicdoodleTransformer.MethodObfuscationEntry(KEY_METHOD_PLAYER_TEXTURE, "func_110775_a", ""));
        }
    }
}

