/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraftforge.common.config.Configuration;

public class EnergyConfigHandler {
    private static Configuration config;
    public static float BC3_RATIO;
    public static float RF_RATIO;
    public static float IC2_RATIO;
    public static float MEKANISM_RATIO;
    private static int conversionLossFactor;
    public static float TO_BC_RATIO;
    public static float TO_RF_RATIO;
    public static float TO_IC2_RATIO;
    public static float TO_MEKANISM_RATIO;
    public static float TO_BC_RATIOdisp;
    public static float TO_RF_RATIOdisp;
    public static float TO_IC2_RATIOdisp;
    public static float TO_MEKANISM_RATIOdisp;
    public static Object gasOxygen;
    public static Object gasHydrogen;
    public static boolean displayEnergyUnitsBC;
    public static boolean displayEnergyUnitsIC2;
    public static boolean displayEnergyUnitsMek;
    public static boolean displayEnergyUnitsRF;
    private static boolean cachedIC2Loaded;
    private static boolean cachedIC2LoadedValue;
    private static boolean cachedBCLoaded;
    private static boolean cachedBCLoadedValue;
    private static boolean cachedBCReallyLoaded;
    private static boolean cachedBCReallyLoadedValue;
    private static int cachedBCVersion;
    private static boolean cachedMekLoaded;
    private static boolean cachedMekLoadedValue;
    private static boolean cachedRFLoaded;
    private static boolean cachedRFLoadedValue;
    private static boolean cachedRF1LoadedValue;
    private static boolean cachedRF2LoadedValue;
    private static boolean disableMJinterface;

    public static void setDefaultValues(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        config.load();
        IC2_RATIO = (float)config.get("Compatibility", "IndustrialCraft Conversion Ratio", (double)IC2_RATIO).getDouble((double)IC2_RATIO);
        RF_RATIO = (float)config.get("Compatibility", "RF Conversion Ratio", (double)RF_RATIO).getDouble((double)RF_RATIO);
        BC3_RATIO = (float)config.get("Compatibility", "BuildCraft Conversion Ratio", (double)BC3_RATIO).getDouble((double)BC3_RATIO);
        MEKANISM_RATIO = (float)config.get("Compatibility", "Mekanism Conversion Ratio", (double)MEKANISM_RATIO).getDouble((double)MEKANISM_RATIO);
        conversionLossFactor = config.get("Compatibility", "Loss factor when converting energy as a percentage (100 = no loss, 90 = 10% loss ...)", 100).getInt(100);
        if (conversionLossFactor > 100) {
            conversionLossFactor = 100;
        }
        EnergyConfigHandler.updateRatios();
        displayEnergyUnitsBC = config.get("Display", "If BuildCraft is loaded, show Galacticraft machines energy as MJ instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsIC2 = config.get("Display", "If IndustrialCraft2 is loaded, show Galacticraft machines energy as EU instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsMek = config.get("Display", "If Mekanism is loaded, show Galacticraft machines energy as Joules (J) instead of gJ?", false).getBoolean(false);
        displayEnergyUnitsRF = config.get("Display", "Show Galacticraft machines energy in RF instead of gJ?", false).getBoolean(false);
        disableMJinterface = config.get("Compatibility", "Disable old Buildcraft API (MJ) interfacing completely?", false).getBoolean(false);
        if (!EnergyConfigHandler.isBuildcraftLoaded()) {
            displayEnergyUnitsBC = false;
        }
        if (!EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            displayEnergyUnitsIC2 = false;
        }
        if (!EnergyConfigHandler.isMekanismLoaded()) {
            displayEnergyUnitsMek = false;
        }
        if (displayEnergyUnitsIC2) {
            displayEnergyUnitsBC = false;
        }
        if (displayEnergyUnitsMek) {
            displayEnergyUnitsBC = false;
            displayEnergyUnitsIC2 = false;
        }
        if (displayEnergyUnitsRF) {
            displayEnergyUnitsBC = false;
            displayEnergyUnitsIC2 = false;
            displayEnergyUnitsMek = false;
        }
        config.save();
    }

    public static void initGas() {
        if (EnergyConfigHandler.isMekanismLoaded()) {
            Gas oxygen = GasRegistry.getGas((String)"oxygen");
            gasOxygen = oxygen == null ? GasRegistry.register((Gas)new Gas("oxygen")).registerFluid() : oxygen;
            Gas hydrogen = GasRegistry.getGas((String)"hydrogen");
            gasHydrogen = hydrogen == null ? GasRegistry.register((Gas)new Gas("hydrogen")).registerFluid() : hydrogen;
        }
    }

    public static boolean isIndustrialCraft2Loaded() {
        if (!cachedIC2Loaded) {
            cachedIC2Loaded = true;
            cachedIC2LoadedValue = Loader.isModLoaded((String)"IC2");
        }
        return cachedIC2LoadedValue;
    }

    public static boolean isBuildcraftLoaded() {
        if (!cachedBCLoaded) {
            cachedBCLoaded = true;
            if (disableMJinterface) {
                cachedBCLoadedValue = false;
            } else {
                int count = 0;
                try {
                    if (Class.forName("buildcraft.api.mj.MjAPI") != null) {
                        ++count;
                    }
                    if (Class.forName("buildcraft.api.power.IPowerReceptor") != null) {
                        ++count;
                    }
                    if (Class.forName("buildcraft.api.power.PowerHandler") != null) {
                        ++count;
                    }
                    if (Class.forName("buildcraft.api.power.IPowerEmitter") != null) {
                        ++count;
                    }
                    if (Class.forName("buildcraft.api.mj.IBatteryObject") != null) {
                        ++count;
                    }
                    if (Class.forName("buildcraft.api.mj.ISidedBatteryProvider") != null) {
                        ++count;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cachedBCLoadedValue = count == 6;
            }
        }
        return cachedBCLoadedValue;
    }

    public static boolean isBuildcraftReallyLoaded() {
        if (!cachedBCReallyLoaded) {
            cachedBCReallyLoaded = true;
            cachedBCReallyLoadedValue = Loader.isModLoaded((String)"BuildCraft|Energy");
        }
        return cachedBCReallyLoadedValue;
    }

    public static int getBuildcraftVersion() {
        if (cachedBCVersion != -1) {
            return cachedBCVersion;
        }
        if (cachedBCLoaded) {
            boolean bc6Found = true;
            try {
                Class.forName("buildcraft.api.mj.MjAPI");
            }
            catch (Throwable t) {
                bc6Found = false;
            }
            cachedBCVersion = bc6Found ? 6 : 5;
        }
        return cachedBCVersion;
    }

    public static boolean isRFAPILoaded() {
        if (!cachedRFLoaded) {
            EnergyConfigHandler.initialiseRF();
        }
        return cachedRFLoadedValue;
    }

    public static boolean isRFAPIv1Loaded() {
        if (!cachedRFLoaded) {
            EnergyConfigHandler.initialiseRF();
        }
        return cachedRF1LoadedValue;
    }

    public static boolean isRFAPIv2Loaded() {
        if (!cachedRFLoaded) {
            EnergyConfigHandler.initialiseRF();
        }
        return cachedRF2LoadedValue;
    }

    private static void initialiseRF() {
        cachedRFLoaded = true;
        cachedRFLoadedValue = false;
        cachedRF2LoadedValue = false;
        int count = 0;
        int count2 = 0;
        try {
            if (Class.forName("cofh.api.energy.IEnergyConnection") != null) {
                ++count;
            }
            if (Class.forName("cofh.api.energy.IEnergyHandler") != null) {
                count += 2;
            }
            if (Class.forName("cofh.api.energy.IEnergyProvider") != null) {
                ++count2;
            }
            if (Class.forName("cofh.api.energy.IEnergyReceiver") != null) {
                ++count2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (count + count2 == 3 && count2 != 1 || count + count2 == 5) {
            cachedRFLoadedValue = true;
            cachedRF1LoadedValue = count == 3;
            cachedRF2LoadedValue = count2 == 2;
        } else if (count > 0 || count2 > 0) {
            GCLog.info("Incomplete Redstone Flux API detected: Galacticraft will not support RF energy connections until this is fixed.");
        }
    }

    public static boolean isMekanismLoaded() {
        if (!cachedMekLoaded) {
            cachedMekLoaded = true;
            cachedMekLoadedValue = Loader.isModLoaded((String)"Mekanism");
        }
        return cachedMekLoadedValue;
    }

    private static void updateRatios() {
        float factor = conversionLossFactor / 100;
        TO_BC_RATIO = factor / BC3_RATIO;
        TO_RF_RATIO = factor / RF_RATIO;
        TO_IC2_RATIO = factor / IC2_RATIO;
        TO_MEKANISM_RATIO = factor / MEKANISM_RATIO;
        TO_BC_RATIOdisp = 1.0f / BC3_RATIO;
        TO_RF_RATIOdisp = 1.0f / RF_RATIO;
        TO_IC2_RATIOdisp = 1.0f / IC2_RATIO;
        TO_MEKANISM_RATIOdisp = 1.0f / MEKANISM_RATIO;
        BC3_RATIO *= factor;
        RF_RATIO *= factor;
        IC2_RATIO *= factor;
        MEKANISM_RATIO *= factor;
    }

    public static void serverConfigOverride(ArrayList<Object> returnList) {
        returnList.add(Float.valueOf(BC3_RATIO));
        returnList.add(Float.valueOf(RF_RATIO));
        returnList.add(Float.valueOf(IC2_RATIO));
        returnList.add(Float.valueOf(MEKANISM_RATIO));
        returnList.add(conversionLossFactor);
    }

    public static void setConfigOverride(float sBC3, float sRF, float sIC2, float sMEK, int sLossRatio) {
        BC3_RATIO = sBC3;
        RF_RATIO = sRF;
        IC2_RATIO = sIC2;
        MEKANISM_RATIO = sMEK;
        conversionLossFactor = sLossRatio;
        EnergyConfigHandler.updateRatios();
    }

    static {
        BC3_RATIO = 16.0f;
        RF_RATIO = BC3_RATIO / 10.0f;
        IC2_RATIO = BC3_RATIO / 2.44f;
        MEKANISM_RATIO = IC2_RATIO / 10.0f;
        conversionLossFactor = 100;
        TO_BC_RATIO = 1.0f / BC3_RATIO;
        TO_RF_RATIO = 1.0f / RF_RATIO;
        TO_IC2_RATIO = 1.0f / IC2_RATIO;
        TO_MEKANISM_RATIO = 1.0f / MEKANISM_RATIO;
        TO_BC_RATIOdisp = 1.0f / BC3_RATIO;
        TO_RF_RATIOdisp = 1.0f / RF_RATIO;
        TO_IC2_RATIOdisp = 1.0f / IC2_RATIO;
        TO_MEKANISM_RATIOdisp = 1.0f / MEKANISM_RATIO;
        gasOxygen = null;
        gasHydrogen = null;
        displayEnergyUnitsBC = false;
        displayEnergyUnitsIC2 = false;
        displayEnergyUnitsMek = false;
        displayEnergyUnitsRF = false;
        cachedIC2Loaded = false;
        cachedIC2LoadedValue = false;
        cachedBCLoaded = false;
        cachedBCLoadedValue = false;
        cachedBCReallyLoaded = false;
        cachedBCReallyLoadedValue = false;
        cachedBCVersion = -1;
        cachedMekLoaded = false;
        cachedMekLoadedValue = false;
        cachedRFLoaded = false;
        cachedRFLoadedValue = false;
        cachedRF1LoadedValue = false;
        cachedRF2LoadedValue = false;
        disableMJinterface = false;
    }
}

