/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TravelingItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TriggerPipeContents
extends BCStatement
implements ITriggerInternal {
    private PipeContents kind;

    public TriggerPipeContents(PipeContents kind) {
        super("buildcraft:pipe.contents." + kind.name().toLowerCase(Locale.ENGLISH), "buildcraft.pipe.contents." + kind.name());
        this.kind = kind;
        kind.trigger = this;
    }

    @Override
    public int maxParameters() {
        switch (this.kind) {
            case containsItems: 
            case containsFluids: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.pipe." + this.kind.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        Pipe pipe = (Pipe)((IGate)((Object)container)).getPipe();
        IStatementParameter parameter = parameters[0];
        if (pipe.transport instanceof PipeTransportItems) {
            PipeTransportItems transportItems = (PipeTransportItems)pipe.transport;
            if (this.kind == PipeContents.empty) {
                return transportItems.items.isEmpty();
            }
            if (this.kind != PipeContents.containsItems) return false;
            if (parameter != null && parameter.getItemStack() != null) {
                TravelingItem item;
                Iterator<TravelingItem> iterator = transportItems.items.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    item = iterator.next();
                } while (!StackHelper.isMatchingItemOrList(parameter.getItemStack(), item.getItemStack()));
                return true;
            }
            if (transportItems.items.isEmpty()) return false;
            return true;
        }
        if (pipe.transport instanceof PipeTransportFluids) {
            PipeTransportFluids transportFluids = (PipeTransportFluids)pipe.transport;
            FluidStack searchedFluid = null;
            if (parameter != null && parameter.getItemStack() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameter.getItemStack());
            }
            if (this.kind == PipeContents.empty) {
                FluidTankInfo[] fluidTankInfoArray = transportFluids.getTankInfo(ForgeDirection.UNKNOWN);
                int n = fluidTankInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FluidTankInfo b = fluidTankInfoArray[n2];
                    if (b.fluid != null && b.fluid.amount != 0) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            FluidTankInfo[] fluidTankInfoArray = transportFluids.getTankInfo(ForgeDirection.UNKNOWN);
            int n = fluidTankInfoArray.length;
            int n3 = 0;
            while (n3 < n) {
                FluidTankInfo b = fluidTankInfoArray[n3];
                if (b.fluid != null && b.fluid.amount != 0) {
                    if (searchedFluid == null) return true;
                    if (searchedFluid.isFluidEqual(b.fluid)) {
                        return true;
                    }
                }
                ++n3;
            }
            return false;
        }
        if (!(pipe.transport instanceof PipeTransportPower)) return false;
        PipeTransportPower transportPower = (PipeTransportPower)pipe.transport;
        switch (this.kind) {
            case empty: {
                short[] sArray = transportPower.displayPower;
                int n = sArray.length;
                int n4 = 0;
                while (n4 < n) {
                    double s = sArray[n4];
                    if (s > 1.0E-4) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            case containsEnergy: {
                short[] sArray = transportPower.displayPower;
                int n = sArray.length;
                int n5 = 0;
                while (n5 < n) {
                    double s = sArray[n5];
                    if (s > 1.0E-4) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            case requestsEnergy: {
                return transportPower.isQueryingPower();
            }
        }
        return transportPower.isOverloaded();
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_" + this.kind.name().toLowerCase(Locale.ENGLISH));
    }

    public static enum PipeContents {
        empty,
        containsItems,
        containsFluids,
        containsEnergy,
        requestsEnergy,
        tooMuchEnergy;

        public ITriggerInternal trigger;
    }
}

