/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.DefaultProps;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.core.render.RenderUtils;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.GatePluggable;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class PipeRendererTESR
extends TileEntitySpecialRenderer {
    public static final float DISPLAY_MULTIPLIER = 0.1f;
    public static final int POWER_STAGES = 100;
    public static final ResourceLocation STRIPES_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/stripes.png");
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    public int[] displayPowerList = new int[100];
    public int[] displayPowerListOverload = new int[100];
    protected ModelBase model = new ModelBase(){};
    private final HashMap<Integer, DisplayFluidList> displayFluidLists = Maps.newHashMap();
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    private boolean initialized = false;

    public PipeRendererTESR() {
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    private DisplayFluidList getDisplayFluidLists(int liquidId, World world) {
        if (this.displayFluidLists.containsKey(liquidId)) {
            return this.displayFluidLists.get(liquidId);
        }
        DisplayFluidList d = new DisplayFluidList();
        this.displayFluidLists.put(liquidId, d);
        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
        Fluid fluid = FluidRegistry.getFluid((int)liquidId);
        block.baseBlock = fluid.getBlock() != null ? fluid.getBlock() : Blocks.field_150355_j;
        block.texture = fluid.getStillIcon();
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
        }
        return d;
    }

    private void initializeDisplayPowerList(World world) {
        float unit;
        float minSize;
        int s;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Normal.ordinal());
        float size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerList[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
        }
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Overload.ordinal());
        size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerListOverload[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerListOverload[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
        }
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        this.renderGatesWires(pipe, x, y, z);
        this.renderGates(pipe, x, y, z);
        IPipeTile.PipeType pipeType = pipe.getPipeType();
        if (pipeType == IPipeTile.PipeType.ITEM) {
            this.renderSolids(pipe.pipe, x, y, z);
        } else if (pipeType == IPipeTile.PipeType.FLUID) {
            this.renderFluids(pipe.pipe, x, y, z);
        } else if (pipeType == IPipeTile.PipeType.POWER) {
            this.renderPower(pipe.pipe, x, y, z);
        }
    }

    private void renderGatesWires(TileGenericPipe pipe, double x, double y, double z) {
        PipeRenderState state = pipe.renderState;
        if (state.wireMatrix.hasWire(PipeWire.RED)) {
            this.pipeWireRender(pipe, 0.25f, 0.75f, 0.25f, PipeWire.RED, x, y, z);
        }
        if (state.wireMatrix.hasWire(PipeWire.BLUE)) {
            this.pipeWireRender(pipe, 0.75f, 0.75f, 0.75f, PipeWire.BLUE, x, y, z);
        }
        if (state.wireMatrix.hasWire(PipeWire.GREEN)) {
            this.pipeWireRender(pipe, 0.75f, 0.25f, 0.25f, PipeWire.GREEN, x, y, z);
        }
        if (state.wireMatrix.hasWire(PipeWire.YELLOW)) {
            this.pipeWireRender(pipe, 0.25f, 0.25f, 0.75f, PipeWire.YELLOW, x, y, z);
        }
    }

    private void pipeWireRender(TileGenericPipe pipe, float cx, float cy, float cz, PipeWire color, double x, double y, double z) {
        boolean isLit;
        PipeRenderState state = pipe.renderState;
        float minX = 0.25f;
        float minY = 0.25f;
        float minZ = 0.25f;
        float maxX = 0.75f;
        float maxY = 0.75f;
        float maxZ = 0.75f;
        boolean foundX = false;
        boolean foundY = false;
        boolean foundZ = false;
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.WEST)) {
            minX = 0.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.EAST)) {
            maxX = 1.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.DOWN)) {
            minY = 0.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.UP)) {
            maxY = 1.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.NORTH)) {
            minZ = 0.0f;
            foundZ = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.SOUTH)) {
            maxZ = 1.0f;
            foundZ = true;
        }
        boolean center = false;
        if (minX == 0.0f && maxX != 1.0f && (foundY || foundZ)) {
            if (cx == 0.25f) {
                maxX = 0.25f;
            } else {
                center = true;
            }
        }
        if (minX != 0.0f && maxX == 1.0f && (foundY || foundZ)) {
            if (cx == 0.75f) {
                minX = 0.75f;
            } else {
                center = true;
            }
        }
        if (minY == 0.0f && maxY != 1.0f && (foundX || foundZ)) {
            if (cy == 0.25f) {
                maxY = 0.25f;
            } else {
                center = true;
            }
        }
        if (minY != 0.0f && maxY == 1.0f && (foundX || foundZ)) {
            if (cy == 0.75f) {
                minY = 0.75f;
            } else {
                center = true;
            }
        }
        if (minZ == 0.0f && maxZ != 1.0f && (foundX || foundY)) {
            if (cz == 0.25f) {
                maxZ = 0.25f;
            } else {
                center = true;
            }
        }
        if (minZ != 0.0f && maxZ == 1.0f && (foundX || foundY)) {
            if (cz == 0.75f) {
                minZ = 0.75f;
            } else {
                center = true;
            }
        }
        boolean found = foundX || foundY || foundZ;
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float scale = 1.001f;
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.func_147499_a(TextureMap.field_110575_b);
        RenderEntityBlock.RenderInfo renderBox = new RenderEntityBlock.RenderInfo();
        renderBox.texture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(color));
        boolean bl = isLit = (state.wireMatrix.getWireIconIndex(color) & 1) > 0;
        if (minZ != 0.25f || maxZ != 0.75f || !found) {
            renderBox.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, minZ, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), maxZ);
            this.renderLitBox(renderBox, isLit);
        }
        if (minX != 0.25f || maxX != 0.75f || !found) {
            renderBox.setBounds(minX, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, maxX, cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            this.renderLitBox(renderBox, isLit);
        }
        if (minY != 0.25f || maxY != 0.75f || !found) {
            renderBox.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, minY, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), maxY, cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            this.renderLitBox(renderBox, isLit);
        }
        if (center || !found) {
            renderBox.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            this.renderLitBox(renderBox, isLit);
        }
        GL11.glPopMatrix();
    }

    private void renderGates(TileGenericPipe pipe, double x, double y, double z) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!(pipe.getPipePluggable(direction) instanceof GatePluggable)) continue;
            this.renderGate(pipe, x, y, z, (GatePluggable)pipe.getPipePluggable(direction), direction);
        }
    }

    private void renderGate(TileGenericPipe pipe, double x, double y, double z, GatePluggable gate, ForgeDirection direction) {
        IIcon materialIcon;
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_147499_a(TextureMap.field_110575_b);
        IIcon gateIcon = gate.getLogic().getGateIcon();
        IIcon lightIcon = gate.isLit ? gate.getLogic().getIconLit() : gate.getLogic().getIconDark();
        float translateCenter = 0.0f;
        this.renderGate(pipe, gateIcon, 0, 0.1f, 0.0f, 0.0f, direction, false);
        this.renderGate(pipe, lightIcon, 0, 0.1f, 0.0f, 0.0f, direction, gate.isLit);
        float pulseStage = gate.getPulseStage() * 2.0f;
        if (gate.isPulsing || pulseStage != 0.0f) {
            float amplitude = 0.1f;
            float start = 0.01f;
            translateCenter = pulseStage < 1.0f ? pulseStage * amplitude + start : amplitude - (pulseStage - 1.0f) * amplitude + start;
            this.renderGate(pipe, gateIcon, 0, 0.13f, translateCenter, translateCenter, direction, false);
            this.renderGate(pipe, lightIcon, 0, 0.13f, translateCenter, translateCenter, direction, gate.isLit);
        }
        if ((materialIcon = gate.getMaterial().getIconBlock()) != null) {
            this.renderGate(pipe, materialIcon, 1, 0.13f, translateCenter, translateCenter, direction, false);
        }
        for (IGateExpansion expansion : gate.getExpansions()) {
            this.renderGate(pipe, expansion.getOverlayBlock(), 2, 0.13f, translateCenter, translateCenter, direction, false);
        }
        GL11.glPopMatrix();
    }

    private void renderGate(TileGenericPipe tile, IIcon icon, int layer, float trim, float translateCenter, float extraDepth, ForgeDirection direction, boolean isLit) {
        RenderEntityBlock.RenderInfo renderBox = new RenderEntityBlock.RenderInfo();
        renderBox.texture = icon;
        float[][] zeroState = new float[3][2];
        float min = 0.25f + trim / 2.0f;
        float max = 0.75f - trim / 2.0f;
        zeroState[0][0] = min;
        zeroState[0][1] = max;
        zeroState[1][0] = 0.15f - 0.001f * (float)layer;
        zeroState[1][1] = 0.251f + 0.01f * (float)layer + extraDepth;
        zeroState[2][0] = min;
        zeroState[2][1] = max;
        GL11.glPushMatrix();
        float xt = (float)direction.offsetX * translateCenter;
        float yt = (float)direction.offsetY * translateCenter;
        float zt = (float)direction.offsetZ * translateCenter;
        GL11.glTranslatef((float)xt, (float)yt, (float)zt);
        float[][] rotated = MatrixTranformations.deepClone(zeroState);
        MatrixTranformations.transform(rotated, direction);
        if (layer != 0) {
            renderBox.setRenderSingleSide(direction.ordinal());
        }
        renderBox.setBounds(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
        this.renderLitBox(renderBox, isLit);
        GL11.glPopMatrix();
    }

    private void renderLitBox(RenderEntityBlock.RenderInfo info, boolean isLit) {
        RenderEntityBlock.INSTANCE.renderBlock(info);
        float lastX = OpenGlHelper.lastBrightnessX;
        float lastY = OpenGlHelper.lastBrightnessY;
        if (isLit) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glDepthMask((boolean)true);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
            RenderEntityBlock.INSTANCE.renderBlock(info);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastX, (float)lastY);
    }

    public boolean isOpenOrientation(PipeRenderState state, ForgeDirection direction) {
        int connections = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.pipeConnectionMatrix.isConnected(o) || ++connections != 1) continue;
            targetOrientation = o;
        }
        if (connections > 1 || connections == 0) {
            return false;
        }
        return targetOrientation.getOpposite() == direction;
    }

    private void renderPower(Pipe<PipeTransportPower> pipe, double x, double y, double z) {
        this.initializeDisplayPowerList(pipe.container.func_145831_w());
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_147499_a(TextureMap.field_110575_b);
        int[] displayList = pow.overload > 0 ? this.displayPowerListOverload : this.displayPowerList;
        for (int side = 0; side < 6; ++side) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)this.angleY[side], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.angleZ[side], (float)0.0f, (float)0.0f, (float)1.0f);
            float scale = 1.0f - (float)side * 1.0E-4f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            short stage = pow.displayPower[side];
            if (stage >= 1) {
                if (stage < displayList.length) {
                    GL11.glCallList((int)displayList[stage]);
                } else {
                    GL11.glCallList((int)displayList[displayList.length - 1]);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderFluids(Pipe<PipeTransportFluids> pipe, double x, double y, double z) {
        DisplayFluidList d;
        PipeTransportFluids trans = (PipeTransportFluids)pipe.transport;
        boolean needsRender = false;
        for (int i = 0; i < 7; ++i) {
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean sides = false;
        boolean above = false;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            DisplayFluidList d2;
            int i = side.ordinal();
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0 || !pipe.container.isPipeConnected(side) || (d2 = this.getListFromBuffer(fluidStack, pipe.container.func_145831_w())) == null) continue;
            int stage = (int)((float)fluidStack.amount / (float)trans.getCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_147499_a(TextureMap.field_110575_b);
            RenderUtils.setGLColorFromInt(trans.colorRenderCache[i]);
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        FluidStack fluidStack = trans.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (fluidStack != null && fluidStack.amount > 0 && (d = this.getListFromBuffer(fluidStack, pipe.container.func_145831_w())) != null) {
            int stage = (int)((float)fluidStack.amount / (float)trans.getCapacity() * 39.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            RenderUtils.setGLColorFromInt(trans.colorRenderCache[ForgeDirection.UNKNOWN.ordinal()]);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayFluidList getListFromBuffer(FluidStack stack, World world) {
        int liquidId = stack.fluidID;
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayFluidLists(liquidId, world);
    }

    private void renderSolids(Pipe<PipeTransportItems> pipe, double x, double y, double z) {
        GL11.glPushMatrix();
        float light = pipe.container.func_145831_w().func_72801_o(pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e);
        int count = 0;
        Iterator<TravelingItem> iterator = ((PipeTransportItems)pipe.transport).items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (count >= 10) break;
            this.doRenderItem(item, x + item.xCoord - (double)pipe.container.field_145851_c, y + item.yCoord - (double)pipe.container.field_145848_d, z + item.zCoord - (double)pipe.container.field_145849_e, light, item.color);
            ++count;
        }
        GL11.glPopMatrix();
    }

    public void doRenderItem(TravelingItem travellingItem, double x, double y, double z, float light, EnumColor color) {
        if (travellingItem == null || travellingItem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ItemStack itemstack = travellingItem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(itemstack);
        this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (color != null) {
            this.func_147499_a(TextureMap.field_110575_b);
            RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
            block.texture = PipeIconProvider.TYPE.ItemBox.getIcon();
            float pix = 0.0625f;
            float min = -4.0f * pix;
            float max = 4.0f * pix;
            block.minY = min;
            block.maxY = max;
            block.minZ = min;
            block.maxZ = max;
            block.minX = min;
            block.maxX = max;
            RenderUtils.setGLColorFromInt(color.getLightHex());
            RenderEntityBlock.INSTANCE.renderBlock(block);
        }
        GL11.glPopMatrix();
    }

    private class DisplayFluidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayFluidList() {
        }
    }
}

