/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gui.ContainerGateInterface;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGateInterface
extends GuiAdvancedInterface {
    IInventory playerInventory;
    private final ContainerGateInterface container;
    private final Pipe<?> pipe;
    private Gate gate;

    public GuiGateInterface(IInventory playerInventory, Pipe<?> pipe) {
        super(new ContainerGateInterface(playerInventory, pipe), null, null);
        this.container = (ContainerGateInterface)this.field_147002_h;
        this.container.gateCallback = this;
        this.pipe = pipe;
        this.playerInventory = playerInventory;
    }

    public void setGate(Gate gate) {
        this.gate = gate;
        this.init();
    }

    public void init() {
        if (this.gate == null) {
            return;
        }
        this.field_146999_f = 176;
        this.field_147000_g = this.gate.material.guiHeight;
        int position = 0;
        this.slots.clear();
        if (this.gate.material == GateDefinition.GateMaterial.REDSTONE) {
            this.slots.add(new TriggerSlot(62, 26, this.pipe, 0));
            this.slots.add(new ActionSlot(98, 26, this.pipe, 0));
        } else if (this.gate.material == GateDefinition.GateMaterial.IRON) {
            this.slots.add(new TriggerSlot(62, 26, this.pipe, 0));
            this.slots.add(new TriggerSlot(62, 44, this.pipe, 1));
            this.slots.add(new ActionSlot(98, 26, this.pipe, 0));
            this.slots.add(new ActionSlot(98, 44, this.pipe, 1));
        } else if (this.gate.material == GateDefinition.GateMaterial.QUARTZ) {
            for (int i = 0; i < 2; ++i) {
                TriggerSlot ts = new TriggerSlot(44, 26 + i * 18, this.pipe, i);
                ActionSlot as = new ActionSlot(98, 26 + i * 18, this.pipe, i);
                this.slots.add(ts);
                this.slots.add(as);
                this.slots.add(new TriggerParameterSlot(62, 26 + i * 18, this.pipe, 0, ts));
                this.slots.add(new ActionParameterSlot(116, 26 + i * 18, this.pipe, 0, as));
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.GOLD) {
            int k;
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerSlot(53, 26 + 18 * k, this.pipe, position));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new ActionSlot(107, 26 + 18 * k, this.pipe, position - 4));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerParameterSlot(71, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(k)));
                ++position;
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.DIAMOND) {
            int k;
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerSlot(8, 26 + 18 * k, this.pipe, position));
                this.slots.add(new TriggerSlot(98, 26 + 18 * k, this.pipe, ++position));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new ActionSlot(62, 26 + 18 * k, this.pipe, position - 8));
                this.slots.add(new ActionSlot(152, 26 + 18 * k, this.pipe, ++position - 8));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerParameterSlot(26, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(position - 16)));
                this.slots.add(new TriggerParameterSlot(116, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(++position - 16)));
                ++position;
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.EMERALD) {
            for (int y = 0; y < 4; ++y) {
                int x;
                this.slots.add(new TriggerSlot(8, 26 + 18 * y, this.pipe, y));
                int lastPos = position++;
                for (x = 0; x < 3; ++x) {
                    this.slots.add(new TriggerParameterSlot(8 + 18 * (x + 1), 26 + 18 * y, this.pipe, x, (TriggerSlot)this.slots.get(lastPos)));
                    ++position;
                }
                this.slots.add(new ActionSlot(98, 26 + 18 * y, this.pipe, y));
                lastPos = position++;
                for (x = 0; x < 3; ++x) {
                    this.slots.add(new ActionParameterSlot(98 + 18 * (x + 1), 26 + 18 * y, this.pipe, x, (ActionSlot)this.slots.get(lastPos)));
                    ++position;
                }
            }
        }
        this.func_73866_w_();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        if (this.gate == null) {
            return;
        }
        String name = this.container.getGateName();
        this.field_146289_q.func_78276_b(name, this.getCenteredOffset(name), 10, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        this.container.synchronize();
        if (this.gate == null) {
            return;
        }
        ResourceLocation texture = this.container.getGateGuiFile();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (AdvancedSlot slot : this.slots) {
            if (slot instanceof TriggerSlot) {
                boolean halfWidth;
                boolean bl = halfWidth = this.container.actionsState[((TriggerSlot)slot).slot] == ActionActiveState.Partial;
                if (this.container.actionsState[((TriggerSlot)slot).slot] == ActionActiveState.Deactivated) continue;
                this.field_146297_k.field_71446_o.func_110577_a(texture);
                this.func_73729_b(this.field_147003_i + slot.x + 17 + 18 * this.gate.material.numTriggerParameters, this.field_147009_r + slot.y + 6, 176, 18, halfWidth ? 9 : 18, 4);
                continue;
            }
            if (!(slot instanceof StatementParameterSlot)) continue;
            StatementParameterSlot paramSlot = (StatementParameterSlot)slot;
            StatementSlot statement = paramSlot.statementSlot;
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            if (statement.isDefined()) {
                if (!paramSlot.isAllowed()) {
                    this.func_73729_b(this.field_147003_i + slot.x - 1, this.field_147009_r + slot.y - 1, 176, 0, 18, 18);
                    continue;
                }
                if (!paramSlot.isRequired() || paramSlot.getItemStack() != null) continue;
                this.func_73729_b(this.field_147003_i + slot.x - 1, this.field_147009_r + slot.y - 1, 176, 22, 18, 18);
                continue;
            }
            this.func_73729_b(this.field_147003_i + slot.x - 1, this.field_147009_r + slot.y - 1, 176, 0, 18, 18);
        }
        this.drawBackgroundSlots();
    }

    private void doSlotClick(AdvancedSlot slot, int k) {
        if (slot instanceof TriggerSlot && this.container.hasTriggers()) {
            TriggerSlot triggerSlot = (TriggerSlot)slot;
            IStatement changed = null;
            if (triggerSlot.getStatement() == null) {
                changed = k == 0 ? this.container.getFirstTrigger() : this.container.getLastTrigger();
            } else {
                Iterator<IStatement> it = this.container.getTriggerIterator(k != 0);
                while (it.hasNext()) {
                    IStatement trigger = it.next();
                    if (!it.hasNext()) {
                        changed = null;
                        break;
                    }
                    if (trigger != triggerSlot.getStatement()) continue;
                    changed = it.next();
                    break;
                }
            }
            if (changed == null) {
                this.container.setTrigger(triggerSlot.slot, null, true);
            } else {
                this.container.setTrigger(triggerSlot.slot, changed.getUniqueTag(), true);
            }
            for (StatementParameterSlot p : triggerSlot.parameters) {
                IStatementParameter parameter = null;
                if (changed != null && p.slot < changed.minParameters()) {
                    parameter = changed.createParameter(p.slot);
                }
                this.container.setTriggerParameter(triggerSlot.slot, p.slot, parameter, true);
            }
        } else if (slot instanceof ActionSlot) {
            ActionSlot actionSlot = (ActionSlot)slot;
            IStatement changed = null;
            if (actionSlot.getStatement() == null) {
                changed = k == 0 ? this.container.getFirstAction() : this.container.getLastAction();
            } else {
                Iterator<IStatement> it = this.container.getActionIterator(k != 0);
                while (it.hasNext()) {
                    IStatement action = it.next();
                    if (!it.hasNext()) {
                        changed = null;
                        break;
                    }
                    if (action != actionSlot.getStatement()) continue;
                    changed = it.next();
                    break;
                }
            }
            if (changed == null) {
                this.container.setAction(actionSlot.slot, null, true);
            } else {
                this.container.setAction(actionSlot.slot, changed.getUniqueTag(), true);
            }
            for (StatementParameterSlot p : actionSlot.parameters) {
                IStatementParameter parameter = null;
                if (changed != null && p.slot < changed.minParameters()) {
                    parameter = changed.createParameter(p.slot);
                }
                this.container.setActionParameter(actionSlot.slot, p.slot, parameter, true);
            }
        } else if (slot instanceof StatementParameterSlot) {
            StatementParameterSlot paramSlot = (StatementParameterSlot)slot;
            StatementSlot statement = paramSlot.statementSlot;
            if (statement.isDefined() && statement.getStatement().maxParameters() != 0) {
                IStatementParameter param = paramSlot.getParameter();
                if (param == null) {
                    param = statement.getStatement().createParameter(paramSlot.slot);
                }
                if (param != null) {
                    param.onClick(this.gate, statement.getStatement(), this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), new StatementMouseClick(k, GuiGateInterface.func_146272_n()));
                    paramSlot.setParameter(param, true);
                }
            }
        }
        this.container.markDirty();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        if (this.gate == null) {
            return;
        }
        super.func_73864_a(i, j, k);
        AdvancedSlot slot = this.getSlotAtLocation(i, j);
        if (slot != null) {
            this.doSlotClick(slot, k);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.doSlotClick(this.getSlotAtLocation(i, j), wheel > 0 ? 0 : 1);
        }
    }

    class ActionParameterSlot
    extends StatementParameterSlot {
        public ActionParameterSlot(int x, int y, Pipe<?> pipe, int slot, StatementSlot iStatementSlot) {
            super(x, y, pipe, slot, iStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            return GuiGateInterface.this.gate.getActionParameter(this.statementSlot.slot, this.slot);
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
            GuiGateInterface.this.container.setActionParameter(this.statementSlot.slot, this.slot, param, notifyServer);
        }
    }

    class TriggerParameterSlot
    extends StatementParameterSlot {
        public TriggerParameterSlot(int x, int y, Pipe<?> pipe, int slot, StatementSlot iStatementSlot) {
            super(x, y, pipe, slot, iStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            return GuiGateInterface.this.gate.getTriggerParameter(this.statementSlot.slot, this.slot);
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
            GuiGateInterface.this.container.setTriggerParameter(this.statementSlot.slot, this.slot, param, notifyServer);
        }
    }

    private abstract class StatementParameterSlot
    extends AdvancedSlot {
        public Pipe<?> pipe;
        public int slot;
        public StatementSlot statementSlot;

        public StatementParameterSlot(int x, int y, Pipe<?> pipe, int slot, StatementSlot iStatementSlot) {
            super(GuiGateInterface.this, x, y);
            this.pipe = pipe;
            this.slot = slot;
            this.statementSlot = iStatementSlot;
            this.statementSlot.parameters.add(this);
        }

        @Override
        public boolean isDefined() {
            return this.getParameter() != null;
        }

        @Override
        public String getDescription() {
            IStatementParameter parameter = this.getParameter();
            if (parameter != null) {
                return parameter.getDescription() != null ? parameter.getDescription() : "";
            }
            return null;
        }

        @Override
        public ItemStack getItemStack() {
            IStatementParameter parameter = this.getParameter();
            if (parameter != null) {
                return parameter.getItemStack();
            }
            return null;
        }

        @Override
        public IIcon getIcon() {
            IStatementParameter parameter = this.getParameter();
            if (parameter != null) {
                return parameter.getIcon();
            }
            return null;
        }

        public abstract IStatementParameter getParameter();

        public boolean isAllowed() {
            return this.statementSlot.getStatement() != null && this.slot < this.statementSlot.getStatement().maxParameters();
        }

        public boolean isRequired() {
            return this.statementSlot.getStatement() != null && this.slot < this.statementSlot.getStatement().minParameters();
        }

        public abstract void setParameter(IStatementParameter var1, boolean var2);
    }

    private class ActionSlot
    extends StatementSlot {
        public ActionSlot(int x, int y, Pipe<?> pipe, int slot) {
            super(x, y, pipe, slot);
        }

        @Override
        public IStatement getStatement() {
            return GuiGateInterface.this.gate.getAction(this.slot);
        }
    }

    private class TriggerSlot
    extends StatementSlot {
        public TriggerSlot(int x, int y, Pipe<?> pipe, int slot) {
            super(x, y, pipe, slot);
        }

        @Override
        public IStatement getStatement() {
            return GuiGateInterface.this.gate.getTrigger(this.slot);
        }
    }

    private abstract class StatementSlot
    extends AdvancedSlot {
        public int slot;
        public ArrayList<StatementParameterSlot> parameters;

        public StatementSlot(int x, int y, Pipe<?> pipe, int slot) {
            super(GuiGateInterface.this, x, y);
            this.parameters = new ArrayList();
            this.slot = slot;
        }

        @Override
        public String getDescription() {
            IStatement stmt = this.getStatement();
            if (stmt != null) {
                return stmt.getDescription();
            }
            return "";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            IStatement stmt = this.getStatement();
            if (stmt != null) {
                return stmt.getIcon();
            }
            return null;
        }

        @Override
        public boolean isDefined() {
            return this.getStatement() != null;
        }

        public abstract IStatement getStatement();
    }
}

