/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.Position;
import buildcraft.core.inventory.StackHelper;
import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TravelingItem {
    public static final TravelingItemCache serverCache = new TravelingItemCache();
    public static final TravelingItemCache clientCache = new TravelingItemCache();
    public static final InsertionHandler DEFAULT_INSERTION_HANDLER = new InsertionHandler();
    private static int maxId = 0;
    public final EnumSet<ForgeDirection> blacklist = EnumSet.noneOf(ForgeDirection.class);
    public double xCoord;
    public double yCoord;
    public double zCoord;
    public final int id;
    public boolean toCenter = true;
    public EnumColor color;
    public ForgeDirection input = ForgeDirection.UNKNOWN;
    public ForgeDirection output = ForgeDirection.UNKNOWN;
    protected float speed = 0.01f;
    protected ItemStack itemStack;
    protected TileEntity container;
    protected NBTTagCompound extraData;
    protected InsertionHandler insertionHandler = DEFAULT_INSERTION_HANDLER;

    protected TravelingItem(int id) {
        this.id = id;
    }

    public static TravelingItem make(int id) {
        TravelingItem item = new TravelingItem(id);
        TravelingItem.getCache().cache(item);
        return item;
    }

    public static TravelingItem make() {
        return TravelingItem.make(maxId < Short.MAX_VALUE ? (maxId = maxId + 1) : (maxId = Short.MIN_VALUE));
    }

    public static TravelingItem make(double x, double y, double z, ItemStack stack) {
        TravelingItem item = TravelingItem.make();
        item.xCoord = x;
        item.yCoord = y;
        item.zCoord = z;
        item.itemStack = stack.func_77946_l();
        return item;
    }

    public static TravelingItem make(NBTTagCompound nbt) {
        TravelingItem item = TravelingItem.make();
        item.readFromNBT(nbt);
        return item;
    }

    public static TravelingItemCache getCache() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return clientCache;
        }
        return serverCache;
    }

    public void setPosition(double x, double y, double z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public void movePosition(double x, double y, double z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack item) {
        this.itemStack = item;
    }

    public TileEntity getContainer() {
        return this.container;
    }

    public void setContainer(TileEntity container) {
        this.container = container;
    }

    public NBTTagCompound getExtraData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }

    public boolean hasExtraData() {
        return this.extraData != null;
    }

    @Deprecated
    public void setInsetionHandler(InsertionHandler handler) {
        if (handler == null) {
            return;
        }
        this.insertionHandler = handler;
    }

    public void setInsertionHandler(InsertionHandler handler) {
        if (handler == null) {
            return;
        }
        this.insertionHandler = handler;
    }

    public InsertionHandler getInsertionHandler() {
        return this.insertionHandler;
    }

    public void reset() {
        this.toCenter = true;
        this.blacklist.clear();
        this.input = ForgeDirection.UNKNOWN;
        this.output = ForgeDirection.UNKNOWN;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.setPosition(data.func_74769_h("x"), data.func_74769_h("y"), data.func_74769_h("z"));
        this.setSpeed(data.func_74760_g("speed"));
        this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Item")));
        this.toCenter = data.func_74767_n("toCenter");
        this.input = ForgeDirection.getOrientation((int)data.func_74771_c("input"));
        this.output = ForgeDirection.getOrientation((int)data.func_74771_c("output"));
        byte c = data.func_74771_c("color");
        if (c != -1) {
            this.color = EnumColor.fromId(c);
        }
        if (data.func_74764_b("extraData")) {
            this.extraData = data.func_74775_l("extraData");
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74780_a("x", this.xCoord);
        data.func_74780_a("y", this.yCoord);
        data.func_74780_a("z", this.zCoord);
        data.func_74776_a("speed", this.getSpeed());
        NBTTagCompound itemStackTag = new NBTTagCompound();
        this.getItemStack().func_77955_b(itemStackTag);
        data.func_74782_a("Item", (NBTBase)itemStackTag);
        data.func_74757_a("toCenter", this.toCenter);
        data.func_74774_a("input", (byte)this.input.ordinal());
        data.func_74774_a("output", (byte)this.output.ordinal());
        data.func_74774_a("color", this.color != null ? (byte)this.color.ordinal() : (byte)-1);
        if (this.extraData != null) {
            data.func_74782_a("extraData", (NBTBase)this.extraData);
        }
    }

    public EntityItem toEntityItem() {
        if (this.container != null && !this.container.func_145831_w().field_72995_K) {
            if (this.getItemStack().field_77994_a <= 0) {
                return null;
            }
            Position motion = new Position(0.0, 0.0, 0.0, this.output);
            motion.moveForwards(0.1 + (double)(this.getSpeed() * 2.0f));
            EntityItem entity = new EntityItem(this.container.func_145831_w(), this.xCoord, this.yCoord, this.zCoord, this.getItemStack());
            entity.lifespan = BuildCraftCore.itemLifespan;
            entity.field_145804_b = 10;
            float f3 = 0.0f + this.container.func_145831_w().field_73012_v.nextFloat() * 0.04f - 0.02f;
            entity.field_70159_w = (double)((float)this.container.func_145831_w().field_73012_v.nextGaussian() * f3) + motion.x;
            entity.field_70181_x = (double)((float)this.container.func_145831_w().field_73012_v.nextGaussian() * f3) + motion.y;
            entity.field_70179_y = (double)((float)this.container.func_145831_w().field_73012_v.nextGaussian() * f3) + motion.z;
            return entity;
        }
        return null;
    }

    public float getEntityBrightness(float f) {
        int i = MathHelper.func_76128_c((double)this.xCoord);
        int j = MathHelper.func_76128_c((double)this.zCoord);
        if (this.container != null && this.container.func_145831_w().func_72899_e(i, 64, j)) {
            double d = 0.66;
            int k = MathHelper.func_76128_c((double)(this.yCoord + d));
            return this.container.func_145831_w().func_72801_o(i, k, j);
        }
        return 0.0f;
    }

    public boolean isCorrupted() {
        return this.itemStack == null || this.itemStack.field_77994_a <= 0 || this.itemStack.func_77973_b() == null;
    }

    public boolean canBeGroupedWith(TravelingItem otherItem) {
        if (otherItem == this) {
            return false;
        }
        if (this.toCenter != otherItem.toCenter) {
            return false;
        }
        if (this.output != otherItem.output) {
            return false;
        }
        if (this.color != otherItem.color) {
            return false;
        }
        if (this.hasExtraData() || otherItem.hasExtraData()) {
            return false;
        }
        if (this.insertionHandler != DEFAULT_INSERTION_HANDLER) {
            return false;
        }
        if (!this.blacklist.equals(otherItem.blacklist)) {
            return false;
        }
        if (otherItem.isCorrupted()) {
            return false;
        }
        return StackHelper.canStacksMerge(this.itemStack, otherItem.itemStack);
    }

    public boolean tryMergeInto(TravelingItem otherItem) {
        if (!this.canBeGroupedWith(otherItem)) {
            return false;
        }
        if (StackHelper.mergeStacks(this.itemStack, otherItem.itemStack, false) == this.itemStack.field_77994_a) {
            StackHelper.mergeStacks(this.itemStack, otherItem.itemStack, true);
            this.itemStack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.id;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TravelingItem other = (TravelingItem)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "TravelingItem: " + this.id;
    }

    public static class TravelingItemCache {
        private final Map<Integer, TravelingItem> itemCache = new MapMaker().weakValues().makeMap();

        public void cache(TravelingItem item) {
            this.itemCache.put(item.id, item);
        }

        public TravelingItem get(int id) {
            return this.itemCache.get(id);
        }
    }

    public static class InsertionHandler {
        public boolean canInsertItem(TravelingItem item, IInventory inv) {
            return true;
        }
    }
}

