/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.ISerializable;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.utils.ConnectionMatrix;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePluggableState
implements ISerializable {
    private PipePluggable[] pluggables = new PipePluggable[6];
    private ConnectionMatrix pluggableMatrix = new ConnectionMatrix();

    public PipePluggable[] getPluggables() {
        return this.pluggables;
    }

    public void setPluggables(PipePluggable[] pluggables) {
        this.pluggables = pluggables;
        this.pluggableMatrix.clean();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.pluggableMatrix.setConnected(dir, pluggables[dir.ordinal()] != null);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        this.pluggableMatrix.writeData(data);
        for (PipePluggable p : this.pluggables) {
            if (p == null) continue;
            data.writeShort(PipeManager.pipePluggables.indexOf(p.getClass()));
            p.writeData(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.pluggableMatrix.readData(data);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.pluggableMatrix.isConnected(dir)) {
                try {
                    PipePluggable p = PipeManager.pipePluggables.get(data.readUnsignedShort()).newInstance();
                    p.readData(data);
                    this.pluggables[dir.ordinal()] = p;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.pluggables[dir.ordinal()] = null;
        }
    }
}

