/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.events.PipePlacedEvent;
import buildcraft.api.events.RobotPlacementEvent;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.ItemRobot;
import buildcraft.core.TileBuffer;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Gate;
import buildcraft.transport.ISolidSideTile;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.pluggable.RobotStationPluggable;
import buildcraft.transport.render.PipeRendererWorld;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGenericPipe
extends BlockBuildCraft {
    public static int facadeRenderColor = -1;
    public static Map<Item, Class<? extends Pipe>> pipes = new HashMap<Item, Class<? extends Pipe>>();
    public static Map<BlockIndex, Pipe<?>> pipeRemoved = new HashMap();
    private static long lastRemovedDate = -1L;
    private static final ForgeDirection[] DIR_VALUES = ForgeDirection.values();
    private boolean skippedFirstIconRegister;

    public BlockGenericPipe() {
        super(Material.field_151592_s);
        this.func_149647_a(null);
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        return BuildCraftTransport.pipeDurability;
    }

    public int func_149645_b() {
        return TransportProxy.pipeModel;
    }

    public boolean canRenderInPass(int pass) {
        PipeRendererWorld.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ISolidSideTile) {
            return ((ISolidSideTile)tile).isSolidOnSide(side);
        }
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public void func_149743_a(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        TileEntity tile1 = world.func_147438_o(i, j, k);
        if (tile1 instanceof TileGenericPipe) {
            TileGenericPipe tileG = (TileGenericPipe)tile1;
            if (tileG.isPipeConnected(ForgeDirection.WEST)) {
                this.func_149676_a(0.0f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.EAST)) {
                this.func_149676_a(0.25f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.DOWN)) {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.75f, 0.75f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.UP)) {
                this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 1.0f, 0.75f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.NORTH)) {
                this.func_149676_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.75f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.SOUTH)) {
                this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            float facadeThickness = 0.125f;
            if (tileG.hasEnabledFacade(ForgeDirection.EAST)) {
                this.func_149676_a(1.0f - facadeThickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasEnabledFacade(ForgeDirection.WEST)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, facadeThickness, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasEnabledFacade(ForgeDirection.UP)) {
                this.func_149676_a(0.0f, 1.0f - facadeThickness, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasEnabledFacade(ForgeDirection.DOWN)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, facadeThickness, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasEnabledFacade(ForgeDirection.SOUTH)) {
                this.func_149676_a(0.0f, 0.0f, 1.0f - facadeThickness, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasEnabledFacade(ForgeDirection.NORTH)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facadeThickness);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            AxisAlignedBB box = rayTraceResult.boundingBox;
            switch (rayTraceResult.hitPart) {
                case Pluggable: {
                    float scale = 0.001f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
                case Pipe: {
                    float scale = 0.08f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
            }
            return box.func_72325_c((double)x, (double)y, (double)z);
        }
        return super.func_149633_g(world, x, y, z).func_72314_b((double)-0.85f, (double)-0.85f, (double)-0.85f);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, x, y, z, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        return raytraceResult.movingObjectPosition;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer player) {
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        double eyeHeight = world.field_72995_K ? (double)(player.func_70047_e() - player.getDefaultEyeHeight()) : (double)player.func_70047_e();
        Vec3 lookVec = player.func_70040_Z();
        Vec3 origin = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + eyeHeight), (double)player.field_70161_v);
        Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, x, y, z, origin, direction);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        AxisAlignedBB bb;
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (!BlockGenericPipe.isValid(pipe)) {
            return null;
        }
        TileGenericPipe tileG = pipe.container;
        if (tileG == null) {
            return null;
        }
        MovingObjectPosition[] hits = new MovingObjectPosition[31];
        AxisAlignedBB[] boxes = new AxisAlignedBB[31];
        Object[] sideHit = new ForgeDirection[31];
        Arrays.fill(sideHit, ForgeDirection.UNKNOWN);
        for (ForgeDirection side : DIR_VALUES) {
            if (side != ForgeDirection.UNKNOWN && !tileG.isPipeConnected(side)) continue;
            bb = this.getPipeBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[side.ordinal()] = bb;
            hits[side.ordinal()] = super.func_149731_a(world, x, y, z, origin, direction);
            sideHit[side.ordinal()] = side;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (tileG.getPipePluggable(side) == null) continue;
            bb = tileG.getPipePluggable(side).getBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[7 + side.ordinal()] = bb;
            hits[7 + side.ordinal()] = super.func_149731_a(world, x, y, z, origin, direction);
            sideHit[7 + side.ordinal()] = side;
        }
        double minLengthSquared = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < hits.length; ++i) {
            double lengthSquared;
            MovingObjectPosition hit = hits[i];
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            minIndex = i;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (minIndex == -1) {
            return null;
        }
        Part hitPart = minIndex < 7 ? Part.Pipe : Part.Pluggable;
        return new RaytraceResult(hitPart, hits[minIndex], boxes[minIndex], (ForgeDirection)sideHit[minIndex]);
    }

    private void setBlockBounds(AxisAlignedBB bb) {
        this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
    }

    private AxisAlignedBB getPipeBoundingBox(ForgeDirection side) {
        float min = 0.25f;
        float max = 0.75f;
        if (side == ForgeDirection.UNKNOWN) {
            return AxisAlignedBB.func_72330_a((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        float[][] bounds = new float[3][2];
        bounds[0][0] = min;
        bounds[0][1] = max;
        bounds[1][0] = 0.0f;
        bounds[1][1] = min;
        bounds[2][0] = min;
        bounds[2][1] = max;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    public static void removePipe(Pipe<?> pipe) {
        if (!BlockGenericPipe.isValid(pipe)) {
            return;
        }
        World world = pipe.container.func_145831_w();
        if (world == null) {
            return;
        }
        int x = pipe.container.field_145851_c;
        int y = pipe.container.field_145848_d;
        int z = pipe.container.field_145849_e;
        if (lastRemovedDate != world.func_82737_E()) {
            lastRemovedDate = world.func_82737_E();
            pipeRemoved.clear();
        }
        pipeRemoved.put(new BlockIndex(x, y, z), pipe);
        world.func_147475_p(x, y, z);
        if (pipe != null) {
            BlockGenericPipe.updateNeighbourSignalState(pipe);
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        BlockGenericPipe.removePipe(BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z));
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (world.field_72995_K) {
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (pipe == null) {
            pipe = pipeRemoved.get(new BlockIndex(x, y, z));
        }
        if (pipe != null && pipe.item != null) {
            list.add(new ItemStack(pipe.item, 1, pipe.container.getItemMetadata()));
            list.addAll(pipe.computeItemDrop());
            list.addAll(pipe.getDroppedItems());
        }
        return list;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileGenericPipe();
    }

    public void func_149690_a(World world, int i, int j, int k, int l, float f, int dmg) {
        Item k1;
        if (world.field_72995_K) {
            return;
        }
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (pipe == null) {
            pipe = pipeRemoved.get(new BlockIndex(i, j, k));
        }
        if (pipe != null && (k1 = pipe.item) != null) {
            pipe.dropContents();
            for (ItemStack is : pipe.computeItemDrop()) {
                this.func_149642_a(world, i, j, k, is);
            }
            this.func_149642_a(world, i, j, k, new ItemStack(k1, 1, pipe.container.getItemMetadata()));
        }
    }

    public Item func_149650_a(int meta, Random rand, int dmg) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            switch (rayTraceResult.hitPart) {
                case Pluggable: {
                    Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
                    PipePluggable pluggable = pipe.container.getPipePluggable(rayTraceResult.sideHit);
                    ItemStack[] drops = pluggable.getDropItems(pipe.container);
                    if (drops != null && drops.length > 0) {
                        return drops[0];
                    }
                }
                case Pipe: {
                    return new ItemStack(BlockGenericPipe.getPipe((IBlockAccess)world, (int)x, (int)y, (int)z).item, 1, BlockGenericPipe.getPipe((IBlockAccess)world, (int)x, (int)y, (int)z).container.getItemMetadata());
                }
            }
        }
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.container.scheduleNeighborChange();
            pipe.container.redstoneInput = 0;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                ForgeDirection d = ForgeDirection.getOrientation((int)i);
                pipe.container.redstoneInputSide[i] = this.getRedstoneInputToPipe(world, x, y, z, d);
                if (pipe.container.redstoneInput >= pipe.container.redstoneInputSide[i]) continue;
                pipe.container.redstoneInput = pipe.container.redstoneInputSide[i];
            }
        }
    }

    private int getRedstoneInputToPipe(World world, int x, int y, int z, ForgeDirection d) {
        Block block;
        int i = d.ordinal();
        int input = world.func_72879_k(x + d.offsetX, y + d.offsetY, z + d.offsetZ, i);
        if (input == 0 && (input = world.func_72878_l(x + d.offsetX, y + d.offsetY, z + d.offsetZ, i)) == 0 && d != ForgeDirection.DOWN && (block = world.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ)) instanceof BlockRedstoneWire) {
            return world.func_72805_g(x + d.offsetX, y + d.offsetY, z + d.offsetZ);
        }
        return input;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        super.func_149660_a(world, x, y, z, side, par6, par7, par8, meta);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlaced();
        }
        return meta;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        super.func_149689_a(world, x, y, z, placer, stack);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlacedBy(placer);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        super.func_149727_a(world, x, y, z, player, side, xOffset, yOffset, zOffset);
        BlockInteractionEvent event = new BlockInteractionEvent(player, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return true;
        }
        world.func_147459_d(x, y, z, (Block)BuildCraftTransport.genericPipeBlock);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            ItemStack currentItem = player.func_71045_bC();
            if (player.func_70093_af() && currentItem == null) {
                if (this.stripEquipment(world, x, y, z, player, pipe, ForgeDirection.getOrientation((int)side))) {
                    return true;
                }
            } else if (currentItem != null) {
                if (currentItem.func_77973_b() == Items.field_151155_ap) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof ItemPipe) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof ItemGateCopier) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof IToolWrench) {
                    return pipe.blockActivated(player);
                }
                if (currentItem.func_77973_b() instanceof ItemMapLocation) {
                    return false;
                }
                if (PipeWire.RED.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.RED)) {
                        return true;
                    }
                } else if (PipeWire.BLUE.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.BLUE)) {
                        return true;
                    }
                } else if (PipeWire.GREEN.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.GREEN)) {
                        return true;
                    }
                } else if (PipeWire.YELLOW.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.YELLOW)) {
                        return true;
                    }
                } else {
                    RaytraceResult rayTraceResult;
                    if (currentItem.func_77973_b() == Items.field_151131_as) {
                        if (!world.field_72995_K) {
                            pipe.container.setPipeColor(-1);
                        }
                        return true;
                    }
                    if (currentItem.func_77973_b() instanceof IPipePluggableItem) {
                        if (this.addOrStripPipePluggable(world, x, y, z, currentItem, player, ForgeDirection.getOrientation((int)side), pipe)) {
                            return true;
                        }
                    } else if (currentItem.func_77973_b() instanceof ItemRobot && !world.field_72995_K && (rayTraceResult = this.doRayTrace(world, x, y, z, player)) != null && rayTraceResult.hitPart == Part.Pluggable && pipe.container.getPipePluggable(rayTraceResult.sideHit) instanceof RobotStationPluggable) {
                        DockingStation station = pipe.container.getStation(rayTraceResult.sideHit);
                        if (!station.isTaken()) {
                            if (ItemRobot.getRobotNBT(currentItem) == null) {
                                return true;
                            }
                            RobotPlacementEvent robotEvent = new RobotPlacementEvent(player, ((NBTTagCompound)currentItem.field_77990_d.func_74781_a("board")).func_74779_i("id"));
                            FMLCommonHandler.instance().bus().post((Event)robotEvent);
                            if (robotEvent.isCanceled()) {
                                return true;
                            }
                            EntityRobot robot = ((ItemRobot)currentItem.func_77973_b()).createRobot(currentItem, world);
                            if (robot != null && robot.getRegistry() != null) {
                                robot.setUniqueRobotId(robot.getRegistry().getNextRobotId());
                                robot.getBattery().setEnergy(100000);
                                float px = (float)x + 0.5f + (float)rayTraceResult.sideHit.offsetX * 0.5f;
                                float py = (float)y + 0.5f + (float)rayTraceResult.sideHit.offsetY * 0.5f;
                                float pz = (float)z + 0.5f + (float)rayTraceResult.sideHit.offsetZ * 0.5f;
                                robot.func_70107_b(px, py, pz);
                                station.takeAsMain(robot);
                                robot.dock(robot.getLinkedStation());
                                world.func_72838_d((Entity)robot);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    --player.func_71045_bC().field_77994_a;
                                }
                            }
                        }
                        return true;
                    }
                }
            }
            Gate clickedGate = null;
            RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, player);
            if (rayTraceResult != null && rayTraceResult.hitPart == Part.Pluggable && pipe.container.getPipePluggable(rayTraceResult.sideHit) instanceof GatePluggable) {
                clickedGate = pipe.gates[rayTraceResult.sideHit.ordinal()];
            }
            if (clickedGate != null) {
                clickedGate.openGui(player);
                return true;
            }
            return pipe.blockActivated(player);
        }
        return false;
    }

    private boolean addOrStripPipePluggable(World world, int x, int y, int z, ItemStack stack, EntityPlayer player, ForgeDirection side, Pipe<?> pipe) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, player);
        ForgeDirection placementSide = rayTraceResult != null && rayTraceResult.sideHit != ForgeDirection.UNKNOWN ? rayTraceResult.sideHit : side;
        IPipePluggableItem pluggableItem = (IPipePluggableItem)stack.func_77973_b();
        PipePluggable pluggable = pluggableItem.createPipePluggable(pipe, placementSide, stack);
        if (pluggable == null) {
            return false;
        }
        if (player.func_70093_af() && pipe.container.hasPipePluggable(side) && rayTraceResult != null && rayTraceResult.hitPart == Part.Pluggable && pluggable.getClass().isInstance(pipe.container.getPipePluggable(side))) {
            return pipe.container.setPluggable(side, null, player);
        }
        if (rayTraceResult != null && rayTraceResult.hitPart == Part.Pipe && !pipe.container.hasPipePluggable(placementSide)) {
            pipe.container.setPluggable(placementSide, pluggable, player);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean addOrStripWire(EntityPlayer player, Pipe<?> pipe, PipeWire color) {
        if (this.addWire(pipe, color)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71045_bC().func_77979_a(1);
            }
            return true;
        }
        return player.func_70093_af() && this.stripWire(pipe, color, player);
    }

    private boolean addWire(Pipe<?> pipe, PipeWire color) {
        if (!pipe.wireSet[color.ordinal()]) {
            pipe.wireSet[color.ordinal()] = true;
            pipe.signalStrength[color.ordinal()] = 0;
            pipe.updateSignalState();
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    private boolean stripWire(Pipe<?> pipe, PipeWire color, EntityPlayer player) {
        if (pipe.wireSet[color.ordinal()]) {
            if (!pipe.container.func_145831_w().field_72995_K) {
                this.dropWire(color, pipe, player);
            }
            pipe.signalStrength[color.ordinal()] = 0;
            pipe.wireSet[color.ordinal()] = false;
            pipe.updateSignalState();
            BlockGenericPipe.updateNeighbourSignalState(pipe);
            if (BlockGenericPipe.isFullyDefined(pipe)) {
                pipe.resolveActions();
            }
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    private boolean stripEquipment(World world, int x, int y, int z, EntityPlayer player, Pipe<?> pipe, ForgeDirection side) {
        if (!world.field_72995_K) {
            ForgeDirection nSide = side;
            RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, player);
            if (rayTraceResult != null && rayTraceResult.hitPart != Part.Pipe) {
                nSide = rayTraceResult.sideHit;
            }
            if (pipe.container.hasPipePluggable(nSide)) {
                return pipe.container.setPluggable(nSide, null, player);
            }
            for (PipeWire color : PipeWire.values()) {
                if (!this.stripWire(pipe, color, player)) continue;
                return true;
            }
        }
        return false;
    }

    private void dropWire(PipeWire pipeWire, Pipe<?> pipe, EntityPlayer player) {
        Utils.dropTryIntoPlayerInventory(pipe.container.getWorld(), pipe.container.x(), pipe.container.y(), pipe.container.z(), pipeWire.getStack(), player);
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        super.func_149670_a(world, i, j, k, entity);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        Pipe<?> pipe = BlockGenericPipe.getPipe(world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.canConnectRedstone();
        }
        return false;
    }

    public int func_149748_c(IBlockAccess iblockaccess, int x, int y, int z, int l) {
        Pipe<?> pipe = BlockGenericPipe.getPipe(iblockaccess, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isPoweringTo(l);
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int i, int j, int k, int l) {
        Pipe<?> pipe = BlockGenericPipe.getPipe(world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isIndirectlyPoweringTo(l);
        }
        return 0;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.randomDisplayTick(random);
        }
    }

    public static ItemPipe registerPipe(Class<? extends Pipe> clas, CreativeTabBuildCraft creativeTab) {
        ItemPipe item = new ItemPipe(creativeTab);
        item.func_77655_b("buildcraftPipe." + clas.getSimpleName().toLowerCase(Locale.ENGLISH));
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        pipes.put(item, clas);
        Pipe<?> dummyPipe = BlockGenericPipe.createPipe(item);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem());
            TransportProxy.proxy.setIconProviderFromPipe(item, dummyPipe);
        }
        return item;
    }

    public static Pipe<?> createPipe(Item key) {
        try {
            Class<? extends Pipe> pipe = pipes.get(key);
            if (pipe != null) {
                return pipe.getConstructor(Item.class).newInstance(key);
            }
            BCLog.logger.warn("Detected pipe with unknown key (" + key + "). Did you remove a buildcraft addon?");
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.warn("Failed to create pipe with (" + key + "). No valid constructor found. Possibly a item ID conflit.");
        }
        return null;
    }

    public static boolean placePipe(Pipe<?> pipe, World world, int i, int j, int k, Block block, int meta, EntityPlayer player) {
        TileEntity tile;
        if (world.field_72995_K) {
            return true;
        }
        boolean placed = world.func_147465_d(i, j, k, block, meta, 3);
        if (placed && (tile = world.func_147438_o(i, j, k)) instanceof TileGenericPipe) {
            TileGenericPipe tilePipe = (TileGenericPipe)tile;
            tilePipe.initialize(pipe);
            tilePipe.sendUpdateToClient();
            FMLCommonHandler.instance().bus().post((Event)new PipePlacedEvent(player, pipe.item.func_77658_a(), i, j, k));
        }
        return placed;
    }

    public static Pipe<?> getPipe(IBlockAccess blockAccess, int i, int j, int k) {
        IPipe pipe;
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile instanceof IPipeTile && !tile.func_145837_r() && (pipe = ((IPipeTile)tile).getPipe()) instanceof Pipe) {
            return (Pipe)pipe;
        }
        return null;
    }

    public static boolean isFullyDefined(Pipe<?> pipe) {
        return pipe != null && pipe.transport != null && pipe.container != null;
    }

    public static boolean isValid(Pipe<?> pipe) {
        return BlockGenericPipe.isFullyDefined(pipe);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (!this.skippedFirstIconRegister) {
            this.skippedFirstIconRegister = true;
            return;
        }
        BuildCraftTransport.instance.wireIconProvider.registerIcons(iconRegister);
        for (Item i : pipes.keySet()) {
            Pipe<?> dummyPipe = BlockGenericPipe.createPipe(i);
            if (dummyPipe == null) continue;
            dummyPipe.getIconProvider().registerIcons(iconRegister);
        }
        for (GateDefinition.GateMaterial gateMaterial : GateDefinition.GateMaterial.VALUES) {
            gateMaterial.registerBlockIcon(iconRegister);
        }
        for (Enum enum_ : GateDefinition.GateLogic.VALUES) {
            ((GateDefinition.GateLogic)enum_).registerBlockIcon(iconRegister);
        }
        for (IGateExpansion expansion : GateExpansions.getExpansions()) {
            expansion.registerBlockOverlay(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        IIcon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int sideHit = target.field_72310_e;
        BlockGenericPipe block = BuildCraftTransport.genericPipeBlock;
        float b = 0.1f;
        double px = (double)x + this.rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(b * 2.0f)) + (double)b + block.func_149704_x();
        double py = (double)y + this.rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(b * 2.0f)) + (double)b + block.func_149665_z();
        double pz = (double)z + this.rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(b * 2.0f)) + (double)b + block.func_149706_B();
        if (sideHit == 0) {
            py = (double)y + block.func_149665_z() - (double)b;
        }
        if (sideHit == 1) {
            py = (double)y + block.func_149669_A() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.func_149706_B() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.func_149693_C() + (double)b;
        }
        if (sideHit == 4) {
            px = (double)x + block.func_149704_x() - (double)b;
        }
        if (sideHit == 5) {
            px = (double)x + block.func_149753_y() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, 0.0, 0.0, 0.0, (Block)block, sideHit, worldObj.func_72805_g(x, y, z));
        fx.func_110125_a(icon);
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        IIcon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, (Block)BuildCraftTransport.genericPipeBlock, random, meta);
                    fx.func_110125_a(icon);
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (facadeRenderColor != -1) {
            return facadeRenderColor;
        }
        return super.func_149720_d(world, x, y, z);
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileGenericPipe pipeTile = (TileGenericPipe)world.func_147438_o(x, y, z);
        if (!pipeTile.hasBlockingPluggable(side)) {
            return pipeTile.setPipeColor(colour);
        }
        return false;
    }

    public static void updateNeighbourSignalState(Pipe<?> pipe) {
        TileBuffer[] neighbours = pipe.container.getTileCache();
        if (neighbours != null) {
            for (int i = 0; i < 6; ++i) {
                if (neighbours[i] == null || !(neighbours[i].getTile() instanceof IPipeTile) || neighbours[i].getTile().func_145837_r() || !(((IPipeTile)neighbours[i].getTile()).getPipe() instanceof Pipe)) continue;
                ((Pipe)((IPipeTile)neighbours[i].getTile()).getPipe()).updateSignalState();
            }
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return PipeIconProvider.TYPE.PipeItemsStone.getIcon();
    }

    static class RaytraceResult {
        public final Part hitPart;
        public final MovingObjectPosition movingObjectPosition;
        public final AxisAlignedBB boundingBox;
        public final ForgeDirection sideHit;

        RaytraceResult(Part hitPart, MovingObjectPosition movingObjectPosition, AxisAlignedBB boundingBox, ForgeDirection side) {
            this.hitPart = hitPart;
            this.movingObjectPosition = movingObjectPosition;
            this.boundingBox = boundingBox;
            this.sideHit = side;
        }

        public String toString() {
            return String.format("RayTraceResult: %s, %s", this.hitPart == null ? "null" : this.hitPart.name(), this.boundingBox == null ? "null" : this.boundingBox.toString());
        }
    }

    static enum Part {
        Pipe,
        Pluggable;

    }
}

