/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.robots.AIRobotSleep;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerRobotSleep
extends BCStatement
implements ITriggerInternal {
    public TriggerRobotSleep() {
        super("buildcraft:robot.sleep");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.robot.sleep");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_robot_sleep");
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        Pipe pipe = (Pipe)((IGate)((Object)container)).getPipe();
        TileGenericPipe tile = pipe.container;
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            DockingStation station = tile.getStation(d);
            if (station == null || station.robotTaking() == null) continue;
            EntityRobot robot = (EntityRobot)station.robotTaking();
            if (!(robot.mainAI.getActiveAI() instanceof AIRobotSleep)) continue;
            return true;
        }
        return false;
    }
}

