/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAssemblyTable
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/assembly_table.png");
    private final TileAssemblyTable table;

    public GuiAssemblyTable(IInventory playerInventory, TileAssemblyTable assemblyTable) {
        super(new ContainerAssemblyTable(playerInventory, assemblyTable), assemblyTable, TEXTURE);
        this.table = assemblyTable;
        this.field_146999_f = 176;
        this.field_147000_g = 207;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.slots.add(new RecipeSlot(134 + 18 * j, 36 + 18 * i));
            }
        }
        this.updateRecipes();
    }

    public void updateRecipes() {
        List<CraftingResult<ItemStack>> potentialRecipes = this.table.getPotentialOutputs();
        Iterator<CraftingResult<ItemStack>> cur = potentialRecipes.iterator();
        for (AdvancedSlot s : this.slots) {
            if (cur.hasNext()) {
                ((RecipeSlot)s).crafting = cur.next();
                continue;
            }
            ((RecipeSlot)s).crafting = null;
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = StringUtils.localize("tile.assemblyTableBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 15, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.updateRecipes();
        for (AdvancedSlot slot2 : this.slots) {
            RecipeSlot slot = (RecipeSlot)slot2;
            if (slot.crafting == null) continue;
            if (this.table.isAssembling(slot.crafting.recipe)) {
                this.func_73729_b(this.field_147003_i + slot.x, this.field_147009_r + slot.y, 196, 1, 16, 16);
                continue;
            }
            if (!this.table.isPlanned(slot.crafting.recipe)) continue;
            this.func_73729_b(this.field_147003_i + slot.x, this.field_147009_r + slot.y, 177, 1, 16, 16);
        }
        int h = this.table.getProgressScaled(70);
        this.func_73729_b(this.field_147003_i + 95, this.field_147009_r + 36 + 70 - h, 176, 18, 4, h);
        this.drawBackgroundSlots();
    }

    @Override
    protected void slotClicked(AdvancedSlot aslot, int mouseButton) {
        super.slotClicked(aslot, mouseButton);
        if (aslot instanceof RecipeSlot) {
            RecipeSlot slot = (RecipeSlot)aslot;
            if (slot.crafting == null) {
                return;
            }
            boolean select = !this.table.isPlanned(slot.crafting.recipe);
            String id = slot.crafting.recipe.getId();
            this.table.rpcSelectRecipe(id, select);
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    class RecipeSlot
    extends AdvancedSlot {
        public CraftingResult<ItemStack> crafting;

        public RecipeSlot(int x, int y) {
            super(GuiAssemblyTable.this, x, y);
        }

        @Override
        public ItemStack getItemStack() {
            if (this.crafting != null) {
                return (ItemStack)this.crafting.crafted;
            }
            return null;
        }
    }

    private class LaserTableLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public LaserTableLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiAssemblyTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiAssemblyTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiAssemblyTable.this.field_146289_q.func_78276_b(String.format("%d RF", ((GuiAssemblyTable)GuiAssemblyTable.this).table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiAssemblyTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiAssemblyTable.this.field_146289_q.func_78276_b(String.format("%d RF", GuiAssemblyTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiAssemblyTable.this.field_146289_q.func_78261_a(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiAssemblyTable.this.field_146289_q.func_78276_b(String.format("%.1f RF/t", Float.valueOf((float)GuiAssemblyTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiAssemblyTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

