/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.boards;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;

public class ImplRedstoneBoardRegistry
extends RedstoneBoardRegistry {
    private float totalProbability;
    private HashMap<String, BoardFactory> boards = new HashMap();
    private Random rand = new Random();

    @Override
    public void registerBoardClass(RedstoneBoardNBT<?> redstoneBoardNBT, float probability) {
        if (BuildCraftSilicon.blacklistedRobots.contains(redstoneBoardNBT.getID())) {
            return;
        }
        BoardFactory factory = new BoardFactory();
        factory.boardNBT = redstoneBoardNBT;
        factory.probability = probability;
        this.totalProbability += probability;
        this.boards.put(redstoneBoardNBT.getID(), factory);
    }

    @Override
    public void createRandomBoard(NBTTagCompound nbt) {
        float value = this.rand.nextFloat() * this.totalProbability;
        float accumulatedSearch = 0.0f;
        for (BoardFactory f : this.boards.values()) {
            if (!((accumulatedSearch += f.probability) > value)) continue;
            f.boardNBT.createBoard(nbt);
            return;
        }
    }

    @Override
    public RedstoneBoardNBT<?> getRedstoneBoard(NBTTagCompound nbt) {
        return this.getRedstoneBoard(nbt.func_74779_i("id"));
    }

    @Override
    public RedstoneBoardNBT<?> getRedstoneBoard(String id) {
        BoardFactory factory = this.boards.get(id);
        if (factory != null) {
            return factory.boardNBT;
        }
        return null;
    }

    @Override
    public void registerIcons(IIconRegister par1IconRegister) {
        for (BoardFactory f : this.boards.values()) {
            f.boardNBT.registerIcons(par1IconRegister);
        }
    }

    @Override
    public Collection<RedstoneBoardNBT<?>> getAllBoardNBTs() {
        ArrayList result = new ArrayList();
        for (BoardFactory f : this.boards.values()) {
            result.add(f.boardNBT);
        }
        return result;
    }

    private static class BoardFactory {
        public RedstoneBoardNBT<?> boardNBT;
        public float probability;

        private BoardFactory() {
        }
    }
}

