/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRefinery
extends TileBuildCraft
implements IFluidHandler,
IInventory,
IHasWork,
IFlexibleCrafter {
    public static int LIQUID_PER_SLOT = 4000;
    public IFlexibleRecipe<FluidStack> currentRecipe;
    public CraftingResult<FluidStack> craftingResult;
    public SingleUseTank[] tanks = new SingleUseTank[]{new SingleUseTank("tank1", LIQUID_PER_SLOT, this), new SingleUseTank("tank2", LIQUID_PER_SLOT, this)};
    public SingleUseTank result = new SingleUseTank("result", LIQUID_PER_SLOT, this);
    public TankManager<SingleUseTank> tankManager = new TankManager((Tank[])new SingleUseTank[]{this.tanks[0], this.tanks[1], this.result});
    public float animationSpeed = 1.0f;
    private short animationStage = 0;
    private SafeTimeTracker time = new SafeTimeTracker();
    private SafeTimeTracker updateNetworkTime = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private boolean isActive;
    private String currentRecipeId = "";

    public TileRefinery() {
        this.setBattery(new RFBattery(10000, 1500, 0));
        this.tanks[0].setAcceptedFluid(BuildCraftEnergy.fluidOil);
        this.tanks[1].setAcceptedFluid(BuildCraftEnergy.fluidOil);
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public String func_145825_b() {
        return null;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.simpleAnimationIterate();
            return;
        }
        if (this.updateNetworkTime.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        this.isActive = false;
        if (this.currentRecipe == null) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.fill(((FluidStack)this.craftingResult.crafted).copy(), false) != ((FluidStack)this.craftingResult.crafted).amount) {
            this.decreaseAnimation();
            return;
        }
        this.isActive = true;
        if (this.getBattery().getEnergyStored() >= this.craftingResult.energyCost) {
            this.increaseAnimation();
        } else {
            this.decreaseAnimation();
        }
        if (!this.time.markTimeIfDelay(this.field_145850_b, this.craftingResult.craftingTime)) {
            return;
        }
        if (this.getBattery().useEnergy(this.craftingResult.energyCost, this.craftingResult.energyCost, false) > 0) {
            CraftingResult<FluidStack> r = this.currentRecipe.craft(this, false);
            this.result.fill(((FluidStack)r.crafted).copy(), true);
        }
    }

    private boolean containsInput(FluidStack ingredient) {
        if (ingredient == null) {
            return true;
        }
        return this.tanks[0].getFluid() != null && this.tanks[0].getFluid().containsFluid(ingredient) || this.tanks[1].getFluid() != null && this.tanks[1].getFluid().containsFluid(ingredient);
    }

    private boolean consumeInput(FluidStack liquid) {
        if (liquid == null) {
            return true;
        }
        if (this.tanks[0].getFluid() != null && this.tanks[0].getFluid().containsFluid(liquid)) {
            this.tanks[0].drain(liquid.amount, true);
            return true;
        }
        if (this.tanks[1].getFluid() != null && this.tanks[1].getFluid().containsFluid(liquid)) {
            this.tanks[1].drain(liquid.amount, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWork() {
        return this.isActive;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
        this.animationStage = data.func_74765_d("animationStage");
        this.animationSpeed = data.func_74760_g("animationSpeed");
        this.updateRecipe();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
        data.func_74777_a("animationStage", this.animationStage);
        data.func_74776_a("animationSpeed", this.animationSpeed);
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    public void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (short)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = (short)100;
            }
        } else if (this.animationStage > 0) {
            this.animationStage = (short)(this.animationStage - 1);
        }
    }

    public void increaseAnimation() {
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (short)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = (short)100;
        }
    }

    public void decreaseAnimation() {
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (short)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = (short)100;
            }
        } else if (this.animationStage > 0) {
            this.animationStage = (short)(this.animationStage - 1);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void resetFilters() {
        for (SingleUseTank tank : this.tankManager) {
            tank.setAcceptedFluid(null);
        }
    }

    public void setFilter(int number, Fluid fluid) {
        ((SingleUseTank)((Object)this.tankManager.get(number))).setAcceptedFluid(fluid);
    }

    public Fluid getFilter(int number) {
        return ((SingleUseTank)((Object)this.tankManager.get(number))).getAcceptedFluid();
    }

    public void getGUINetworkData(int id, int data) {
        switch (id) {
            case 0: {
                this.setFilter(0, FluidRegistry.getFluid((int)data));
                break;
            }
            case 1: {
                this.setFilter(1, FluidRegistry.getFluid((int)data));
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.getFilter(0) != null) {
            iCrafting.func_71112_a(container, 0, this.getFilter(0).getID());
        }
        if (this.getFilter(1) != null) {
            iCrafting.func_71112_a(container, 1, this.getFilter(1).getID());
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        FluidStack resourceUsing = resource.copy();
        if (RefineryRecipeManager.INSTANCE.getValidFluidStacks1().contains(resource)) {
            resourceUsing.amount -= (used += this.tanks[0].fill(resourceUsing, doFill));
        }
        if (RefineryRecipeManager.INSTANCE.getValidFluidStacks2().contains(resource)) {
            resourceUsing.amount -= (used += this.tanks[1].fill(resourceUsing, doFill));
        }
        this.updateRecipe();
        return used;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        FluidStack r = this.result.drain(maxEmpty, doDrain);
        this.updateRecipe();
        return r;
    }

    private void updateRecipe() {
        this.currentRecipe = null;
        this.craftingResult = null;
        for (IFlexibleRecipe<FluidStack> recipe : RefineryRecipeManager.INSTANCE.getRecipes()) {
            this.craftingResult = recipe.craft(this, true);
            if (this.craftingResult == null) continue;
            this.currentRecipe = recipe;
            this.currentRecipeId = this.currentRecipe.getId();
            break;
        }
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.result.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeFloat(this.animationSpeed);
        Utils.writeUTF(stream, this.currentRecipeId);
        this.tankManager.writeData(stream);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.animationSpeed = stream.readFloat();
        this.currentRecipeId = Utils.readUTF(stream);
        this.tankManager.readData(stream);
        this.currentRecipe = RefineryRecipeManager.INSTANCE.getRecipe(this.currentRecipeId);
        if (this.currentRecipe != null) {
            this.craftingResult = this.currentRecipe.craft(this, true);
        }
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int getCraftingItemStackSize() {
        return 0;
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return null;
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return null;
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return this.tanks[tankid].getFluid();
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        FluidStack resultF;
        if (val >= this.tanks[tankid].getFluid().amount) {
            resultF = this.tanks[tankid].getFluid();
            this.tanks[tankid].setFluid(null);
        } else {
            resultF = this.tanks[tankid].getFluid().copy();
            resultF.amount = val;
            this.tanks[tankid].getFluid().amount -= val;
        }
        this.updateRecipe();
        return resultF;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return this.tanks.length;
    }
}

