/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryConcatenator;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.Utils;
import java.lang.ref.WeakReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAutoWorkbench
extends TileBuildCraft
implements ISidedInventory {
    public static final int SLOT_RESULT = 0;
    public static final int CRAFT_TIME = 256;
    public static final int UPDATE_TIME = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);
    public InventoryCrafting craftMatrix = new LocalInventoryCrafting();
    public boolean useLast;
    public int progress;
    private boolean isJammed;
    private boolean needsBalancing;
    private SimpleInventory resultInv = new SimpleInventory(1, "Auto Workbench", 64);
    private IInventory inv = InventoryConcatenator.make().add(this.resultInv).add((IInventory)this.craftMatrix);
    private SlotCrafting craftSlot;
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private int update = Utils.RANDOM.nextInt();

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.inv.func_70296_d();
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inv.func_70298_a(slot, count);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.resultInv.readFromNBT(data);
        InvUtils.readInvFromNBT((IInventory)this.craftMatrix, "matrix", data);
        if (data.func_74764_b("stackList")) {
            ItemStack[] stacks = new ItemStack[9];
            InvUtils.readStacksFromNBT(data, "stackList", stacks);
            for (int i = 0; i < 9; ++i) {
                this.craftMatrix.func_70299_a(i, stacks[i]);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.resultInv.writeToNBT(data);
        InvUtils.writeInvToNBT((IInventory)this.craftMatrix, "matrix", data);
    }

    public ItemStack findRecipeOutput() {
        IRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return null;
        }
        ItemStack result = recipe.func_77572_b(this.craftMatrix);
        if (result != null) {
            result = result.func_77946_l();
        }
        return result;
    }

    public IRecipe findRecipe() {
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            if (!stack.func_77985_e()) {
                return null;
            }
            if (!stack.func_77973_b().hasContainerItem(stack)) continue;
            return null;
        }
        return CraftingHelper.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.needsBalancing) {
            this.balanceSlots();
        }
        if (this.isJammed) {
            return;
        }
        if (this.craftSlot == null) {
            this.craftSlot = new SlotCrafting((EntityPlayer)this.getInternalPlayer().get(), (IInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 0, 0);
        }
        if (this.resultInv.func_70301_a(0) != null) {
            return;
        }
        ++this.update;
        if (this.update % 16 == 0) {
            this.updateCrafting();
        }
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 256;
    }

    private void balanceSlots() {
        for (IInvSlot slotA : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stackA = slotA.getStackInSlot();
            if (stackA == null) continue;
            for (IInvSlot slotB : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
                ItemStack stackB;
                if (slotA.getIndex() == slotB.getIndex() || (stackB = slotB.getStackInSlot()) == null || !StackHelper.canStacksMerge(stackA, stackB) || stackA.field_77994_a <= stackB.field_77994_a + 1) continue;
                --stackA.field_77994_a;
                ++stackB.field_77994_a;
                return;
            }
        }
        this.needsBalancing = false;
    }

    private void updateCrafting() {
        IRecipe recipe = this.findRecipe();
        if (recipe == null) {
            this.progress = 0;
            this.isJammed = true;
            return;
        }
        if (!this.useLast && this.isLast()) {
            this.progress = 0;
            this.isJammed = true;
            return;
        }
        this.progress += 16;
        if (this.progress < 256) {
            return;
        }
        this.progress = 0;
        this.useLast = false;
        ItemStack result = recipe.func_77572_b(this.craftMatrix);
        if (result == null) {
            this.isJammed = true;
            return;
        }
        result = result.func_77946_l();
        this.craftSlot.func_82870_a((EntityPlayer)this.getInternalPlayer().get(), result);
        this.resultInv.func_70299_a(0, result);
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)((EntityPlayer)this.getInternalPlayer().get()).field_71071_by, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            slot.setStackInSlot(null);
            InvUtils.dropItems(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!stack.func_77985_e()) {
            return false;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return false;
        }
        return this.func_70301_a(slot) != null;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean isLast() {
        int minStackSize = 64;
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.field_77994_a >= minStackSize) continue;
            minStackSize = stack.field_77994_a;
        }
        return minStackSize <= 1;
    }

    public boolean func_145818_k_() {
        return false;
    }

    private class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer entityplayer) {
                    return false;
                }
            }, 3, 3);
        }

        public void func_70299_a(int slot, ItemStack stack) {
            super.func_70299_a(slot, stack);
            TileAutoWorkbench.this.isJammed = false;
            TileAutoWorkbench.this.needsBalancing = true;
        }

        public void func_70296_d() {
            super.func_70296_d();
            TileAutoWorkbench.this.isJammed = false;
            TileAutoWorkbench.this.needsBalancing = true;
        }

        public ItemStack func_70298_a(int slot, int amount) {
            TileAutoWorkbench.this.isJammed = false;
            TileAutoWorkbench.this.needsBalancing = true;
            return super.func_70298_a(slot, amount);
        }
    }
}

