/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.IInventoryRenderer;
import buildcraft.energy.TileEngine;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends TileEntitySpecialRenderer
implements IInventoryRenderer {
    private static final float[] angleMap = new float[6];
    private ModelBase model = new ModelBase(){};
    private ModelRenderer box = new ModelRenderer(this.model, 0, 1);
    private ModelRenderer trunk;
    private ModelRenderer movingBox;
    private ModelRenderer chamber;
    private ResourceLocation baseTexture;
    private ResourceLocation chamberTexture;
    private ResourceLocation trunkTexture;

    public RenderEngine() {
        this.box.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.box.field_78800_c = 8.0f;
        this.box.field_78797_d = 8.0f;
        this.box.field_78798_e = 8.0f;
        this.trunk = new ModelRenderer(this.model, 1, 1);
        this.trunk.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.field_78800_c = 8.0f;
        this.trunk.field_78797_d = 8.0f;
        this.trunk.field_78798_e = 8.0f;
        this.movingBox = new ModelRenderer(this.model, 0, 1);
        this.movingBox.func_78789_a(-8.0f, -4.0f, -8.0f, 16, 4, 16);
        this.movingBox.field_78800_c = 8.0f;
        this.movingBox.field_78797_d = 8.0f;
        this.movingBox.field_78798_e = 8.0f;
        this.chamber = new ModelRenderer(this.model, 1, 1);
        this.chamber.func_78789_a(-5.0f, -4.0f, -5.0f, 10, 2, 10);
        this.chamber.field_78800_c = 8.0f;
        this.chamber.field_78797_d = 8.0f;
        this.chamber.field_78798_e = 8.0f;
    }

    public RenderEngine(ResourceLocation baseTexture, ResourceLocation chamberTexture, ResourceLocation trunkTexture) {
        this();
        this.baseTexture = baseTexture;
        this.chamberTexture = chamberTexture;
        this.trunkTexture = trunkTexture;
        this.field_147501_a = TileEntityRendererDispatcher.field_147556_a;
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(0.25f, ForgeDirection.UP, this.baseTexture, this.chamberTexture, this.trunkTexture, x, y, z);
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEngine engine = (TileEngine)tileentity;
        if (engine != null) {
            this.render(engine.progress, engine.orientation, engine.getBaseTexture(), engine.getChamberTexture(), engine.getTrunkTexture(engine.getEnergyStage()), x, y, z);
        }
    }

    private void render(float progress, ForgeDirection orientation, ResourceLocation baseTexture, ResourceLocation chamberTexture, ResourceLocation trunkTexture, double x, double y, double z) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 7.99f - (progress - 0.5f) * 2.0f * 7.99f : progress * 2.0f * 7.99f;
        float translatefact = step / 16.0f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.offsetX, orientation.offsetY, orientation.offsetZ};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            default: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        this.box.field_78795_f = angle[0];
        this.box.field_78796_g = angle[1];
        this.box.field_78808_h = angle[2];
        this.trunk.field_78795_f = angle[0];
        this.trunk.field_78796_g = angle[1];
        this.trunk.field_78808_h = angle[2];
        this.movingBox.field_78795_f = angle[0];
        this.movingBox.field_78796_g = angle[1];
        this.movingBox.field_78808_h = angle[2];
        this.chamber.field_78795_f = angle[0];
        this.chamber.field_78796_g = angle[1];
        this.chamber.field_78808_h = angle[2];
        float factor = 0.0625f;
        this.func_147499_a(baseTexture);
        this.box.func_78785_a(factor);
        GL11.glTranslatef((float)(translate[0] * translatefact), (float)(translate[1] * translatefact), (float)(translate[2] * translatefact));
        this.movingBox.func_78785_a(factor);
        GL11.glTranslatef((float)(-translate[0] * translatefact), (float)(-translate[1] * translatefact), (float)(-translate[2] * translatefact));
        this.func_147499_a(chamberTexture);
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.chamber.func_78785_a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        i = 0;
        while ((float)i <= step + 2.0f) {
            GL11.glTranslatef((float)(-translate[0] * chamberf), (float)(-translate[1] * chamberf), (float)(-translate[2] * chamberf));
            i += 2;
        }
        this.func_147499_a(trunkTexture);
        this.trunk.func_78785_a(factor);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        RenderEngine.angleMap[ForgeDirection.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[ForgeDirection.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[ForgeDirection.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[ForgeDirection.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.NORTH.ordinal()] = -1.5707964f;
    }
}

