/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.core.utils.ChunkProperty;
import buildcraft.core.utils.WorldProperty;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class DimensionProperty
implements IWorldAccess {
    private LongHashMap chunkMapping = new LongHashMap();
    private World world;
    private int worldHeight;
    private WorldProperty worldProperty;

    public DimensionProperty(World iWorld, WorldProperty iProp) {
        this.world = iWorld;
        this.worldHeight = iWorld.func_72940_L();
        this.world.func_72954_a((IWorldAccess)this);
        this.worldProperty = iProp;
    }

    public synchronized boolean get(int x, int y, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        if (this.world.func_72863_F().func_73149_a(xChunk, zChunk)) {
            ChunkProperty property;
            long chunkId = ChunkCoordIntPair.func_77272_a((int)xChunk, (int)zChunk);
            if (!this.chunkMapping.func_76161_b(chunkId)) {
                property = new ChunkProperty((IBlockAccess)this.world, this.world.func_72800_K(), xChunk, zChunk);
                this.chunkMapping.func_76163_a(chunkId, (Object)property);
                this.load(this.world.func_72964_e(xChunk, zChunk), property);
            } else {
                property = (ChunkProperty)this.chunkMapping.func_76164_a(chunkId);
            }
            return property.get(x & 0xF, y, z & 0xF);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Chunk chunk, ChunkProperty property) {
        World world = this.world;
        synchronized (world) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < this.worldHeight; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        Block block = chunk.func_150810_a(x, y, z);
                        int meta = chunk.func_76628_c(x, y, z);
                        boolean prop = this.worldProperty.get((IBlockAccess)this.world, block, meta, chunk.field_76635_g * 16 + x, y, chunk.field_76647_h * 16 + z);
                        property.set(x, y, z, prop);
                    }
                }
            }
        }
    }

    public synchronized void func_147586_a(int x, int y, int z) {
        long chunkId;
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        if (this.world.func_72863_F().func_73149_a(xChunk, zChunk) && this.chunkMapping.func_76161_b(chunkId = ChunkCoordIntPair.func_77272_a((int)xChunk, (int)zChunk))) {
            ChunkProperty property = (ChunkProperty)this.chunkMapping.func_76164_a(chunkId);
            Block block = this.world.func_147439_a(x, y, z);
            int meta = this.world.func_72805_g(x, y, z);
            boolean prop = this.worldProperty.get((IBlockAccess)this.world, block, meta, x, y, z);
            property.set(x & 0xF, y, z & 0xF, prop);
        }
    }

    public void func_147588_b(int var1, int var2, int var3) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_72704_a(String var1, double var2, double var4, double var6, float var8, float var9) {
    }

    public void func_85102_a(EntityPlayer var1, String var2, double var3, double var5, double var7, float var9, float var10) {
    }

    public void func_72708_a(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public void func_72703_a(Entity var1) {
    }

    public void func_72709_b(Entity var1) {
    }

    public void func_72702_a(String var1, int var2, int var3, int var4) {
    }

    public void func_82746_a(int var1, int var2, int var3, int var4, int var5) {
    }

    public void func_72706_a(EntityPlayer var1, int var2, int var3, int var4, int var5, int var6) {
    }

    public void func_147587_b(int var1, int var2, int var3, int var4, int var5) {
    }

    public void func_147584_b() {
    }

    public void clear() {
        this.world.func_72848_b((IWorldAccess)this);
    }
}

