/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerEnergy
extends BCStatement
implements ITriggerInternal,
ITriggerExternal {
    private boolean high;

    public TriggerEnergy(boolean high) {
        super("buildcraft:energyStored" + (high ? "high" : "low"));
        this.high = high;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.machine.energyStored" + (this.high ? "High" : "Low"));
    }

    private boolean isTriggeredEnergyHandler(IEnergyConnection connection, ForgeDirection side) {
        int energyMaxStored;
        int energyStored;
        if (connection instanceof IEnergyHandler) {
            energyStored = ((IEnergyHandler)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyHandler)connection).getMaxEnergyStored(side);
        } else if (connection instanceof IEnergyProvider) {
            energyStored = ((IEnergyProvider)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyProvider)connection).getMaxEnergyStored(side);
        } else if (connection instanceof IEnergyReceiver) {
            energyStored = ((IEnergyReceiver)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyReceiver)connection).getMaxEnergyStored(side);
        } else {
            return false;
        }
        if (energyMaxStored > 0) {
            if (this.high) {
                return (double)(energyStored / energyMaxStored) > 0.95;
            }
            return (double)(energyStored / energyMaxStored) < 0.05;
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        IGate gate;
        if (container instanceof IGate && (gate = (IGate)((Object)container)).getPipe() instanceof IEnergyHandler) {
            return this.isTriggeredEnergyHandler((IEnergyHandler)((Object)gate.getPipe()), ForgeDirection.UNKNOWN);
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        if ((tile instanceof IEnergyHandler || tile instanceof IEnergyProvider || tile instanceof IEnergyReceiver) && ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite())) {
            return this.isTriggeredEnergyHandler((IEnergyConnection)tile, side.getOpposite());
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_machine_energy_" + (this.high ? "high" : "low"));
    }
}

