/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionProvider;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.transport.IPipeTile;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class DefaultActionProvider
implements IActionProvider {
    @Override
    public Collection<IActionInternal> getInternalActions(IStatementContainer container) {
        LinkedList<IActionInternal> res = new LinkedList<IActionInternal>();
        if (container.getTile() instanceof IPipeTile) {
            res.add(BuildCraftCore.actionRedstone);
        }
        return res;
    }

    @Override
    public Collection<IActionExternal> getExternalActions(ForgeDirection side, TileEntity tile) {
        LinkedList<IActionExternal> res = new LinkedList<IActionExternal>();
        try {
            if (tile instanceof IControllable) {
                for (IControllable.Mode mode : IControllable.Mode.values()) {
                    if (mode == IControllable.Mode.Unknown || !((IControllable)tile).acceptsControlMode(mode)) continue;
                    res.add(BuildCraftCore.actionControl[mode.ordinal()]);
                }
            }
        }
        catch (Throwable error) {
            BCLog.logger.error("Outdated API detected, please update your mods!");
        }
        return res;
    }
}

