/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.robots.AIRobotFetchItem;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotGotoStationAndUnload;
import buildcraft.core.robots.boards.BoardRobotPickerNBT;
import buildcraft.silicon.statements.ActionRobotFilter;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class BoardRobotPicker
extends RedstoneBoardRobot {
    public static Set<Integer> targettedItems = new HashSet<Integer>();
    private NBTTagCompound data;

    public BoardRobotPicker(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public BoardRobotPicker(EntityRobotBase robot, NBTTagCompound nbt) {
        super(robot);
        this.data = nbt;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotFetchItem(this.robot, 250.0f, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.robot.getZoneToWork()));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotFetchItem) {
            AIRobotFetchItem fetching = (AIRobotFetchItem)ai;
            if (fetching.itemPickupCancelled || fetching.target != null) {
                this.startDelegateAI(new AIRobotFetchItem(this.robot, 250.0f, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.robot.getZoneToWork()));
            } else if (this.robot.containsItems()) {
                this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot, this.robot.getZoneToWork()));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoStationAndUnload && !ai.success()) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotPickerNBT.instance;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
    }
}

