/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotBreak;
import buildcraft.core.robots.AIRobotFetchAndEquipItemStack;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotSearchBlock;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.robots.ResourceIdBlock;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class BoardRobotGenericBreakBlock
extends RedstoneBoardRobot {
    private BlockIndex indexStored;
    private ArrayList<Block> blockFilter = new ArrayList();
    private ArrayList<Integer> metaFilter = new ArrayList();

    public BoardRobotGenericBreakBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public abstract boolean isExpectedTool(ItemStack var1);

    public abstract boolean isExpectedBlock(World var1, int var2, int var3, int var4);

    public final void preemt(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            BlockIndex index = ((AIRobotSearchBlock)ai).blockFound;
            if (!this.robot.getRegistry().isTaken(new ResourceIdBlock(index))) {
                this.abortDelegateAI();
            }
        }
    }

    @Override
    public final void update() {
        if (!this.isExpectedTool(null) && this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return BoardRobotGenericBreakBlock.this.isExpectedTool(stack);
                }
            }));
        } else {
            this.updateFilter();
            this.startDelegateAI(new AIRobotSearchBlock(this.robot, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    if (BoardRobotGenericBreakBlock.this.isExpectedBlock(world, x, y, z) && !BoardRobotGenericBreakBlock.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z))) {
                        return BoardRobotGenericBreakBlock.this.matchesGateFilter(world, x, y, z);
                    }
                    return false;
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            if (this.indexStored != null) {
                this.robot.getRegistry().release(new ResourceIdBlock(this.indexStored));
            }
            this.indexStored = ((AIRobotSearchBlock)ai).blockFound;
            if (this.indexStored == null) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else if (this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(this.indexStored), this.robot)) {
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, ((AIRobotSearchBlock)ai).path));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            this.startDelegateAI(new AIRobotBreak(this.robot, this.indexStored));
        } else if (ai instanceof AIRobotBreak) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.indexStored));
            this.indexStored = null;
        }
    }

    @Override
    public void end() {
        if (this.indexStored != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.indexStored));
        }
    }

    public final void updateFilter() {
        this.blockFilter.clear();
        this.metaFilter.clear();
        DockingStation station = (DockingStation)this.robot.getLinkedStation();
        for (StatementSlot slot : new ActionIterator(station.getPipe().pipe)) {
            if (!(slot.statement instanceof ActionRobotFilter)) continue;
            for (IStatementParameter p : slot.parameters) {
                StatementParameterItemStack param;
                ItemStack stack;
                if (p == null || !(p instanceof StatementParameterItemStack) || (stack = (param = (StatementParameterItemStack)p).getItemStack()) == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                this.blockFilter.add(((ItemBlock)stack.func_77973_b()).field_150939_a);
                this.metaFilter.add(stack.func_77960_j());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesGateFilter(World world, int x, int y, int z) {
        int meta;
        Block block;
        if (this.blockFilter.size() == 0) {
            return true;
        }
        World world2 = world;
        synchronized (world2) {
            block = world.func_147439_a(x, y, z);
            meta = world.func_72805_g(x, y, z);
        }
        for (int i = 0; i < this.blockFilter.size(); ++i) {
            if (this.blockFilter.get(i) != block || this.metaFilter.get(i) != meta) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.indexStored != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.indexStored.writeTo(sub);
            nbt.func_74782_a("indexStored", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("indexStored")) {
            this.indexStored = new BlockIndex(nbt.func_74775_l("indexStored"));
        }
    }
}

