/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.api.robots.StackRequest;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.robots.AIRobotCraftAssemblyTable;
import buildcraft.core.robots.AIRobotCraftFurnace;
import buildcraft.core.robots.AIRobotCraftGeneric;
import buildcraft.core.robots.AIRobotCraftWorkbench;
import buildcraft.core.robots.AIRobotDeliverRequested;
import buildcraft.core.robots.AIRobotDisposeItems;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotGotoStationToUnload;
import buildcraft.core.robots.AIRobotSearchStackRequest;
import buildcraft.core.robots.AIRobotUnload;
import buildcraft.core.robots.boards.BoardRobotCrafterNBT;
import buildcraft.silicon.statements.ActionRobotFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BoardRobotCrafter
extends RedstoneBoardRobot {
    private ItemStack order;
    private ArrayList<ItemStack> craftingBlacklist = new ArrayList();
    private HashSet<IDockingStation> reservedStations = new HashSet();
    private StackRequest currentRequest = null;

    public BoardRobotCrafter(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotCrafterNBT.instance;
    }

    @Override
    public void update() {
        if (this.robot.containsItems()) {
            this.startDelegateAI(new AIRobotDisposeItems(this.robot));
            return;
        }
        this.order = this.currentRequest != null ? this.currentRequest.stack : null;
        if (this.order == null) {
            this.startDelegateAI(new AIRobotSearchStackRequest(this.robot, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.craftingBlacklist));
            return;
        }
        IRecipe recipe = this.lookForWorkbenchRecipe(this.order);
        if (recipe != null) {
            this.startDelegateAI(new AIRobotCraftWorkbench(this.robot, recipe));
            return;
        }
        ItemStack furnaceInput = this.lookForFurnaceRecipe(this.order);
        if (furnaceInput != null) {
            this.startDelegateAI(new AIRobotCraftFurnace(this.robot, furnaceInput, this.order));
            return;
        }
        CraftingResult<?> craftingResult = this.lookForAssemblyTableRecipe(this.order);
        if (craftingResult != null) {
            this.startDelegateAI(new AIRobotCraftAssemblyTable(this.robot, craftingResult));
            return;
        }
        this.craftingBlacklist.add(this.order);
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotCraftGeneric) {
            if (!ai.success()) {
                this.robot.releaseResources();
                this.currentRequest = null;
                this.craftingBlacklist.add(this.order);
            } else if (this.currentRequest != null) {
                this.startDelegateAI(new AIRobotDeliverRequested(this.robot, this.currentRequest));
            } else {
                this.robot.releaseResources();
                this.craftingBlacklist.clear();
            }
        } else if (ai instanceof AIRobotGotoStationToUnload) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotUnload(this.robot));
            } else {
                this.robot.releaseResources();
                this.currentRequest = null;
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotSearchStackRequest) {
            if (!ai.success()) {
                this.craftingBlacklist.clear();
                this.currentRequest = null;
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.currentRequest = ((AIRobotSearchStackRequest)ai).request;
                if (!this.currentRequest.station.take(this.robot)) {
                    this.currentRequest = null;
                }
            }
        } else if (ai instanceof AIRobotDeliverRequested) {
            this.currentRequest = null;
            this.robot.releaseResources();
            this.craftingBlacklist.clear();
        }
    }

    private IRecipe lookForWorkbenchRecipe(ItemStack order) {
        for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe r = (IRecipe)o;
            if (!(r instanceof ShapedRecipes) && !(r instanceof ShapelessRecipes) && !(r instanceof ShapedOreRecipe) && !(r instanceof ShapelessOreRecipe) || !StackHelper.isMatchingItem(r.func_77571_b(), order)) continue;
            return r;
        }
        return null;
    }

    private ItemStack lookForFurnaceRecipe(ItemStack order) {
        Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            ItemStack input = (ItemStack)e.getKey();
            ItemStack output = (ItemStack)e.getValue();
            if (!StackHelper.isMatchingItem(output, order)) continue;
            return input;
        }
        return null;
    }

    private CraftingResult<?> lookForAssemblyTableRecipe(ItemStack order) {
        for (IFlexibleRecipe<ItemStack> r : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            CraftingResult<ItemStack> result = r.canCraft(order);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isBlacklisted(ItemStack stack) {
        for (ItemStack black : this.craftingBlacklist) {
            if (!StackHelper.isMatchingItem(stack, black)) continue;
            return true;
        }
        return false;
    }
}

