/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotGotoStationToLoad;
import buildcraft.core.robots.AIRobotLoad;
import buildcraft.core.robots.AIRobotSearchRandomGroundBlock;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.robots.boards.BoardRobotBomberNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BoardRobotBomber
extends RedstoneBoardRobot {
    private static final IStackFilter TNT_FILTER = new ArrayStackFilter(new ItemStack(Blocks.field_150335_W));
    private BlockIndex target = null;
    private int flyingHeight = 20;

    public BoardRobotBomber(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotBomberNBT.instance;
    }

    @Override
    public final void update() {
        boolean containItems = false;
        for (int i = 0; i < this.robot.func_70302_i_(); ++i) {
            if (this.robot.func_70301_a(i) == null) continue;
            containItems = true;
        }
        if (!containItems) {
            this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, TNT_FILTER, null));
        } else {
            this.startDelegateAI(new AIRobotSearchRandomGroundBlock(this.robot, 100, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return y < world.func_72940_L() - BoardRobotBomber.this.flyingHeight && !world.func_147437_c(x, y, z);
                }
            }, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        ITransactor t;
        ItemStack stack;
        if (ai instanceof AIRobotGotoStationToLoad) {
            this.startDelegateAI(new AIRobotLoad(this.robot, TNT_FILTER));
        } else if (ai instanceof AIRobotSearchRandomGroundBlock) {
            AIRobotSearchRandomGroundBlock aiFind = (AIRobotSearchRandomGroundBlock)ai;
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, aiFind.blockFound.x, aiFind.blockFound.y + this.flyingHeight, aiFind.blockFound.z));
        } else if (ai instanceof AIRobotGotoBlock && (stack = (t = Transactor.getTransactorFor((Object)this.robot)).remove(TNT_FILTER, ForgeDirection.UNKNOWN, true)) != null && stack.field_77994_a > 0) {
            EntityTNTPrimed tnt = new EntityTNTPrimed(this.robot.field_70170_p, this.robot.field_70165_t + 0.25, this.robot.field_70163_u - 1.0, this.robot.field_70161_v + 0.25, (EntityLivingBase)this.robot);
            tnt.field_70516_a = 37;
            this.robot.field_70170_p.func_72838_d((Entity)tnt);
            this.robot.field_70170_p.func_72956_a((Entity)tnt, "game.tnt.primed", 1.0f, 1.0f);
        }
    }
}

