/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DockingStation
implements IDockingStation {
    public ForgeDirection side;
    public World world;
    private long robotTakingId = Long.MAX_VALUE;
    private EntityRobotBase robotTaking;
    private boolean linkIsMain = false;
    private BlockIndex index;
    private TileGenericPipe pipe;

    public DockingStation(BlockIndex iIndex, ForgeDirection iSide) {
        this.index = iIndex;
        this.side = iSide;
    }

    public DockingStation(TileGenericPipe iPipe, ForgeDirection iSide) {
        this.index = new BlockIndex(iPipe);
        this.pipe = iPipe;
        this.side = iSide;
        this.world = iPipe.getWorld();
    }

    public DockingStation() {
    }

    public boolean isMainStation() {
        return this.linkIsMain;
    }

    public TileGenericPipe getPipe() {
        if (this.pipe == null) {
            this.pipe = (TileGenericPipe)this.world.func_147438_o(this.index.x, this.index.y, this.index.z);
        }
        if (this.pipe == null || this.pipe.func_145837_r()) {
            RobotRegistry.getRegistry(this.world).removeStation(this);
            this.pipe = null;
        }
        return this.pipe;
    }

    @Override
    public int x() {
        return this.index.x;
    }

    @Override
    public int y() {
        return this.index.y;
    }

    @Override
    public int z() {
        return this.index.z;
    }

    @Override
    public ForgeDirection side() {
        return this.side;
    }

    @Override
    public EntityRobotBase robotTaking() {
        if (this.robotTakingId == Long.MAX_VALUE) {
            return null;
        }
        if (this.robotTaking == null) {
            this.robotTaking = RobotRegistry.getRegistry(this.world).getLoadedRobot(this.robotTakingId);
        }
        return this.robotTaking;
    }

    public void invalidateRobotTakingEntity() {
        this.robotTaking = null;
    }

    @Override
    public long linkedId() {
        return this.robotTakingId;
    }

    public boolean takeAsMain(EntityRobotBase robot) {
        if (this.robotTakingId == Long.MAX_VALUE) {
            this.linkIsMain = true;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            this.getPipe().scheduleRenderUpdate();
            RobotRegistry.getRegistry(this.world).func_76185_a();
            ((EntityRobot)robot).setMainStation(this);
            RobotRegistry.getRegistry(this.world).take(this, robot.getRobotId());
            return true;
        }
        return this.robotTakingId == robot.getRobotId();
    }

    @Override
    public boolean take(EntityRobotBase robot) {
        if (this.robotTaking == null) {
            this.linkIsMain = false;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            this.getPipe().scheduleRenderUpdate();
            RobotRegistry.getRegistry(this.world).func_76185_a();
            RobotRegistry.getRegistry(this.world).take(this, robot.getRobotId());
            return true;
        }
        return robot.getRobotId() == this.robotTakingId;
    }

    public void release(EntityRobotBase robot) {
        if (this.robotTaking == robot && !this.linkIsMain) {
            this.unsafeRelease(robot);
            RobotRegistry.getRegistry(this.world).func_76185_a();
            RobotRegistry.getRegistry(this.world).release(this, robot.getRobotId());
        }
    }

    public void unsafeRelease(EntityRobotBase robot) {
        if (this.robotTaking == robot) {
            this.linkIsMain = false;
            this.robotTaking = null;
            this.robotTakingId = Long.MAX_VALUE;
            this.getPipe().scheduleRenderUpdate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.func_74782_a("index", (NBTBase)indexNBT);
        nbt.func_74774_a("side", (byte)this.side.ordinal());
        nbt.func_74757_a("isMain", this.linkIsMain);
        nbt.func_74772_a("robotId", this.robotTakingId);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.index = new BlockIndex(nbt.func_74775_l("index"));
        this.side = ForgeDirection.values()[nbt.func_74771_c("side")];
        this.linkIsMain = nbt.func_74767_n("isMain");
        this.robotTakingId = nbt.func_74763_f("robotId");
    }

    @Override
    public boolean isTaken() {
        return this.robotTakingId != Long.MAX_VALUE;
    }

    @Override
    public long robotIdTaking() {
        return this.robotTakingId;
    }

    @Override
    public BlockIndex index() {
        return this.index;
    }

    public String toString() {
        return "{" + this.index.x + ", " + this.index.y + ", " + this.index.z + ", " + this.side + " :" + this.robotTakingId + "}";
    }

    public boolean linkIsDocked() {
        if (this.isTaken()) {
            return this.robotTaking().getDockingStation() == this;
        }
        return false;
    }

    public boolean canRelease() {
        return !this.isMainStation() && !this.linkIsDocked();
    }
}

