/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotStraightMoveTo;
import buildcraft.core.robots.DockingStation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotGotoStation
extends AIRobot {
    private BlockIndex stationIndex;
    private ForgeDirection stationSide;
    private boolean docked = false;

    public AIRobotGotoStation(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStation(EntityRobotBase iRobot, IDockingStation station) {
        super(iRobot);
        this.stationIndex = station.index();
        this.stationSide = station.side();
    }

    @Override
    public void start() {
        DockingStation station = (DockingStation)this.robot.getRegistry().getStation(this.stationIndex.x, this.stationIndex.y, this.stationIndex.z, this.stationSide);
        if (station == null || station == this.robot.getDockingStation()) {
            this.terminate();
        } else if (station.take(this.robot)) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, station.x() + station.side().offsetX, station.y() + station.side().offsetY, station.z() + station.side().offsetZ));
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        DockingStation station = (DockingStation)this.robot.getRegistry().getStation(this.stationIndex.x, this.stationIndex.y, this.stationIndex.z, this.stationSide);
        if (station == null) {
            this.terminate();
        } else if (ai instanceof AIRobotGotoBlock) {
            this.startDelegateAI(new AIRobotStraightMoveTo(this.robot, (float)this.stationIndex.x + 0.5f + (float)this.stationSide.offsetX * 0.5f, (float)this.stationIndex.y + 0.5f + (float)this.stationSide.offsetY * 0.5f, (float)this.stationIndex.z + 0.5f + (float)this.stationSide.offsetZ * 0.5f));
        } else {
            this.docked = true;
            this.robot.dock(station);
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.docked;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.stationIndex.writeTo(indexNBT);
        nbt.func_74782_a("stationIndex", (NBTBase)indexNBT);
        nbt.func_74774_a("stationSide", (byte)this.stationSide.ordinal());
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        this.stationIndex = new BlockIndex(nbt.func_74775_l("stationIndex"));
        this.stationSide = ForgeDirection.values()[nbt.func_74771_c("stationSide")];
    }
}

