/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotCraftGeneric;
import buildcraft.core.robots.AIRobotGotoStation;
import buildcraft.core.robots.AIRobotGotoStationAndLoad;
import buildcraft.core.robots.AIRobotGotoStationAndUnload;
import buildcraft.core.robots.AIRobotSearchStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IStationFilter;
import buildcraft.core.robots.ResourceIdBlock;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionStationAllowCraft;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotCraftFurnace
extends AIRobotCraftGeneric {
    private static final int INPUT_SLOT = 0;
    private static final int FUEL_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private ItemStack input;
    private DockingStation stationFound;
    private TileEntityFurnace furnace;
    private boolean craftStarted = false;
    private int waitedTime = 0;
    private ItemStack expectedOutput;

    public AIRobotCraftFurnace(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotCraftFurnace(EntityRobotBase iRobot, ItemStack iInput, ItemStack iOutput) {
        super(iRobot);
        this.input = iInput;
        this.expectedOutput = iOutput;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchStation(this.robot, new StationFurnaceFilter(), this.robot.getZoneToWork()));
    }

    @Override
    public void update() {
        if (this.furnace != null) {
            if (!this.craftStarted) {
                IInvSlot s;
                if (this.furnace.func_70301_a(1) == null && InvUtils.getItem(this.robot, new FuelFilter()) == null) {
                    this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new FuelFilter(), this.robot.getZoneToWork()));
                    return;
                }
                if (InvUtils.getItem(this.robot, new ArrayStackFilter(this.input)) == null) {
                    this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new ArrayStackFilter(this.input), this.robot.getZoneToWork()));
                    return;
                }
                if (this.robot.getDockingStation() != this.stationFound) {
                    this.startDelegateAI(new AIRobotGotoStation(this.robot, this.stationFound));
                    return;
                }
                if (this.furnace.func_70301_a(1) == null) {
                    s = InvUtils.getItem(this.robot, new FuelFilter());
                    this.furnace.func_70299_a(1, s.decreaseStackInSlot(1));
                }
                if (this.furnace.func_70301_a(0) == null) {
                    s = InvUtils.getItem(this.robot, new ArrayStackFilter(this.input));
                    this.furnace.func_70299_a(0, s.decreaseStackInSlot(1));
                }
                this.craftStarted = true;
                if (!this.robot.hasFreeSlot()) {
                    this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot));
                }
            } else {
                ++this.waitedTime;
                if (this.waitedTime > 40 && this.furnace.func_70301_a(2) != null) {
                    ItemStack stack;
                    if (this.robot.hasFreeSlot() && (stack = this.furnace.func_70298_a(2, 1)) != null) {
                        ITransactor transactor = Transactor.getTransactorFor((Object)this.robot);
                        transactor.add(stack, ForgeDirection.UNKNOWN, true);
                        this.crafted = true;
                    }
                    this.terminate();
                } else if (this.waitedTime > 1200) {
                    this.terminate();
                }
            }
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStation) {
            if (!ai.success()) {
                this.crafted = false;
                this.terminate();
            } else {
                this.stationFound = ((AIRobotSearchStation)ai).targetStation;
                this.furnace = this.getUsableFurnace(new BlockIndex(this.stationFound.x(), this.stationFound.y(), this.stationFound.z()));
                if (this.furnace == null) {
                    this.terminate();
                    return;
                }
                BlockIndex index = new BlockIndex((TileEntity)this.furnace);
                if (!this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(index), this.robot)) {
                    this.terminate();
                }
                if (!this.stationFound.take(this.robot)) {
                    this.terminate();
                }
            }
        } else if (ai instanceof AIRobotGotoStationAndLoad) {
            // empty if block
        }
    }

    private TileEntityFurnace getUsableFurnace(BlockIndex b) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityFurnace f;
            Block nearbyBlock;
            BlockIndex index = new BlockIndex(b.x + dir.offsetX, b.y + dir.offsetY, b.z + dir.offsetZ);
            if (this.robot.getRegistry().isTaken(new ResourceIdBlock(index)) || !((nearbyBlock = this.robot.field_70170_p.func_147439_a(index.x, index.y, index.z)) instanceof BlockFurnace) || (f = (TileEntityFurnace)this.robot.field_70170_p.func_147438_o(index.x, index.y, index.z)).func_70301_a(0) != null && !StackHelper.isMatchingItem(this.input, f.func_70301_a(0))) continue;
            return f;
        }
        return null;
    }

    private class FuelFilter
    implements IStackFilter {
        private FuelFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && !StackHelper.isMatchingItem(stack, AIRobotCraftFurnace.this.input);
        }
    }

    private class StationFurnaceFilter
    implements IStationFilter {
        private StationFurnaceFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithItem(station, new ArrayStackFilter(AIRobotCraftFurnace.this.expectedOutput), ActionStationAllowCraft.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (AIRobotCraftFurnace.this.getUsableFurnace(new BlockIndex(station.x(), station.y(), station.z())) == null) continue;
                return true;
            }
            return false;
        }
    }
}

