/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.BuildCraftSilicon;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.ItemRobot;
import buildcraft.core.render.RenderLaser;
import buildcraft.core.render.RenderUtils;
import buildcraft.core.robots.EntityRobot;
import java.util.Date;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderRobot
extends Render
implements IItemRenderer {
    private static final ResourceLocation overlay = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_overlay.png");
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private ModelBase model = new ModelBase(){};
    private ModelRenderer box;

    public RenderRobot() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
        this.box = new ModelRenderer(this.model, 0, 0);
        this.box.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        this.box.field_78800_c = 0.0f;
        this.box.field_78797_d = 0.0f;
        this.box.field_78798_e = 0.0f;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        this.doRender((EntityRobot)entity, x, y, z);
    }

    private void doRender(EntityRobot robot, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (robot.func_70301_a(0) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)-0.125f);
            this.doRenderItem(robot.func_70301_a(0));
            GL11.glPopMatrix();
        }
        if (robot.func_70301_a(1) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.125f, (float)0.0f, (float)-0.125f);
            this.doRenderItem(robot.func_70301_a(1));
            GL11.glPopMatrix();
        }
        if (robot.func_70301_a(2) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.125f, (float)0.0f, (float)0.125f);
            this.doRenderItem(robot.func_70301_a(2));
            GL11.glPopMatrix();
        }
        if (robot.func_70301_a(3) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)0.125f);
            this.doRenderItem(robot.func_70301_a(3));
            GL11.glPopMatrix();
        }
        if (robot.itemInUse != null) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)((float)((double)(-robot.itemAngle1) / (Math.PI * 2) * 360.0) + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)((double)robot.itemAngle2 / (Math.PI * 2) * 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
            if (robot.itemActive) {
                long newDate = new Date().getTime();
                robot.itemActiveStage = (robot.itemActiveStage + (float)((newDate - robot.lastUpdateTime) / 10L)) % 45.0f;
                GL11.glRotatef((float)robot.itemActiveStage, (float)0.0f, (float)0.0f, (float)1.0f);
                robot.lastUpdateTime = newDate;
            }
            GL11.glTranslatef((float)-0.4f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            ItemStack itemstack1 = robot.itemInUse;
            if (itemstack1.func_77973_b().func_77623_v()) {
                for (int k = 0; k < itemstack1.func_77973_b().getRenderPasses(itemstack1.func_77960_j()); ++k) {
                    RenderUtils.setGLColorFromInt(itemstack1.func_77973_b().func_82790_a(itemstack1, k));
                    this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)robot, itemstack1, k);
                }
            } else {
                RenderUtils.setGLColorFromInt(itemstack1.func_77973_b().func_82790_a(itemstack1, 0));
                this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)robot, itemstack1, 0);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (robot.laser.isVisible) {
            robot.laser.head.x = robot.field_70165_t;
            robot.laser.head.y = robot.field_70163_u;
            robot.laser.head.z = robot.field_70161_v;
            RenderLaser.doRenderLaser(this.field_76990_c.field_78724_e, robot.laser, EntityLaser.LASER_TEXTURES[1]);
        }
        if (robot.getTexture() != null) {
            this.field_76990_c.field_78724_e.func_110577_a(robot.getTexture());
            this.doRenderRobot(0.0625f, this.field_76990_c.field_78724_e);
        }
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return ((EntityRobot)entity).getTexture();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (RenderManager.field_78727_a == null || RenderManager.field_78727_a.field_78724_e == null) {
            return;
        }
        GL11.glPushMatrix();
        if (item.func_77973_b() == BuildCraftSilicon.robotItem) {
            ItemRobot robot = (ItemRobot)item.func_77973_b();
            RenderManager.field_78727_a.field_78724_e.func_110577_a(robot.getTextureRobot(item));
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslated((double)0.0, (double)1.0, (double)0.7);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.6, (double)0.6, (double)0.6);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
        }
        this.doRenderRobot(0.0625f, RenderManager.field_78727_a.field_78724_e);
        GL11.glPopMatrix();
    }

    private void doRenderItem(ItemStack stack) {
        float renderScale = 0.5f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.28f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(stack);
        this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    private void doRenderRobot(float factor, TextureManager texManager) {
        this.box.func_78785_a(factor);
        GL11.glPushMatrix();
        texManager.func_110577_a(overlay);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
        this.box.func_78785_a(factor);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

