/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.ItemList;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.ContainerList;
import buildcraft.core.gui.GuiAdvancedInterface;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiList
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/list.png");
    private GuiTextField textField;
    private EntityPlayer player;

    public GuiList(EntityPlayer iPlayer) {
        super(new ContainerList(iPlayer), (IInventory)iPlayer.field_71071_by, TEXTURE_BASE);
        this.field_146999_f = 176;
        this.field_147000_g = 241;
        for (int sy = 0; sy < 6; ++sy) {
            this.slots.add(new MainSlot(this, 44, 31 + sy * 18, sy));
            for (int sx = 1; sx < 7; ++sx) {
                this.slots.add(new SecondarySlot(this, 44 + sx * 18, 31 + sy * 18, sy, sx));
            }
            this.slots.add(new Button(this, 8, 31 + sy * 18, sy, 0, "gui.list.metadata"));
            this.slots.add(new Button(this, 26, 31 + sy * 18, sy, 1, "gui.list.oredict"));
        }
        this.player = iPlayer;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.textField = new GuiTextField(this.field_146289_q, 10, 10, 156, 12);
        this.textField.func_146203_f(32);
        this.textField.func_146180_a(ItemList.getLabel(this.player.func_71045_bC()));
        this.textField.func_146195_b(false);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        int i;
        super.func_146976_a(f, x, y);
        ContainerList container = (ContainerList)this.getContainer();
        this.bindTexture(TEXTURE_BASE);
        for (i = 0; i < 6; ++i) {
            if (container.lines[i].subitemsWildcard) {
                this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 30 + 18 * i, 194, 18, 18, 18);
            } else {
                this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 30 + 18 * i, 194, 0, 18, 18);
            }
            if (container.lines[i].isOre) {
                if (container.lines[i].oreWildcard) {
                    this.func_73729_b(this.field_147003_i + 25, this.field_147009_r + 30 + 18 * i, 176, 18, 18, 18);
                } else {
                    this.func_73729_b(this.field_147003_i + 25, this.field_147009_r + 30 + 18 * i, 176, 0, 18, 18);
                }
            }
            if (!container.lines[i].subitemsWildcard && !container.lines[i].oreWildcard) continue;
            for (int j = 0; j < 6; ++j) {
                this.func_73729_b(this.field_147003_i + 62 + 18 * j, this.field_147009_r + 31 + 18 * i, 195, 37, 16, 16);
            }
        }
        this.drawBackgroundSlots();
        this.bindTexture(TEXTURE_BASE);
        for (i = 0; i < 6; ++i) {
            if (container.lines[i].getStack(7) == null) continue;
            this.func_73729_b(this.field_147003_i + 152, this.field_147009_r + 31 + 18 * i, 177, 37, 16, 16);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.textField.func_146194_f();
        this.drawTooltipForSlotAt(par1, par2);
    }

    private boolean isCarryingList() {
        ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        return stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemList;
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        if (this.isCarryingList()) {
            return;
        }
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        ContainerList container = (ContainerList)this.getContainer();
        if (slot instanceof MainSlot) {
            container.setStack(((MainSlot)slot).lineIndex, 0, this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
        } else if (slot instanceof SecondarySlot) {
            container.setStack(((SecondarySlot)slot).lineIndex, ((SecondarySlot)slot).slotIndex, this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
        } else if (slot instanceof Button) {
            Button button = (Button)slot;
            container.switchButton(button.line, button.kind);
        }
        this.textField.func_146192_a(x - this.field_147003_i, y - this.field_147009_r, b);
    }

    protected void func_73869_a(char c, int i) {
        if (this.textField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.textField.func_146195_b(false);
            } else {
                this.textField.func_146201_a(c, i);
                ((ContainerList)this.container).setLabel(this.textField.func_146179_b());
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    private static class Button
    extends AdvancedSlot {
        public int line;
        public int kind;
        private String desc;

        public Button(GuiAdvancedInterface gui, int x, int y, int iLine, int iKind, String iDesc) {
            super(gui, x, y);
            this.line = iLine;
            this.kind = iKind;
            this.desc = iDesc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    private static class SecondarySlot
    extends AdvancedSlot {
        public int lineIndex;
        public int slotIndex;

        public SecondarySlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex, int iSlotIndex) {
            super(gui, x, y);
            this.lineIndex = iLineIndex;
            this.slotIndex = iSlotIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerList container = (ContainerList)this.gui.getContainer();
            if (this.slotIndex == 6 && container.lines[this.lineIndex].getStack(7) != null) {
                return null;
            }
            if (container.lines[this.lineIndex].getStack(this.slotIndex) != null) {
                return container.lines[this.lineIndex].getStack(this.slotIndex);
            }
            return null;
        }
    }

    private static class MainSlot
    extends AdvancedSlot {
        public int lineIndex;

        public MainSlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex) {
            super(gui, x, y);
            this.lineIndex = iLineIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerList container = (ContainerList)this.gui.getContainer();
            if (container.lines[this.lineIndex].getStack(0) != null) {
                return container.lines[this.lineIndex].getStack(0);
            }
            return null;
        }
    }
}

