/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.utils.NBTUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemList
extends ItemBuildCraft {
    private IIcon baseIcon;
    private IIcon writtenIcon;

    public ItemList() {
        this.func_77625_d(1);
    }

    public IIcon func_77650_f(ItemStack stack) {
        this.field_77791_bV = NBTUtils.getItemData(stack).func_74764_b("written") ? this.writtenIcon : this.baseIcon;
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.baseIcon = par1IconRegister.func_94245_a("buildcraft:list");
        this.writtenIcon = par1IconRegister.func_94245_a("buildcraft:list_used");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            player.openGui((Object)BuildCraftCore.instance, 17, world, 0, 0, 0);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        if (nbt.func_74764_b("label")) {
            list.add(nbt.func_74779_i("label"));
        }
    }

    public static void saveLine(ItemStack stack, StackLine line, int index) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        nbt.func_74757_a("written", true);
        NBTTagCompound lineNBT = new NBTTagCompound();
        line.writeToNBT(lineNBT);
        nbt.func_74782_a("line[" + index + "]", (NBTBase)lineNBT);
    }

    public static void saveLabel(ItemStack stack, String text) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        nbt.func_74778_a("label", text);
    }

    public static StackLine[] getLines(ItemStack stack) {
        StackLine[] result = new StackLine[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = new StackLine();
        }
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        if (nbt.func_74764_b("written")) {
            for (int i = 0; i < 6; ++i) {
                result[i].readFromNBT(nbt.func_74775_l("line[" + i + "]"));
            }
        }
        return result;
    }

    public static String getLabel(ItemStack stack) {
        return NBTUtils.getItemData(stack).func_74779_i("label");
    }

    public static boolean matches(ItemStack stackList, ItemStack item) {
        StackLine[] lines;
        for (StackLine line : lines = ItemList.getLines(stackList)) {
            if (line == null || !line.matches(item)) continue;
            return true;
        }
        return false;
    }

    public static class StackLine {
        public boolean oreWildcard = false;
        public boolean subitemsWildcard = false;
        public boolean isOre;
        private ItemStack[] stacks = new ItemStack[7];
        private ArrayList<ItemStack> ores = new ArrayList();
        private ArrayList<ItemStack> relatedItems = new ArrayList();

        public ItemStack getStack(int index) {
            if (index == 0 || !this.oreWildcard && !this.subitemsWildcard) {
                if (index < 7) {
                    return this.stacks[index];
                }
                return null;
            }
            if (this.oreWildcard) {
                if (this.ores.size() >= index) {
                    return this.ores.get(index - 1);
                }
                return null;
            }
            if (this.relatedItems.size() >= index) {
                return this.relatedItems.get(index - 1);
            }
            return null;
        }

        public void setStack(int slot, ItemStack stack) {
            this.stacks[slot] = stack;
            if (stack != null) {
                this.stacks[slot] = this.stacks[slot].func_77946_l();
                this.stacks[slot].field_77994_a = 1;
            }
            if (slot == 0) {
                this.relatedItems.clear();
                this.ores.clear();
                if (stack == null) {
                    this.isOre = false;
                } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    this.setClientPreviewLists();
                } else {
                    this.isOre = OreDictionary.getOreIDs((ItemStack)this.stacks[0]).length > 0;
                }
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74757_a("ore", this.oreWildcard);
            nbt.func_74757_a("sub", this.subitemsWildcard);
            for (int i = 0; i < 7; ++i) {
                if (this.stacks[i] == null) continue;
                NBTTagCompound stackNBT = new NBTTagCompound();
                this.stacks[i].func_77955_b(stackNBT);
                nbt.func_74782_a("stacks[" + i + "]", (NBTBase)stackNBT);
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.oreWildcard = nbt.func_74767_n("ore");
            this.subitemsWildcard = nbt.func_74767_n("sub");
            for (int i = 0; i < 7; ++i) {
                if (!nbt.func_74764_b("stacks[" + i + "]")) continue;
                this.setStack(i, ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stacks[" + i + "]")));
            }
        }

        private boolean classMatch(Item base, Item matched) {
            if (base.getClass() == Item.class) {
                return base == matched;
            }
            if (base.getClass() == matched.getClass()) {
                if (base instanceof ItemBlock) {
                    Block baseBlock = ((ItemBlock)base).field_150939_a;
                    Block matchedBlock = ((ItemBlock)matched).field_150939_a;
                    if (baseBlock.getClass() == Block.class) {
                        return baseBlock == matchedBlock;
                    }
                    return baseBlock.equals(matchedBlock);
                }
                return true;
            }
            return false;
        }

        private boolean oreMatch(ItemStack base, ItemStack matched) {
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)base);
            int[] matchesIds = OreDictionary.getOreIDs((ItemStack)matched);
            for (int stackId : oreIds) {
                for (int matchId : matchesIds) {
                    if (stackId != matchId) continue;
                    return true;
                }
            }
            return false;
        }

        private void setClientPreviewLists() {
            Item baseItem = this.stacks[0].func_77973_b();
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)this.stacks[0]);
            this.isOre = oreIds.length > 0;
            for (Object o : Item.field_150901_e) {
                Item item = (Item)o;
                boolean classMatch = this.classMatch(baseItem, item);
                LinkedList list = new LinkedList();
                for (CreativeTabs tab : item.getCreativeTabs()) {
                    item.func_150895_a(item, tab, list);
                }
                if (list.size() <= 0) continue;
                for (Object ol : list) {
                    ItemStack stack = (ItemStack)ol;
                    if (classMatch && this.relatedItems.size() <= 7 && !StackHelper.isMatchingItemOrList(this.stacks[0], stack)) {
                        this.relatedItems.add(stack);
                    }
                    if (!this.isOre || this.ores.size() > 7 || StackHelper.isMatchingItemOrList(this.stacks[0], stack) || !this.oreMatch(this.stacks[0], stack)) continue;
                    this.ores.add(stack);
                }
            }
        }

        public boolean matches(ItemStack item) {
            if (this.subitemsWildcard) {
                if (this.stacks[0] == null) {
                    return false;
                }
                return this.classMatch(this.stacks[0].func_77973_b(), item.func_77973_b());
            }
            if (this.oreWildcard) {
                if (this.stacks[0] == null) {
                    return false;
                }
                return this.oreMatch(this.stacks[0], item);
            }
            for (ItemStack stack : this.stacks) {
                if (stack == null || !StackHelper.isMatchingItemOrList(stack, item)) continue;
                return true;
            }
            return false;
        }
    }
}

