/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class BCDynamicTexture {
    public int width;
    public int height;
    public int[] colorMap;
    @SideOnly(value=Side.CLIENT)
    private DynamicTexture dynamicTexture;

    public BCDynamicTexture(int iWidth, int iHeight) {
        this.width = iWidth;
        this.height = iHeight;
        this.colorMap = new int[iWidth * iHeight];
    }

    @SideOnly(value=Side.CLIENT)
    public void createDynamicTexture() {
        this.dynamicTexture = new DynamicTexture(this.width, this.height);
        this.colorMap = this.dynamicTexture.func_110565_c();
    }

    public void setColor(int index, double r, double g, double b, double a) {
        int i = (int)(a * 255.0);
        int j = (int)(r * 255.0);
        int k = (int)(g * 255.0);
        int l = (int)(b * 255.0);
        this.colorMap[index] = i << 24 | j << 16 | k << 8 | l;
    }

    public void setColor(int x, int y, double r, double g, double b, double a) {
        int i = (int)(a * 255.0);
        int j = (int)(r * 255.0);
        int k = (int)(g * 255.0);
        int l = (int)(b * 255.0);
        this.colorMap[x + y * this.width] = i << 24 | j << 16 | k << 8 | l;
    }

    public void setColor(int x, int y, int color) {
        this.colorMap[x + y * this.height] = 0xFF000000 | color;
    }

    public void setColor(int x, int y, int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        this.colorMap[x + y * this.height] = a << 24 | color;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMap(int screenX, int screenY, float zLevel) {
        this.drawMap(screenX, screenY, zLevel, 0, 0, this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateDynamicTexture() {
        this.dynamicTexture.func_110564_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMap(int screenX, int screenY, float zLevel, int clipX, int clipY, int clipWidth, int clipHeight) {
        this.dynamicTexture.func_110564_a();
        float f = 1.0f / (float)this.width;
        float f1 = 1.0f / (float)this.height;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(screenX + 0), (double)(screenY + clipHeight), (double)zLevel, (double)((float)(clipX + 0) * f), (double)((float)(clipY + clipHeight) * f1));
        tessellator.func_78374_a((double)(screenX + clipWidth), (double)(screenY + clipHeight), (double)zLevel, (double)((float)(clipX + clipWidth) * f), (double)((float)(clipY + clipHeight) * f1));
        tessellator.func_78374_a((double)(screenX + clipWidth), (double)(screenY + 0), (double)zLevel, (double)((float)(clipX + clipWidth) * f), (double)((float)(clipY + 0) * f1));
        tessellator.func_78374_a((double)(screenX + 0), (double)(screenY + 0), (double)zLevel, (double)((float)(clipX + 0) * f), (double)((float)(clipY + 0) * f1));
        tessellator.func_78381_a();
    }
}

