/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.ZonePlan;
import buildcraft.core.inventory.SimpleInventory;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class TileZonePlan
extends TileBuildCraft
implements IInventory {
    public static final int RESOLUTION = 2048;
    public static final int CRAFT_TIME = 120;
    private static int RESOLUTION_CHUNKS = 128;
    public int chunkStartX;
    public int chunkStartZ;
    public byte[] colors = new byte[0x400000];
    public short progress = 0;
    private boolean scan = false;
    private int chunkIt = 0;
    private ZonePlan[] selectedAreas = new ZonePlan[16];
    private int currentSelectedArea = 0;
    private SimpleInventory inv = new SimpleInventory(2, "inv", 64);
    private SafeTimeTracker zonePlannerScanning = new SafeTimeTracker(5L);

    @Override
    public void initialize() {
        super.initialize();
        this.chunkStartX = (this.field_145851_c >> 4) - RESOLUTION_CHUNKS / 2;
        this.chunkStartZ = (this.field_145849_e >> 4) - RESOLUTION_CHUNKS / 2;
        if (!this.scan) {
            this.chunkIt = 0;
            this.scan = true;
        }
    }

    private int[] getCoords() {
        int chunkCenterX = this.field_145851_c >> 4;
        int chunkCenterZ = this.field_145849_e >> 4;
        if (this.chunkIt == 0) {
            return new int[]{chunkCenterX, chunkCenterZ};
        }
        int left = this.chunkIt;
        for (int radius = 1; radius < RESOLUTION_CHUNKS / 2; ++radius) {
            int lineLength = radius * 2;
            int perimeter = lineLength * 4;
            if (left <= perimeter) {
                int chunkX = 0;
                int chunkZ = 0;
                int remained = (left - 1) % lineLength;
                if ((left - 1) / lineLength == 0) {
                    chunkX = chunkCenterX + radius;
                    chunkZ = chunkCenterZ - lineLength / 2 + remained;
                } else if ((left - 1) / lineLength == 1) {
                    chunkX = chunkCenterX - radius;
                    chunkZ = chunkCenterZ - lineLength / 2 + remained + 1;
                } else if ((left - 1) / lineLength == 2) {
                    chunkX = chunkCenterX - lineLength / 2 + remained + 1;
                    chunkZ = chunkCenterZ + radius;
                } else {
                    chunkX = chunkCenterX - lineLength / 2 + remained;
                    chunkZ = chunkCenterZ - radius;
                }
                return new int[]{chunkX, chunkZ};
            }
            left -= perimeter;
        }
        return new int[]{chunkCenterX, chunkCenterZ};
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.scan && this.zonePlannerScanning.markTimeIfDelay(this.field_145850_b)) {
            int[] coords = this.getCoords();
            Chunk chunk = this.field_145850_b.func_72964_e(coords[0], coords[1]);
            this.loadChunk(chunk);
            if (this.chunkIt > RESOLUTION_CHUNKS * RESOLUTION_CHUNKS) {
                this.scan = false;
                this.chunkIt = 0;
            } else {
                ++this.chunkIt;
            }
        }
        if (this.inv.func_70301_a(0) != null && this.inv.func_70301_a(1) == null && this.inv.func_70301_a(0).func_77973_b() instanceof ItemMapLocation) {
            if (this.progress < 120) {
                this.progress = (short)(this.progress + 1);
                if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                    this.sendNetworkUpdate();
                }
            } else {
                ItemStack stack = this.inv.func_70298_a(0, 1);
                if (this.selectedAreas[this.currentSelectedArea] != null) {
                    ItemMapLocation.setZone(stack, this.selectedAreas[this.currentSelectedArea]);
                }
                this.inv.func_70299_a(1, stack);
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.sendNetworkUpdate();
        }
    }

    private void loadChunk(Chunk chunk) {
        for (int cx = 0; cx < 16; ++cx) {
            for (int cz = 0; cz < 16; ++cz) {
                int color;
                int x = (chunk.field_76635_g << 4) + cx;
                int z = (chunk.field_76647_h << 4) + cz;
                int y = this.func_145831_w().func_72976_f(x, z);
                while ((color = chunk.func_150810_a((int)cx, (int)y, (int)cz).func_149728_f((int)0).field_76290_q) == MapColor.field_151660_b.field_76290_q && --y >= 0) {
                }
                int ix = x - this.chunkStartX * 16;
                int iz = z - this.chunkStartZ * 16;
                this.colors[ix + iz * 2048] = (byte)color;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("scan", this.scan);
        nbt.func_74768_a("chunkIt", this.chunkIt);
        nbt.func_74773_a("colors", this.colors);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.func_74782_a("inv", (NBTBase)invNBT);
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (this.selectedAreas[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            this.selectedAreas[i].writeToNBT(subNBT);
            nbt.func_74782_a("selectedArea[" + i + "]", (NBTBase)subNBT);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.scan = nbt.func_74767_n("scan");
        this.chunkIt = nbt.func_74762_e("chunkIt");
        this.colors = nbt.func_74770_j("colors");
        if (this.colors.length != 0x400000 || this.chunkIt >= RESOLUTION_CHUNKS * RESOLUTION_CHUNKS) {
            this.colors = new byte[0x400000];
            this.scan = true;
            this.chunkIt = 0;
        }
        this.inv.readFromNBT(nbt.func_74775_l("inv"));
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (!nbt.func_74764_b("selectedArea[" + i + "]")) continue;
            this.selectedAreas[i] = new ZonePlan();
            this.selectedAreas[i].readFromNBT(nbt.func_74775_l("selectedArea[" + i + "]"));
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort((int)this.progress);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.progress = stream.readShort();
    }

    public ZonePlan selectArea(int index) {
        if (this.selectedAreas[index] == null) {
            this.selectedAreas[index] = new ZonePlan();
        }
        this.currentSelectedArea = index;
        return this.selectedAreas[index];
    }

    public void setArea(int index, ZonePlan area) {
        this.selectedAreas[index] = area;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inv.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inv.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inv.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inv.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inv.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inv.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inv.func_94041_b(i, itemstack);
    }
}

