/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.commander;

import buildcraft.BuildCraftCore;
import buildcraft.commander.GuiZonePlan;
import buildcraft.commander.TileZonePlan;
import buildcraft.core.BCDynamicTexture;
import buildcraft.core.ZonePlan;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.SlotOutput;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerZonePlan
extends BuildCraftContainer
implements ICommandReceiver {
    public BCDynamicTexture mapTexture;
    public ZonePlan currentAreaSelection;
    public GuiZonePlan gui;
    private TileZonePlan map;

    public ContainerZonePlan(IInventory playerInventory, TileZonePlan iZonePlan) {
        super(0);
        this.map = iZonePlan;
        this.func_75146_a(new Slot((IInventory)iZonePlan, 0, 233, 20));
        this.func_75146_a(new SlotOutput(iZonePlan, 1, 233, 68));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot(playerInventory, k1 + l * 9 + 9, 88 + k1 * 18, 138 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot(playerInventory, i1, 88 + i1 * 18, 196));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void loadArea(final int index) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "loadArea", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(index);
            }
        }));
    }

    public void saveArea(final int index) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "saveArea", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(index);
                ContainerZonePlan.this.currentAreaSelection.writeData(data);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("areaLoaded".equals(command)) {
                this.currentAreaSelection = new ZonePlan();
                this.currentAreaSelection.readData(stream);
                this.gui.refreshSelectedArea();
            } else if ("receiveImage".equals(command)) {
                int size = stream.readUnsignedMedium();
                for (int i = 0; i < size; ++i) {
                    this.mapTexture.colorMap[i] = 0xFF000000 | MapColor.field_76281_a[stream.readUnsignedByte()].field_76291_p;
                }
            }
        } else if (side.isServer()) {
            if ("loadArea".equals(command)) {
                final short index = stream.readUnsignedByte();
                BuildCraftCore.instance.sendToPlayer((EntityPlayer)sender, new PacketCommand(this, "areaLoaded", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        ContainerZonePlan.this.map.selectArea(index).writeData(data);
                    }
                }));
            } else if ("saveArea".equals(command)) {
                short index = stream.readUnsignedByte();
                ZonePlan plan = new ZonePlan();
                plan.readData(stream);
                this.map.setArea(index, plan);
            } else if ("computeMap".equals(command)) {
                this.computeMap(stream.readInt(), stream.readInt(), stream.readUnsignedShort(), stream.readUnsignedShort(), stream.readUnsignedByte(), (EntityPlayer)sender);
            }
        }
    }

    private void computeMap(int cx, int cz, int width, int height, int blocksPerPixel, EntityPlayer player) {
        final byte[] textureData = new byte[width * height];
        int startX = cx - width * blocksPerPixel / 2;
        int startZ = cz - height * blocksPerPixel / 2;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int x = startX + i * blocksPerPixel;
                int z = startZ + j * blocksPerPixel;
                int ix = x - (this.map.chunkStartX << 4);
                int iz = z - (this.map.chunkStartZ << 4);
                if (ix < 0 || iz < 0 || ix >= 2048 || iz >= 2048) continue;
                textureData[i + j * width] = this.map.colors[ix + iz * 2048];
            }
        }
        BuildCraftCore.instance.sendToPlayer(player, new PacketCommand(this, "receiveImage", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeMedium(textureData.length);
                data.writeBytes(textureData);
            }
        }));
    }
}

