/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.tools.IToolWrench;
import buildcraft.builders.ItemConstructionMarker;
import buildcraft.builders.TileArchitect;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockArchitect
extends BlockBuildCraft {
    IIcon blockTextureTop;
    IIcon blockTextureSide;
    IIcon blockTextureFront;

    public BlockArchitect() {
        super(Material.field_151573_f, CreativeTabBuildCraft.BLOCKS);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileArchitect();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        if (entityplayer.func_70093_af()) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            switch (ForgeDirection.values()[meta]) {
                case WEST: {
                    world.func_72921_c(x, y, z, ForgeDirection.SOUTH.ordinal(), 0);
                    break;
                }
                case EAST: {
                    world.func_72921_c(x, y, z, ForgeDirection.NORTH.ordinal(), 0);
                    break;
                }
                case NORTH: {
                    world.func_72921_c(x, y, z, ForgeDirection.WEST.ordinal(), 0);
                    break;
                }
                default: {
                    world.func_72921_c(x, y, z, ForgeDirection.EAST.ordinal(), 0);
                }
            }
            world.func_147471_g(x, y, z);
            ((IToolWrench)equipped).wrenchUsed(entityplayer, x, y, z);
            return true;
        }
        if (equipped instanceof ItemConstructionMarker) {
            ItemConstructionMarker.link(entityplayer.func_71045_bC(), world, x, y, z);
            return true;
        }
        if (!world.field_72995_K) {
            entityplayer.openGui((Object)BuildCraftBuilders.instance, 10, world, x, y, z);
        }
        return true;
    }

    @Override
    public void func_149749_a(World world, int i, int j, int k, Block block, int par6) {
        Utils.preDestroyBlock(world, i, j, k);
        super.func_149749_a(world, i, j, k, block, par6);
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        if (j == 0 && i == 3) {
            return this.blockTextureFront;
        }
        if (i == j) {
            return this.blockTextureFront;
        }
        switch (i) {
            case 1: {
                return this.blockTextureTop;
            }
        }
        return this.blockTextureSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.blockTextureTop = par1IconRegister.func_94245_a("buildcraft:architect_top");
        this.blockTextureSide = par1IconRegister.func_94245_a("buildcraft:architect_side");
        this.blockTextureFront = par1IconRegister.func_94245_a("buildcraft:architect_front");
    }
}

