/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.Position;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class SchematicEntity
extends Schematic {
    public Class<? extends Entity> entity;
    public NBTTagCompound entityNBT = new NBTTagCompound();
    public ItemStack[] storedRequirements = new ItemStack[0];

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        Collections.addAll(requirements, this.storedRequirements);
    }

    public void writeToWorld(IBuilderContext context) {
        Entity e = EntityList.func_75615_a((NBTTagCompound)this.entityNBT, (World)context.world());
        context.world().func_72838_d(e);
    }

    public void readFromWorld(IBuilderContext context, Entity entity) {
        entity.func_70039_c(this.entityNBT);
    }

    @Override
    public void translateToBlueprint(Translation transform) {
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos = transform.translate(pos);
        this.entityNBT.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
    }

    @Override
    public void translateToWorld(Translation transform) {
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos = transform.translate(pos);
        this.entityNBT.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
    }

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        registry.scanAndTranslateStacksToRegistry(this.entityNBT);
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        try {
            registry.scanAndTranslateStacksToWorld(this.entityNBT);
        }
        catch (MappingNotFoundException e) {
            this.entityNBT = new NBTTagCompound();
        }
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos = context.rotatePositionLeft(pos);
        this.entityNBT.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
        nbttaglist = this.entityNBT.func_150295_c("Rotation", 5);
        float yaw = nbttaglist.func_150308_e(0);
        this.entityNBT.func_74782_a("Rotation", (NBTBase)this.newFloatNBTList(yaw += 90.0f, nbttaglist.func_150308_e(1)));
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.func_74768_a("entityId", registry.getIdForEntity(this.entity));
        nbt.func_74782_a("entity", (NBTBase)this.entityNBT);
        NBTTagList rq = new NBTTagList();
        for (ItemStack stack : this.storedRequirements) {
            NBTTagCompound sub = new NBTTagCompound();
            stack.func_77955_b(stack.func_77955_b(sub));
            sub.func_74768_a("id", registry.getIdForItem(stack.func_77973_b()));
            rq.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("rq", (NBTBase)rq);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.entityNBT = nbt.func_74775_l("entity");
        NBTTagList rq = nbt.func_150295_c("rq", 10);
        ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
        for (int i = 0; i < rq.func_74745_c(); ++i) {
            try {
                NBTTagCompound sub = rq.func_150305_b(i);
                if (sub.func_74762_e("id") < 0) continue;
                sub.func_74768_a("id", Item.field_150901_e.func_148757_b((Object)registry.getItemForId(sub.func_74762_e("id"))));
                rqs.add(ItemStack.func_77949_a((NBTTagCompound)sub));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.storedRequirements = rqs.toArray(new ItemStack[rqs.size()]);
    }

    protected NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble = par1ArrayOfDouble;
        int i = par1ArrayOfDouble.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float ... par1ArrayOfFloat) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat = par1ArrayOfFloat;
        int i = par1ArrayOfFloat.length;
        for (int j = 0; j < i; ++j) {
            float f1 = afloat[j];
            nbttaglist.func_74742_a((NBTBase)new NBTTagFloat(f1));
        }
        return nbttaglist;
    }

    public boolean isAlreadyBuilt(IBuilderContext context) {
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position newPosition = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        for (Object o : context.world().field_72996_f) {
            Entity e = (Entity)o;
            Position existingPositon = new Position(e.field_70165_t, e.field_70163_u, e.field_70161_v);
            if (!existingPositon.isClose(newPosition, 0.1f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int buildTime() {
        return 5;
    }
}

