/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderzoo.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public final class Config {
    public static final List<Section> sections = new ArrayList<Section>();
    public static Configuration config;
    public static File configDirectory;
    public static final Section sectionDifficulty;
    public static boolean enderZooDifficultyModifierEnabled;
    public static double enderZooEasyHealthModifier;
    public static double enderZooEasyAttackModifier;
    public static double enderZooNormalHealthModifier;
    public static double enderZooNormalAttackModifier;
    public static double enderZooHardHealthModifier;
    public static double enderZooHardAttackModifier;
    public static boolean globalDifficultyModifierEnabled;
    public static double globalEasyHealthModifier;
    public static double globalEasyAttackModifier;
    public static double globalNormalHealthModifier;
    public static double globalNormalAttackModifier;
    public static double globalHardHealthModifier;
    public static double globalHardAttackModifier;
    public static final Section sectionEnderminy;
    public static boolean enderminyEnabled;
    public static boolean enderminyAttacksPlayerOnSight;
    public static boolean enderminyAttacksCreepers;
    public static int enderminyAttackDamage;
    public static int enderminyHealth;
    public static boolean enderminyGroupAgro;
    public static int enderminyMaxGroupSize;
    public static boolean enderminySpawnInLitAreas;
    public static boolean enderminySpawnOnlyOnGrass;
    public static int enderminyMinSpawnY;
    public static final Section sectionConCreeper;
    public static boolean concussionCreeperEnabled;
    public static int concussionCreeperMaxTeleportRange;
    public static int concussionCreeperConfusionDuration;
    public static int concussionCreeperExplosionRange;
    public static double concussionCreeperHealth;
    public static final Section sectionFallenKnight;
    public static boolean fallenKnightEnabled;
    public static double fallenKnightBaseDamage;
    public static double fallenKnightHealth;
    public static double fallenKnightFollowRange;
    public static double fallenKnightChargeSpeed;
    public static int fallenKnightRangedMinAttackPause;
    public static int fallenKnightRangedMaxAttackPause;
    public static float fallenKnightRangedMaxRange;
    public static float fallenKnightChancePerArmorPiece;
    public static float fallenKnightChancePerArmorPieceHard;
    public static float fallenKnightRangedRatio;
    public static float fallenKnightChanceMounted;
    public static float fallenKnightChanceArmorUpgradeHard;
    public static float fallenKnightChanceArmorUpgrade;
    public static boolean fallKnightMountedArchesMaintainDistance;
    public static boolean fallenKnightArchersSwitchToMelee;
    public static final Section sectionFallenMount;
    public static boolean fallenMountEnabled;
    public static double fallenMountChargeSpeed;
    public static double fallenMountBaseAttackDamage;
    public static boolean fallenMountShadedByRider;
    public static float fallenMountChanceArmored;
    public static float fallenMountChanceArmoredHard;
    public static float fallenMountChanceArmorUpgrade;
    public static float fallenMountChanceArmorUpgradeHard;
    public static double fallenMountHealth;
    public static final Section sectionWitherWitch;
    public static boolean witherWitchEnabled;
    public static double witherWitchHealth;
    public static int witherWitchMinCats;
    public static int witherWitchMaxCats;
    public static final Section sectionWitherCat;
    public static boolean witherCatEnabled;
    public static double witherCatHealth;
    public static double witherCatAttackDamage;
    public static double witherCatAngryHealth;
    public static double witherCatAngryAttackDamage;
    public static double witherCatAngryAttackDamageHardModifier;
    public static final Section sectionDireWolf;
    public static boolean direWolfEnabled;
    public static boolean direWolfPackAttackEnabled;
    public static double direWolfHealth;
    public static double direWolfAttackDamage;
    public static double direWolfHardAttackModifier;
    public static double direWolfAggresiveRange;
    public static final Section sectionEnchants;
    public static int enchantmentWitherArrowId;
    public static int enchantmentWitherArrowWeight;
    public static int enchantmentWitherArrowDuration;
    public static int enchantmentWitherArrowMinEnchantability;
    public static int enchantmentWitherArrowMaxEnchantability;
    public static int enchantmentWitherWeaponId;
    public static int enchantmentWitherWeaponWeight;
    public static int enchantmentWitherWeaponDuration;
    public static int enchantmentWitherWeaponMinEnchantability;
    public static int enchantmentWitherWeaponMaxEnchantability;
    public static final Section sectionCharges;
    public static boolean confusingChargeEnabled;
    public static double confusingChargeRange;
    public static int confusingChargeEffectDuration;
    public static boolean enderChargeEnabled;
    public static double enderChargeRange;
    public static int enderChargeMaxTeleportRange;
    public static boolean concussionChargeEnabled;
    public static final Section sectionDebug;
    public static boolean spawnConfigPrintDetailedOutput;
    public static final Section sectionGuardian;
    public static boolean guardiansBowEnabled;
    public static int guardiansBowDrawTime;
    public static float guardiansBowDamageBonus;
    public static float guardiansBowForceMultiplier;
    public static float guardiansBowFovMultiplier;

    public static void load(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new Config());
        configDirectory = new File(event.getModConfigurationDirectory(), "EnderZoo".toLowerCase());
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "EnderZoo.cfg");
        config = new Configuration(configFile);
        Config.syncConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncConfig() {
        try {
            Config.processConfig(config);
        }
        catch (Exception e) {
            Log.error("EnderZoo has a problem loading it's configuration");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("EnderZoo")) {
            Log.info("Updating config...");
            Config.syncConfig();
        }
    }

    public static void processConfig(Configuration config) {
        enderminyEnabled = config.getBoolean("enderminyEnabled", Config.sectionEnderminy.name, enderminyEnabled, "Wether Enderminies are enabled");
        enderminyAttacksPlayerOnSight = config.getBoolean("enderminyAttacksPlayerOnSight", Config.sectionEnderminy.name, enderminyAttacksPlayerOnSight, "When true an Enderminy will attack a player if it looks at them, otherwise they are neutral mobs.");
        enderminyAttacksCreepers = config.getBoolean("enderminyAttacksCreepers", Config.sectionEnderminy.name, enderminyAttacksCreepers, "When true Enderminies will attack creepers");
        enderminyAttackDamage = config.get(Config.sectionEnderminy.name, "enderminyAttackDamage", enderminyAttackDamage, "Attack damage of Enderminies. 7=Enderman damage, 3=Zombie damage").getInt(enderminyAttackDamage);
        enderminyHealth = config.get(Config.sectionEnderminy.name, "enderminyHealth", enderminyHealth, "Health of Enderminies. 40=Enderman health, 20=Zombie health").getInt(enderminyHealth);
        enderminyGroupAgro = config.getBoolean("enderminyGroupAgro", Config.sectionEnderminy.name, enderminyGroupAgro, "When true attacking one Enderminy will cause other Enderminies who witness the attack to attack the player as well");
        enderminyMaxGroupSize = config.get(Config.sectionEnderminy.name, "enderminyMaxGroupSize", enderminyMaxGroupSize, "Maximum number of Enderminies that will spawn in a single group").getInt(enderminyMaxGroupSize);
        enderminySpawnInLitAreas = config.getBoolean("enderminySpawnInLitAreas", Config.sectionEnderminy.name, enderminySpawnInLitAreas, "When true enderminies will spawn in well lit areas, when false they will only spawn in dark areas.");
        enderminySpawnOnlyOnGrass = config.getBoolean("enderminySpawnOnlyOnGrass", Config.sectionEnderminy.name, enderminySpawnOnlyOnGrass, "When true enderminies will spawn only on grass blocks.");
        enderminyMinSpawnY = config.get(Config.sectionEnderminy.name, "enderminyMinSpawnY", enderminyMinSpawnY, "The minimum Y level at which enderminies will spawn").getInt(enderminyMinSpawnY);
        concussionCreeperEnabled = config.getBoolean("concussionCreeperEnabled", Config.sectionConCreeper.name, concussionCreeperEnabled, "Wether ConcussionCreepers are enabled");
        concussionCreeperMaxTeleportRange = config.get(Config.sectionConCreeper.name, "concussionCreeperMaxTeleportRange", concussionCreeperMaxTeleportRange, "Sets the max range entites can be telported when the creeper explodes").getInt(concussionCreeperMaxTeleportRange);
        concussionCreeperConfusionDuration = config.get(Config.sectionConCreeper.name, "concussionCreeperConfusionDuration", concussionCreeperConfusionDuration, "Sets the durtaion in ticks of the confusion effect applied on explosion").getInt(concussionCreeperConfusionDuration);
        concussionCreeperExplosionRange = config.get(Config.sectionConCreeper.name, "concussionCreeperExplosionRange", concussionCreeperExplosionRange, "The range of the 'teleport explosion'").getInt(concussionCreeperExplosionRange);
        concussionCreeperHealth = config.get(Config.sectionConCreeper.name, "concussionCreeperHealth", concussionCreeperHealth, "Health of Concussion Creeper. 40=Enderman health, 20=Zombie health").getDouble(concussionCreeperHealth);
        fallenKnightEnabled = config.getBoolean("fallenKnightEnabled", Config.sectionFallenKnight.name, fallenKnightEnabled, "Wether Fallen Knights are enabled");
        fallenKnightBaseDamage = config.get(Config.sectionFallenKnight.name, "fallenKnightBaseDamage", fallenKnightBaseDamage, "Base damage of a knight").getDouble(fallenKnightBaseDamage);
        fallenKnightHealth = config.get(Config.sectionFallenKnight.name, "fallenKnightHealth", fallenKnightHealth, "Health of a knight").getDouble(fallenKnightHealth);
        fallenKnightFollowRange = config.get(Config.sectionFallenKnight.name, "fallenKnightFollowRange", fallenKnightFollowRange, "Follow range of a knight").getDouble(fallenKnightFollowRange);
        fallenKnightChargeSpeed = config.get(Config.sectionFallenKnight.name, "fallenKnightChargeSpeed", fallenKnightChargeSpeed, "The speed at which a knight will charge its target").getDouble(fallenKnightChargeSpeed);
        fallenKnightRangedMinAttackPause = config.get(Config.sectionFallenKnight.name, "fallenKnightRangedMinAttackPause", fallenKnightRangedMinAttackPause, "The min number of ticks between ranged attacks").getInt(fallenKnightRangedMinAttackPause);
        fallenKnightRangedMaxAttackPause = config.get(Config.sectionFallenKnight.name, "fallenKnightRangedMaxAttackPause", fallenKnightRangedMaxAttackPause, "The max number of ticks between ranged attacks").getInt(fallenKnightRangedMaxAttackPause);
        fallenKnightRangedMaxRange = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightRangedMaxRange", (double)fallenKnightRangedMaxRange, "The max attack range when using a bow").getDouble((double)fallenKnightRangedMaxRange);
        fallenKnightChancePerArmorPiece = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightChancePerArmorPiece", (double)fallenKnightChancePerArmorPiece, "The chance each armor piece has of being added to a spawned knight").getDouble((double)fallenKnightChancePerArmorPiece);
        fallenKnightChancePerArmorPieceHard = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightChancePerArmorPieceHard", (double)fallenKnightChancePerArmorPieceHard, "The chance each armor piece has of being added to a spawned knight when difficulty is set to hard").getDouble((double)fallenKnightChancePerArmorPieceHard);
        fallenKnightRangedRatio = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightRangedRatio", (double)fallenKnightRangedRatio, "The precentage of spawned knoghts equipped with bows").getDouble((double)fallenKnightRangedRatio);
        fallenKnightChanceMounted = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightChanceMounted", (double)fallenKnightChanceMounted, "The chance a spawned knight will be mounted").getDouble((double)fallenKnightChanceMounted);
        fallenKnightChanceArmorUpgradeHard = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightChanceArmorUpgradeHard", (double)fallenKnightChanceArmorUpgradeHard, "The chance the type of armor equipped will be improved when dificult is hard").getDouble((double)fallenKnightChanceArmorUpgradeHard);
        fallenKnightChanceArmorUpgrade = (float)config.get(Config.sectionFallenKnight.name, "fallenKnightChanceArmorUpgrade", (double)fallenKnightChanceArmorUpgrade, "The chance the type of armor equipped will be improved").getDouble((double)fallenKnightChanceArmorUpgrade);
        fallKnightMountedArchesMaintainDistance = config.getBoolean("fallKnightMountedArchesMaintainDistance", Config.sectionFallenKnight.name, fallKnightMountedArchesMaintainDistance, "When true mounted archer knigts will attempt to keep distance between themselves and their target");
        fallenKnightArchersSwitchToMelee = config.getBoolean("fallenKnightArchersSwitchToMelee", Config.sectionFallenKnight.name, fallenKnightArchersSwitchToMelee, "When true archer knigts will switch to a sword when target is within melee range. Doesn't apply to mounted archers if fallKnightMountedArchesMaintainDistance is true");
        fallenMountEnabled = config.getBoolean("fallenMountEnabled", Config.sectionFallenMount.name, fallenMountEnabled, "If false fallen mounts will be disabled");
        fallenMountChargeSpeed = config.get(Config.sectionFallenMount.name, "fallenMountChargeSpeed", fallenMountChargeSpeed, "he speed at which a mount will charge its target").getDouble(fallenMountChargeSpeed);
        fallenMountBaseAttackDamage = config.get(Config.sectionFallenMount.name, "fallenMountBaseAttackDamage", fallenMountBaseAttackDamage, "Base attack damage of the mount").getDouble(fallenMountBaseAttackDamage);
        fallenMountHealth = config.get(Config.sectionFallenMount.name, "fallenMountHealth", fallenMountHealth, "Base attack health of the mount").getDouble(fallenMountHealth);
        fallenMountShadedByRider = config.getBoolean("fallenMountShadedByRider", Config.sectionFallenMount.name, fallenMountShadedByRider, "When true a mount will not burn in the sun unless its rider is");
        fallenMountChanceArmored = (float)config.get(Config.sectionFallenMount.name, "fallenMountChanceArmored", (double)fallenMountChanceArmored, "The chance a spawned mount will be armored").getDouble((double)fallenMountChanceArmored);
        fallenMountChanceArmoredHard = (float)config.get(Config.sectionFallenMount.name, "fallenMountChanceArmoredHard", (double)fallenMountChanceArmoredHard, "The chance a spawned mount will be armored when difficult is hard").getDouble((double)fallenMountChanceArmoredHard);
        fallenMountChanceArmorUpgrade = (float)config.get(Config.sectionFallenMount.name, "fallenMountChanceArmorUpgrade", (double)fallenMountChanceArmorUpgrade, "The chance a mount's armor will be upgraded").getDouble((double)fallenMountChanceArmorUpgrade);
        fallenMountChanceArmorUpgradeHard = (float)config.get(Config.sectionFallenMount.name, "fallenMountChanceArmorUpgradeHard", (double)fallenMountChanceArmorUpgradeHard, "The chance a mount's armor will be upgraded when difficulty is hard").getDouble((double)fallenMountChanceArmorUpgradeHard);
        witherWitchEnabled = config.getBoolean("witherWitchEnabled", Config.sectionWitherWitch.name, witherWitchEnabled, "If false Wither Witches will be disabled");
        witherWitchHealth = config.get(Config.sectionWitherWitch.name, "witherWitchHealth", witherWitchHealth, "Base attack damage of the mount").getDouble(witherWitchHealth);
        witherWitchMinCats = config.get(Config.sectionWitherWitch.name, "witherWitchMinCats", witherWitchMinCats, "The minimum number of cats spawned with a Wither Witch").getInt(witherWitchMinCats);
        witherWitchMaxCats = config.get(Config.sectionWitherWitch.name, "witherWitchMaxCats", witherWitchMaxCats, "The maximum number of cats spawned with a Wither Witch").getInt(witherWitchMaxCats);
        witherCatEnabled = config.getBoolean("witherCatEnabled", Config.sectionWitherCat.name, witherCatEnabled, "If false Wither Cats will be disabled");
        witherCatHealth = config.get(Config.sectionWitherCat.name, "witherCatHealth", witherCatHealth, "Base health of the wither cat").getDouble(witherCatHealth);
        witherCatAttackDamage = config.get(Config.sectionWitherCat.name, "witherCatAttackDamage", witherCatAttackDamage, "Base attack damage of the wither cat").getDouble(witherCatAttackDamage);
        witherCatAngryAttackDamageHardModifier = config.get(Config.sectionWitherCat.name, "witherCatAngryAttackDamageHardModifier", witherCatAngryAttackDamageHardModifier, "The increase to damage when playing on hard").getDouble(witherCatAngryAttackDamageHardModifier);
        direWolfEnabled = config.getBoolean("direWolfEnabled", Config.sectionDireWolf.name, direWolfEnabled, "If false Dire Wolves will be disabled");
        direWolfPackAttackEnabled = config.getBoolean("direWolfPackAttackEnabled", Config.sectionDireWolf.name, direWolfPackAttackEnabled, "When true all nearby dire wolves will join an attack");
        direWolfHealth = config.get(Config.sectionDireWolf.name, "direWolfHealth", direWolfHealth, "Base health of the Dire Wolf").getDouble(direWolfHealth);
        direWolfAttackDamage = config.get(Config.sectionDireWolf.name, "direWolfAttackDamage", direWolfAttackDamage, "Base attack damage of the dire wolf").getDouble(direWolfAttackDamage);
        direWolfHardAttackModifier = config.get(Config.sectionDireWolf.name, "direWolfHardAttackModifier", direWolfHardAttackModifier, "The increase to damage when playing on hard").getDouble(direWolfHardAttackModifier);
        direWolfAggresiveRange = config.get(Config.sectionDireWolf.name, "direWolfAggresiveRange", direWolfAggresiveRange, "If a player gets within this range they will be attacked").getDouble(direWolfAggresiveRange);
        enchantmentWitherArrowId = config.get(Config.sectionEnchants.name, "enchantmentWitherArrowId", enchantmentWitherArrowId, "The id of the enchantment. If set to -1 the lowest unassigned id will be used.").getInt(enchantmentWitherArrowId);
        enchantmentWitherArrowWeight = config.get(Config.sectionEnchants.name, "enchantmentWitherArrowWeight", enchantmentWitherArrowWeight, "The weight (or chance of getting) the enchantment. eg sharpness=10, knockback = 5, fire aspect = 2, silk touch = 1").getInt(enchantmentWitherArrowWeight);
        enchantmentWitherArrowDuration = config.get(Config.sectionEnchants.name, "enchantmentWitherArrowDuration", enchantmentWitherArrowDuration, "Duration of the wither effect in ticks").getInt(enchantmentWitherArrowDuration);
        enchantmentWitherArrowMinEnchantability = config.get(Config.sectionEnchants.name, "enchantmentWitherArrowMinEnchantability", enchantmentWitherArrowMinEnchantability, "The minimum required enchantability level").getInt(enchantmentWitherArrowMinEnchantability);
        enchantmentWitherArrowMaxEnchantability = config.get(Config.sectionEnchants.name, "enchantmentWitherArrowMaxEnchantability", enchantmentWitherArrowMaxEnchantability, "The maximum required level").getInt(enchantmentWitherArrowMaxEnchantability);
        enchantmentWitherWeaponId = config.get(Config.sectionEnchants.name, "enchantmentWitherWeaponId", enchantmentWitherWeaponId, "The id of the enchantment. If set to -1 the lowest unassigned id will be used.").getInt(enchantmentWitherWeaponId);
        enchantmentWitherWeaponWeight = config.get(Config.sectionEnchants.name, "enchantmentWitherWeaponWeight", enchantmentWitherWeaponWeight, "The weight (or chance of getting) the enchantment. eg sharpness=10, knockback = 5, fire aspect = 2, silk touch = 1").getInt(enchantmentWitherWeaponWeight);
        enchantmentWitherWeaponDuration = config.get(Config.sectionEnchants.name, "enchantmentWitherWeaponDuration", enchantmentWitherWeaponDuration, "Duration of the wither effect in ticks").getInt(enchantmentWitherWeaponDuration);
        enchantmentWitherWeaponMinEnchantability = config.get(Config.sectionEnchants.name, "enchantmentWitherWeaponMinEnchantability", enchantmentWitherWeaponMinEnchantability, "The minimum required enchantability level").getInt(enchantmentWitherWeaponMinEnchantability);
        enchantmentWitherWeaponMaxEnchantability = config.get(Config.sectionEnchants.name, "enchantmentWitherWeaponMaxEnchantability", enchantmentWitherWeaponMaxEnchantability, "The maximum required level").getInt(enchantmentWitherWeaponMaxEnchantability);
        confusingChargeEnabled = config.getBoolean("confusingChargeEnabled", Config.sectionCharges.name, confusingChargeEnabled, "If false Confusing Charges will be disabled");
        confusingChargeRange = config.get(Config.sectionCharges.name, "confusingChargeRange", confusingChargeRange, "The range of the confusion charges effect").getDouble(confusingChargeRange);
        confusingChargeEffectDuration = config.get(Config.sectionCharges.name, "confusingChargeEffectDuration", confusingChargeEffectDuration, "Numer of ticks the confusion effect active. Scales with distance from the expolosion").getInt(confusingChargeEffectDuration);
        enderChargeEnabled = config.getBoolean("enderChargeEnabled", Config.sectionCharges.name, enderChargeEnabled, "If false Ender Charges will be disabled");
        enderChargeRange = config.get(Config.sectionCharges.name, "enderChargeRange", enderChargeRange, "The range of the ender charges effect").getDouble(enderChargeRange);
        enderChargeMaxTeleportRange = config.get(Config.sectionCharges.name, "enderChargeMaxTeleportRange", enderChargeMaxTeleportRange, "The max range effected entities will be teleported. Distance is randomised").getInt(enderChargeMaxTeleportRange);
        concussionChargeEnabled = config.getBoolean("concussionChargeEnabled", Config.sectionCharges.name, concussionChargeEnabled, "If false Concussion Charges will be disabled");
        enderZooDifficultyModifierEnabled = config.getBoolean("enderZooDifficultyModifierEnabled", Config.sectionDifficulty.name, enderZooDifficultyModifierEnabled, "When enabled health and base damage for all Ender Zoo mobs will be modified based on difficulty");
        enderZooEasyHealthModifier = config.get(Config.sectionDifficulty.name, "enderZooEasyHealthModifier", enderZooEasyHealthModifier, "When in easy difficulty base health is multiplied by this value, rounded to the nearest whole 'heart'").getDouble(enderZooEasyHealthModifier);
        enderZooNormalHealthModifier = config.get(Config.sectionDifficulty.name, "enderZooNormalHealthModifier", enderZooNormalHealthModifier, "When in normal difficultry base health is multiplied by this value, rounded to the nearest whole 'heart'").getDouble(enderZooNormalHealthModifier);
        enderZooHardHealthModifier = config.get(Config.sectionDifficulty.name, "enderZooHardHealthModifier", enderZooHardHealthModifier, "When in hard mode base health is multiplied by this value, rounded to the nearest whole 'heart'").getDouble(enderZooHardHealthModifier);
        enderZooEasyAttackModifier = config.get(Config.sectionDifficulty.name, "enderZooEasyAttackModifier", enderZooEasyAttackModifier, "When in easy difficulty base attack damage is multiplied by this value").getDouble(enderZooEasyAttackModifier);
        enderZooNormalAttackModifier = config.get(Config.sectionDifficulty.name, "enderZooNormalAttackModifier", enderZooNormalAttackModifier, "When in easy difficulty base attack damage is multiplied by this value").getDouble(enderZooNormalAttackModifier);
        enderZooHardAttackModifier = config.get(Config.sectionDifficulty.name, "enderZooHardAttackModifier", enderZooHardAttackModifier, "When in easy difficulty base attack damage is multiplied by this value").getDouble(enderZooHardAttackModifier);
        globalDifficultyModifierEnabled = config.getBoolean("globalDifficultyModifierEnabled", Config.sectionDifficulty.name, globalDifficultyModifierEnabled, "When enabled health and base damage for all non Ender Zoo mobs will be modified based on difficulty");
        globalEasyHealthModifier = config.get(Config.sectionDifficulty.name, "globalEasyHealthModifier", globalEasyHealthModifier, "When in easy difficulty base health is multiplied by this value, rounded to the nearest whole 'heart'").getDouble(globalEasyHealthModifier);
        globalNormalHealthModifier = config.get(Config.sectionDifficulty.name, "globalNormalHealthModifier", globalNormalHealthModifier, "When in normal difficultry base health is multiplied by this value, rounded to the nearest whole 'heart'").getDouble(globalNormalHealthModifier);
        globalHardHealthModifier = config.get(Config.sectionDifficulty.name, "globalHardHealthModifier", globalHardHealthModifier, "When in hard mode base health is multiplied by this value, rounded to the nearest whole 'heart'").getDouble(globalHardHealthModifier);
        globalEasyAttackModifier = config.get(Config.sectionDifficulty.name, "globalEasyAttackModifier", globalEasyAttackModifier, "When in easy difficulty base attack damage is multiplied by this value").getDouble(globalEasyAttackModifier);
        globalNormalAttackModifier = config.get(Config.sectionDifficulty.name, "globalNormalAttackModifier", globalNormalAttackModifier, "When in easy difficulty base attack damage is multiplied by this value").getDouble(globalNormalAttackModifier);
        globalHardAttackModifier = config.get(Config.sectionDifficulty.name, "globalHardAttackModifier", globalHardAttackModifier, "When in easy difficulty base attack damage is multiplied by this value").getDouble(globalHardAttackModifier);
        spawnConfigPrintDetailedOutput = config.getBoolean("spawnConfigPrintDetailedOutput", Config.sectionDebug.name, spawnConfigPrintDetailedOutput, "When enabled detailed information about spawn config will be printed to the log.");
        guardiansBowEnabled = config.getBoolean("guardiansBowEnabled", Config.sectionGuardian.name, guardiansBowEnabled, "If false the Guardians Bow will be disabled");
        guardiansBowDrawTime = config.get(Config.sectionGuardian.name, "guardiansBowDrawTime", guardiansBowDrawTime, "The number of ticks it takes to fully draw the guardians bow. A 'vanilla' bow takes 20 ticks.").getInt(guardiansBowDrawTime);
        guardiansBowDamageBonus = (float)config.get(Config.sectionGuardian.name, "guardiansBowDamageBonus", (double)guardiansBowDamageBonus, "The damage bonus applied to arrows fire from the bow.").getDouble((double)guardiansBowDamageBonus);
        guardiansBowForceMultiplier = (float)config.get(Config.sectionGuardian.name, "guardiansBowForceMultiplier", (double)guardiansBowForceMultiplier, "Effects the speed with which arrows leave the bow. A 'vanilla' bow has a multiplier of 2.").getDouble((double)guardiansBowForceMultiplier);
        guardiansBowFovMultiplier = (float)config.get(Config.sectionGuardian.name, "guardiansBowFovMultiplier", (double)guardiansBowFovMultiplier, "The reduction in FOV when the bow is fullen drawn (the zoom level). A 'vanilla' bow has a value of 0.15").getDouble((double)guardiansBowFovMultiplier);
    }

    private Config() {
    }

    static {
        sectionDifficulty = new Section("Difficulty", "difficulty");
        enderZooDifficultyModifierEnabled = true;
        enderZooEasyHealthModifier = 0.9;
        enderZooEasyAttackModifier = 0.9;
        enderZooNormalHealthModifier = 1.0;
        enderZooNormalAttackModifier = 1.0;
        enderZooHardHealthModifier = 1.1;
        enderZooHardAttackModifier = 1.1;
        globalDifficultyModifierEnabled = true;
        globalEasyHealthModifier = 0.9;
        globalEasyAttackModifier = 0.9;
        globalNormalHealthModifier = 1.0;
        globalNormalAttackModifier = 1.0;
        globalHardHealthModifier = 1.1;
        globalHardAttackModifier = 1.1;
        sectionEnderminy = new Section("Enderminy", "enderminy");
        enderminyEnabled = true;
        enderminyAttacksPlayerOnSight = false;
        enderminyAttacksCreepers = true;
        enderminyAttackDamage = 10;
        enderminyHealth = 20;
        enderminyGroupAgro = true;
        enderminyMaxGroupSize = 3;
        enderminySpawnInLitAreas = false;
        enderminySpawnOnlyOnGrass = true;
        enderminyMinSpawnY = 0;
        sectionConCreeper = new Section("Concussion Creeper", "concussionCreeper");
        concussionCreeperEnabled = true;
        concussionCreeperMaxTeleportRange = 32;
        concussionCreeperConfusionDuration = 100;
        concussionCreeperExplosionRange = 5;
        concussionCreeperHealth = 20.0;
        sectionFallenKnight = new Section("Fallen Knight", "fallenKnight");
        fallenKnightEnabled = true;
        fallenKnightBaseDamage = 4.0;
        fallenKnightHealth = 20.0;
        fallenKnightFollowRange = 40.0;
        fallenKnightChargeSpeed = 1.2;
        fallenKnightRangedMinAttackPause = 20;
        fallenKnightRangedMaxAttackPause = 60;
        fallenKnightRangedMaxRange = 15.0f;
        fallenKnightChancePerArmorPiece = 0.7f;
        fallenKnightChancePerArmorPieceHard = 0.9f;
        fallenKnightRangedRatio = 0.25f;
        fallenKnightChanceMounted = 0.75f;
        fallenKnightChanceArmorUpgradeHard = 0.4f;
        fallenKnightChanceArmorUpgrade = 0.2f;
        fallKnightMountedArchesMaintainDistance = true;
        fallenKnightArchersSwitchToMelee = true;
        sectionFallenMount = new Section("Fallen Mount", "fallenMount");
        fallenMountEnabled = true;
        fallenMountChargeSpeed = 2.5;
        fallenMountBaseAttackDamage = 4.0;
        fallenMountShadedByRider = true;
        fallenMountChanceArmored = 0.5f;
        fallenMountChanceArmoredHard = 0.9f;
        fallenMountChanceArmorUpgrade = 0.01f;
        fallenMountChanceArmorUpgradeHard = 0.05f;
        fallenMountHealth = 30.0;
        sectionWitherWitch = new Section("Wither Witch", "witherWitch");
        witherWitchEnabled = true;
        witherWitchHealth = 30.0;
        witherWitchMinCats = 1;
        witherWitchMaxCats = 2;
        sectionWitherCat = new Section("Wither Cat", "witherCat");
        witherCatEnabled = true;
        witherCatHealth = 12.0;
        witherCatAttackDamage = 3.0;
        witherCatAngryHealth = 30.0;
        witherCatAngryAttackDamage = 9.0;
        witherCatAngryAttackDamageHardModifier = 2.0;
        sectionDireWolf = new Section("Dire Wolf", "direWolf");
        direWolfEnabled = true;
        direWolfPackAttackEnabled = true;
        direWolfHealth = 20.0;
        direWolfAttackDamage = 10.0;
        direWolfHardAttackModifier = 1.0;
        direWolfAggresiveRange = 4.0;
        sectionEnchants = new Section("Enchantments", "enchantments");
        enchantmentWitherArrowId = -1;
        enchantmentWitherArrowWeight = 2;
        enchantmentWitherArrowDuration = 200;
        enchantmentWitherArrowMinEnchantability = 20;
        enchantmentWitherArrowMaxEnchantability = 50;
        enchantmentWitherWeaponId = -1;
        enchantmentWitherWeaponWeight = 2;
        enchantmentWitherWeaponDuration = 200;
        enchantmentWitherWeaponMinEnchantability = 20;
        enchantmentWitherWeaponMaxEnchantability = 50;
        sectionCharges = new Section("Charges", "charges");
        confusingChargeEnabled = true;
        confusingChargeRange = 6.0;
        confusingChargeEffectDuration = 300;
        enderChargeEnabled = true;
        enderChargeRange = 6.0;
        enderChargeMaxTeleportRange = 64;
        concussionChargeEnabled = true;
        sectionDebug = new Section("Debug", "debug");
        spawnConfigPrintDetailedOutput = false;
        sectionGuardian = new Section("Guardian", "guardian");
        guardiansBowEnabled = true;
        guardiansBowDrawTime = 14;
        guardiansBowDamageBonus = 0.0f;
        guardiansBowForceMultiplier = 3.0f;
        guardiansBowFovMultiplier = 0.35f;
    }

    public static class Section {
        public final String name;
        public final String lang;

        public Section(String name, String lang) {
            this.name = name;
            this.lang = lang;
            this.register();
        }

        private void register() {
            sections.add(this);
        }

        public String lc() {
            return this.name.toLowerCase();
        }
    }
}

