/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.carving;

import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.carving.CarvingGroup;
import com.cricketcraft.chisel.carving.CarvingVariation;
import com.cricketcraft.chisel.carving.GroupList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Carving
implements ICarvingRegistry {
    GroupList groups = new GroupList();
    public static final ICarvingRegistry chisel = new Carving();
    public static final Carving needle = new Carving();

    private Carving() {
    }

    @Override
    public ICarvingVariation getVariation(Block block, int metadata) {
        ICarvingGroup g = this.getGroup(block, metadata);
        if (g != null) {
            for (ICarvingVariation v : g.getVariations()) {
                if (v.getBlock() != block || v.getBlockMeta() != metadata) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    public List<ICarvingVariation> getGroupVariations(Block block, int metadata) {
        ICarvingGroup group = this.getGroup(block, metadata);
        if (group == null) {
            return null;
        }
        return group.getVariations();
    }

    @Override
    public String getOreName(Block block, int metadata) {
        ICarvingGroup group = this.getGroup(block, metadata);
        if (group == null) {
            return null;
        }
        return group.getOreName();
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ItemStack chiseledItem) {
        ArrayList ores;
        String oreName;
        int i;
        int[] oreids;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ICarvingGroup group = null;
        int[] arr$ = oreids = OreDictionary.getOreIDs((ItemStack)chiseledItem);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (group = this.groups.getGroupByOre(OreDictionary.getOreName((int)(i = arr$[i$])))) == null; ++i$) {
        }
        if (group == null) {
            group = this.getGroup(Block.func_149634_a((Item)chiseledItem.func_77973_b()), chiseledItem.func_77960_j());
        }
        if (group == null) {
            return items;
        }
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        List<ICarvingVariation> variations = group.getVariations();
        if (!group.getVariations().isEmpty()) {
            for (ICarvingVariation v : variations) {
                String key = Block.func_149682_b((Block)v.getBlock()) + "|" + v.getItemMeta();
                if (mapping.containsKey(key)) continue;
                mapping.put(key, 1);
                items.add(new ItemStack(v.getBlock(), 1, v.getItemMeta()));
            }
        }
        if ((oreName = group.getOreName()) != null && (ores = OreDictionary.getOres((String)oreName)) != null) {
            for (ItemStack stack : ores) {
                String key = Item.func_150891_b((Item)stack.func_77973_b()) + "|" + stack.func_77960_j();
                if (mapping.containsKey(key)) continue;
                mapping.put(key, 2);
                items.add(stack);
            }
        }
        return items;
    }

    @Override
    public ICarvingGroup getGroup(Block block, int metadata) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(block, 1, metadata));
        if (ids.length > 0) {
            for (int id : ids) {
                ICarvingGroup oreGroup = this.groups.getGroupByOre(OreDictionary.getOreName((int)id));
                if (oreGroup == null) continue;
                return oreGroup;
            }
        }
        return this.groups.getGroup(block, metadata);
    }

    @Override
    public ICarvingGroup getGroup(String name) {
        return this.groups.getGroupByName(name);
    }

    @Override
    public ICarvingGroup removeGroup(String groupName) {
        ICarvingGroup g = this.groups.getGroupByName(groupName);
        return this.groups.remove(g) ? g : null;
    }

    @Override
    public ICarvingVariation removeVariation(Block block, int metadata) {
        return this.removeVariation(block, metadata, null);
    }

    @Override
    public ICarvingVariation removeVariation(Block block, int metadata, String group) {
        return this.groups.removeVariation(block, metadata, group);
    }

    @Override
    public void addVariation(String groupName, Block block, int metadata, int order) {
        if (block == null) {
            throw new NullPointerException("Cannot add variation in group " + groupName + " for null block.");
        }
        CarvingVariation variation = new CarvingVariation(block, metadata, order);
        this.addVariation(groupName, variation);
    }

    @Override
    public void addVariation(String groupName, ICarvingVariation variation) {
        if (groupName == null) {
            throw new NullPointerException("Cannot add variation to null group name.");
        }
        if (variation == null) {
            throw new NullPointerException("Cannot add variation in group " + groupName + " for null variation.");
        }
        ICarvingGroup group = this.groups.getGroupByName(groupName);
        if (group == null) {
            group = new CarvingGroup(groupName);
            this.addGroup(group);
        }
        this.groups.addVariation(groupName, variation);
    }

    @Override
    public void addGroup(ICarvingGroup group) {
        this.groups.add(group);
    }

    @Override
    public void registerOre(String name, String oreName) {
        ICarvingGroup group = this.groups.getGroupByName(name);
        if (group == null) {
            throw new NullPointerException("Cannot register ore name for group " + name + ", as it does not exist.");
        }
        group.setOreName(oreName);
    }

    @Override
    public void setVariationSound(String name, String sound) {
        ICarvingGroup group = this.groups.getGroupByName(name);
        if (group == null) {
            throw new NullPointerException("Cannot set sound for group " + name + ", as it does not exist.");
        }
        group.setSound(sound);
    }

    @Override
    public String getVariationSound(Block block, int metadata) {
        return this.getVariationSound(Item.func_150898_a((Block)block), metadata);
    }

    @Override
    public String getVariationSound(Item item, int metadata) {
        ICarvingGroup group = this.groups.getGroup(Block.func_149634_a((Item)item), metadata);
        String sound = group == null ? null : group.getSound();
        return sound == null ? "chisel:chisel.fallback" : sound;
    }

    @Override
    public List<String> getSortedGroupNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.groups.getNames());
        Collections.sort(names);
        return names;
    }
}

