/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.block;

import com.cricketcraft.chisel.api.ICarvable;
import com.cricketcraft.chisel.block.tileentity.TileEntityPresent;
import com.cricketcraft.chisel.carving.CarvableHelper;
import com.cricketcraft.chisel.carving.CarvableVariation;
import com.cricketcraft.chisel.inventory.InventoryLargePresent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPresent
extends BlockChest
implements ICarvable {
    private final Random random = new Random();
    private int type;
    public CarvableHelper carverHelper;

    public BlockPresent(int type) {
        super(1);
        this.type = type;
        this.carverHelper = new CarvableHelper();
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 875.0f, 0.9365f);
    }

    public String getKindOfChest(int type) {
        return "textures/blocks/present/presentChest" + type;
    }

    private static boolean isCatSittingOnMe(World world, int x, int y, int z) {
        Entity entity;
        EntityOcelot ocelot;
        Iterator iterator = world.func_72872_a(EntityOcelot.class, AxisAlignedBB.func_72330_a((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(ocelot = (EntityOcelot)(entity = (Entity)iterator.next())).func_70906_o());
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        Block front = world.func_147439_a(x, y, z - 1);
        Block back = world.func_147439_a(x, y, z + 1);
        Block left = world.func_147439_a(x - 1, y, z);
        Block right = world.func_147439_a(x + 1, y, z);
        int metadata = 0;
        int rot = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (rot == 0) {
            metadata = 2;
        }
        if (rot == 1) {
            metadata = 5;
        }
        if (rot == 2) {
            metadata = 3;
        }
        if (rot == 3) {
            metadata = 4;
        }
        if (front != this && back != this && left != this && right != this) {
            world.func_72921_c(x, y, z, metadata, 3);
        } else {
            if (!(front != this && back != this || metadata != 4 && metadata != 5)) {
                if (front == this) {
                    world.func_72921_c(x, y, z - 1, metadata, 3);
                } else {
                    world.func_72921_c(x, y, z + 1, metadata, 3);
                }
                world.func_72921_c(x, y, z, metadata, 3);
            }
            if (!(left != this && right != this || metadata != 2 && metadata != 3)) {
                if (left == this) {
                    world.func_72921_c(x - 1, y, z, metadata, 3);
                } else {
                    world.func_72921_c(x + 1, y, z, metadata, 3);
                }
                world.func_72921_c(x, y, z, metadata, 3);
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        int l = 0;
        if (world.func_147439_a(x - 1, y, z) == this) {
            ++l;
        }
        if (world.func_147439_a(x + 1, y, z) == this) {
            ++l;
        }
        if (world.func_147439_a(x, y, z - 1) == this) {
            ++l;
        }
        if (world.func_147439_a(x, y, z + 1) == this) {
            ++l;
        }
        return l > 1 ? false : (this.areSurroundingBlocksMe(world, x, y - 1, z) ? false : (this.areSurroundingBlocksMe(world, x, y + 1, z) ? false : (this.areSurroundingBlocksMe(world, x, y, z - 1) ? false : !this.areSurroundingBlocksMe(world, x, y, z + 1))));
    }

    private boolean areSurroundingBlocksMe(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) != this ? false : (world.func_147439_a(x - 1, y, z) == this ? true : (world.func_147439_a(x + 1, y, z) == this ? true : (world.func_147439_a(x, y, z - 1) == this ? true : world.func_147439_a(x, y, z + 1) == this)));
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        super.func_149695_a(world, x, y, z, neighbor);
        TileEntityPresent tileEntityPresent = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (tileEntityPresent != null) {
            tileEntityPresent.func_145836_u();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block present, int meta) {
        TileEntityPresent tileEntityPresent = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (tileEntityPresent != null) {
            for (int c = 0; c < tileEntityPresent.func_70302_i_(); ++c) {
                ItemStack itemStack = tileEntityPresent.func_70301_a(c);
                if (itemStack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int stack = this.random.nextInt(21) + 10;
                    if (stack > itemStack.field_77994_a) {
                        stack = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= stack;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemStack.func_77973_b(), stack, itemStack.func_77960_j()));
                    float motion = 0.05f;
                    entityItem.field_70159_w = this.random.nextGaussian() * (double)motion;
                    entityItem.field_70181_x = this.random.nextGaussian() * (double)motion + (double)0.2f;
                    entityItem.field_70179_y = this.random.nextGaussian() * (double)motion;
                    if (itemStack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityItem);
                }
            }
            world.func_147453_f(x, y, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, (Block)this, meta);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityPresent(this.type);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int direction) {
        if (!this.func_149744_f()) {
            return 0;
        }
        int players = ((TileEntityPresent)world.func_147438_o((int)x, (int)y, (int)z)).field_145987_o;
        return MathHelper.func_76125_a((int)players, (int)0, (int)15);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int strength) {
        return strength == 1 ? this.func_149709_b(world, x, y, z, strength) : 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int strength) {
        return Container.func_94526_b((IInventory)this.getInventory(world, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("planks_oak");
    }

    public IInventory getInventory(World world, int x, int y, int z) {
        Object object = world.func_147438_o(x, y, z);
        if (object == null) {
            return null;
        }
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            return null;
        }
        if (BlockPresent.isCatSittingOnMe(world, x, y, z)) {
            return null;
        }
        if (world.func_147439_a(x - 1, y, z) == this && (world.isSideSolid(x - 1, y + 1, z, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y - 1, z))) {
            return null;
        }
        if (world.func_147439_a(x + 1, y, z) == this && (world.isSideSolid(x + 1, y + 1, z, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y + 1, z))) {
            return null;
        }
        if (world.func_147439_a(x, y, z - 1) == this && (world.isSideSolid(x, y + 1, z - 1, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y, z - 1))) {
            return null;
        }
        if (world.func_147439_a(x, y, z + 1) == this && (world.isSideSolid(x, y + 1, z + 1, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y, z + 1))) {
            return null;
        }
        if (world.func_147439_a(x - 1, y, z) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x - 1, y, z)), (IInventory)object);
        }
        if (world.func_147439_a(x + 1, y, z) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x + 1, y, z)), (IInventory)object);
        }
        if (world.func_147439_a(x, y, z - 1) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x, y, z - 1)), (IInventory)object);
        }
        if (world.func_147439_a(x, y, z + 1) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x, y, z + 1)), (IInventory)object);
        }
        return (IInventory)object;
    }

    @Override
    public CarvableVariation getVariation(IBlockAccess world, int x, int y, int z, int metadata) {
        return this.carverHelper.getVariation(metadata);
    }

    @Override
    public CarvableVariation getVariation(ItemStack stack) {
        return this.carverHelper.getVariation(stack.func_77960_j());
    }
}

