/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel;

import com.cricketcraft.chisel.BlockNameConversion;
import com.cricketcraft.chisel.Features;
import com.cricketcraft.chisel.block.BlockCarvable;
import com.cricketcraft.chisel.compat.Compatibility;
import com.cricketcraft.chisel.config.Configurations;
import com.cricketcraft.chisel.init.ChiselBlocks;
import com.cricketcraft.chisel.init.ChiselTabs;
import com.cricketcraft.chisel.item.chisel.ChiselController;
import com.cricketcraft.chisel.network.ChiselGuiHandler;
import com.cricketcraft.chisel.network.PacketHandler;
import com.cricketcraft.chisel.proxy.CommonProxy;
import com.cricketcraft.chisel.utils.General;
import com.cricketcraft.chisel.world.GeneratorChisel;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="chisel", name="Chisel 2", version="2.3.5.31", guiFactory="com.cricketcraft.chisel.client.gui.GuiFactory", dependencies="after:ForgeMultipart;after:Thaumcraft;after:appliedenergistics2;after:Railcraft;after:AWWayofTime;after:TwilightForest")
public class Chisel {
    public static final String MOD_ID = "chisel";
    public static final BlockCarvable.SoundType soundTempleFootstep = new BlockCarvable.SoundType("dig.stone", "chisel:step.templeblock", 1.0f, 1.0f);
    public static final String MOD_NAME = "Chisel 2";
    public static final String VERSION = "2.3.5.31";
    public static final BlockCarvable.SoundType soundHolystoneFootstep = new BlockCarvable.SoundType("holystone", 1.0f, 1.0f);
    public static final BlockCarvable.SoundType soundMetalFootstep = new BlockCarvable.SoundType("metal", 1.0f, 1.0f);
    public static boolean multipartLoaded = false;
    public static int renderEldritchId;
    public static int renderCTMId;
    public static int renderCTMNoLightId;
    public static int renderCarpetId;
    public static int renderAutoChiselId;
    public static int renderGlowId;
    public static int renderLayeredId;
    public static int roadLineId;
    public static final Logger logger;
    @Mod.Instance(value="chisel")
    public static Chisel instance;
    @SidedProxy(clientSide="com.cricketcraft.chisel.proxy.ClientProxy", serverSide="com.cricketcraft.chisel.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        BlockNameConversion.init();
        for (FMLMissingMappingsEvent.MissingMapping m : event.get()) {
            if (m.name.startsWith("null.") && m.name.length() == 6 && m.type == GameRegistry.Type.BLOCK) {
                m.warn();
                continue;
            }
            if (m.type == GameRegistry.Type.BLOCK) {
                Block block = BlockNameConversion.findBlock(m.name);
                if (block != null) {
                    m.remap(block);
                    FMLLog.getLogger().info("Remapping block " + m.name + " to " + General.getName(block));
                    continue;
                }
                FMLLog.getLogger().warn("Block " + m.name + " could not get remapped.");
                continue;
            }
            if (m.type != GameRegistry.Type.ITEM) continue;
            Item item = BlockNameConversion.findItem(m.name);
            if (item != null) {
                m.remap(item);
                FMLLog.getLogger().info("Remapping item " + m.name + " to " + General.getName(item));
                continue;
            }
            FMLLog.getLogger().warn("Item " + m.name + " could not get remapped.");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        Configurations.configExists = configFile.exists();
        Configurations.config = new Configuration(configFile);
        Configurations.config.load();
        Configurations.refreshConfig();
        ChiselTabs.preInit();
        Features.preInit();
        PacketHandler.init();
        ChiselController.INSTANCE.preInit();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Features.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ChiselGuiHandler());
        this.addWorldgen(Features.MARBLE, ChiselBlocks.marble, Configurations.marbleAmount);
        this.addWorldgen(Features.LIMESTONE, ChiselBlocks.limestone, Configurations.limestoneAmount);
        this.addWorldgen(Features.ANDESITE, ChiselBlocks.andesite, Configurations.andesiteAmount, 40.0, 100.0, 0.5);
        this.addWorldgen(Features.GRANITE, ChiselBlocks.granite, Configurations.graniteAmount, 40.0, 100.0, 0.5);
        this.addWorldgen(Features.DIORITE, ChiselBlocks.diorite, Configurations.dioriteAmount, 40.0, 100.0, 0.5);
        GameRegistry.registerWorldGenerator((IWorldGenerator)GeneratorChisel.INSTANCE, (int)1000);
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)instance);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.cricketcraft.chisel.compat.WailaCompat.register");
    }

    private void addWorldgen(Features feature, Block block, double ... data) {
        if (feature.enabled()) {
            if (data.length == 1) {
                GeneratorChisel.INSTANCE.addFeature(block, 32, (int)data[0]);
            } else if (data.length > 1 && data.length < 4) {
                GeneratorChisel.INSTANCE.addFeature(block, 32, (int)data[0], (int)data[1], (int)data[2]);
            } else if (data.length == 4) {
                GeneratorChisel.INSTANCE.addFeature(block, 32, (int)data[0], (int)data[1], (int)data[2], data[3]);
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ChiselTabs.postInit();
        Compatibility.init(event);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MOD_ID)) {
            Configurations.refreshConfig();
        }
    }

    static {
        logger = LogManager.getLogger((String)MOD_NAME);
    }
}

