/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.agedata;

import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLegacy;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderV4;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderV4_1;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderV4_2;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AgeDataLoaderManager {
    private static final String currentversion = "4.2";
    private static HashMap<String, AgeDataLoader> loaders = new HashMap();

    public static AgeData.AgeDataData load(NBTTagCompound nbt) {
        String version = nbt.func_74779_i("Version");
        AgeDataLoader loader = loaders.get(version);
        AgeData.AgeDataData data = loader.load(nbt);
        AgeDataLoaderManager.update(data);
        return data;
    }

    private static void update(AgeData.AgeDataData data) {
        if (data.version.equals("legacy")) {
            data.version = "4.0";
        }
        if (data.version.equals("4.0")) {
            data.pages.add(0, Page.createLinkPage());
            data.version = "4.1";
        }
        if (data.version.equals("4.1")) {
            AgeDataLoaderV4_1.AgeDataData datav = (AgeDataLoaderV4_1.AgeDataData)data;
            if (datav.effects.size() > 0) {
                data.cruft.put("instabilityeffects", (NBTBase)NBTUtils.writeStringListToNBT(new NBTTagList(), datav.effects));
            }
            data.version = currentversion;
        }
        if (data.agename.isEmpty()) {
            data.agename = "Unnamed Age";
        }
        if (!data.version.equals(currentversion)) {
            throw new RuntimeException("Error updating old agedata file! Version is " + data.version);
        }
    }

    static {
        loaders.put(currentversion, new AgeDataLoaderV4_2());
        loaders.put("4.1", new AgeDataLoaderV4_1());
        loaders.put("4.0", new AgeDataLoaderV4());
        loaders.put("", new AgeDataLegacy());
    }

    public static abstract class AgeDataLoader {
        public abstract AgeData.AgeDataData load(NBTTagCompound var1);
    }
}

