/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.core.DebugDataTracker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkProfiler
extends WorldSavedData {
    public static final String ID = "MystChunkProfile";
    private static final int MAP_LENGTH = 65536;
    private static final Collection<Block> watchedblocks = new HashSet<Block>();
    private static final Map<Block, Float> factor1s = new HashMap<Block, Float>();
    private static final Map<Block, Float> factor2s = new HashMap<Block, Float>();
    private static final Map<Block, Integer> freevals = new HashMap<Block, Integer>();
    private String debugname;
    private int count = 0;
    private ChunkProfileData solid_prepop;
    private ChunkProfileData solid;
    private Map<Block, ChunkProfileData> blockmaps;
    private static boolean outputfiles = false;
    private Semaphore semaphore = new Semaphore(1, true);

    public static void setInstabilityFactors(Block block, float factor1, float factor2, int free) {
        watchedblocks.add(block);
        factor1s.put(block, Float.valueOf(factor1));
        factor2s.put(block, Float.valueOf(factor2));
        freevals.put(block, free);
    }

    public ChunkProfiler(String id) {
        super(id);
        this.solid_prepop = new ChunkProfileData();
        this.solid = new ChunkProfileData();
        this.blockmaps = new HashMap<Block, ChunkProfileData>();
        for (Block block : watchedblocks) {
            this.blockmaps.put(block, new ChunkProfileData());
        }
    }

    public void baseChunk(Chunk chunk, int chunkX, int chunkZ) {
        this.profileChunk(chunk, this.solid_prepop, null);
        this.func_76185_a();
    }

    public int calculateInstability() {
        if (outputfiles) {
            this.outputFiles();
        }
        float instability = 0.0f;
        int layers = this.solid.data.length / 256;
        HashMap<Block, Float> split = new HashMap<Block, Float>();
        for (int y = 0; y < layers; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int coords = y << 8 | z << 4 | x;
                    float availability = 1.0f - (float)this.solid.data[coords] / (float)this.solid.count;
                    for (Block block : watchedblocks) {
                        ChunkProfileData map = this.blockmaps.get(block);
                        if (map.count < 100) continue;
                        float factor1 = factor1s.get(block).floatValue();
                        float factor2 = factor2s.get(block).floatValue();
                        float val = (float)map.data[coords] / (float)map.count;
                        val = val * availability * factor1 + val * factor2;
                        if (!split.containsKey(block)) {
                            split.put(block, Float.valueOf(0.0f));
                        }
                        split.put(block, Float.valueOf(((Float)split.get(block)).floatValue() + val));
                    }
                }
            }
        }
        for (Map.Entry entry : split.entrySet()) {
            float val = ((Float)entry.getValue()).floatValue();
            if (val > 0.0f) {
                val = Math.max(0.0f, val - (float)freevals.get(entry.getKey()).intValue());
            }
            instability += val;
        }
        return Math.round(instability);
    }

    public void profile(Chunk chunk, int chunkX, int chunkZ) {
        this.profileChunk(chunk, this.solid, this.blockmaps);
        ++this.count;
        this.func_76185_a();
    }

    private void profileChunk(Chunk chunk, ChunkProfileData soliddata, Map<Block, ChunkProfileData> maps) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to aquire semaphore to profile chunk (interrupted)!");
        }
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        int[] solidmap = soliddata.data;
        int layers = solidmap.length / 256;
        for (int y = 0; y < layers; ++y) {
            int storagei = y >> 4;
            if (storageArrays[storagei] == null) continue;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int accessibility;
                    int coords = y << 8 | z << 4 | x;
                    Block block = storageArrays[storagei].func_150819_a(x, y & 0xF, z);
                    int n = accessibility = block != Blocks.field_150350_a ? 2 : 0;
                    if (maps != null) {
                        for (Map.Entry<Block, ChunkProfileData> entry : maps.entrySet()) {
                            Block matchblock = entry.getKey();
                            ChunkProfileData map = entry.getValue();
                            if (block != matchblock) continue;
                            int n2 = coords;
                            map.data[n2] = map.data[n2] + 1;
                            accessibility = 1;
                        }
                    }
                    if (block.func_149655_b((IBlockAccess)chunk.field_76637_e, (chunk.field_76635_g << 4) + x, y, (chunk.field_76647_h << 4) + z)) {
                        accessibility = 1;
                    }
                    if (block.isAir((IBlockAccess)chunk.field_76637_e, (chunk.field_76635_g << 4) + x, y, (chunk.field_76647_h << 4) + z)) {
                        accessibility = 0;
                    }
                    int n3 = coords;
                    solidmap[n3] = solidmap[n3] + accessibility;
                }
            }
        }
        soliddata.count += 2;
        if (maps != null) {
            for (Map.Entry<Block, ChunkProfileData> entry : maps.entrySet()) {
                ChunkProfileData map = entry.getValue();
                ++map.count;
            }
        }
        this.semaphore.release();
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74782_a("prepop", (NBTBase)this.solid_prepop.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("solid", (NBTBase)this.solid.writeToNBT(new NBTTagCompound()));
        if (this.blockmaps == null) {
            return;
        }
        for (Map.Entry<Block, ChunkProfileData> entry : this.blockmaps.entrySet()) {
            Block block = entry.getKey();
            ChunkProfileData map = entry.getValue();
            nbt.func_74782_a(block.func_149739_a(), (NBTBase)map.writeToNBT(new NBTTagCompound()));
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.solid_prepop.readFromNBT(nbt.func_74775_l("prepop"));
        this.solid.readFromNBT(nbt.func_74775_l("solid"));
        this.count = this.solid.count;
        if (this.blockmaps == null) {
            return;
        }
        for (Block block : this.blockmaps.keySet()) {
            ChunkProfileData map = new ChunkProfileData();
            map.readFromNBT(nbt.func_74775_l(block.func_149739_a()));
            this.blockmaps.put(block, map);
            if (map.count >= this.count) continue;
            this.count = map.count;
        }
    }

    private void outputFiles() {
        ChunkProfiler.outputDebug(this.solid_prepop.data, this.solid_prepop.count, "logs/profiling/solid1.txt");
        ChunkProfiler.outputDebug(this.solid.data, this.solid.count, "logs/profiling/solid2.txt");
        if (this.blockmaps != null) {
            for (Map.Entry<Block, ChunkProfileData> entry : this.blockmaps.entrySet()) {
                ChunkProfileData map = entry.getValue();
                Block block = entry.getKey();
                ChunkProfiler.outputDebug(map.data, map.count, "logs/profiling/" + block.func_149739_a() + ".txt");
            }
        }
    }

    private static void outputDebug(int[] solidmap, int chunkcount, String filename) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, filename);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            String NEW_LINE = System.getProperty("line.separator");
            FileOutputStream fos = new FileOutputStream(file);
            BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            buffer.write(chunkcount + NEW_LINE);
            int layers = solidmap.length / 256;
            for (int y = 0; y < layers; ++y) {
                for (int z = 0; z < 16; ++z) {
                    String line = "";
                    for (int x = 0; x < 16; ++x) {
                        int coords = y << 8 | z << 4 | x;
                        if (line.length() > 0) {
                            line = line + "\t";
                        }
                        line = line + solidmap[coords];
                    }
                    buffer.write(line + NEW_LINE);
                }
                buffer.write(NEW_LINE);
            }
            buffer.write("FIN");
            buffer.write(NEW_LINE);
            buffer.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setDebugName(String name) {
        this.debugname = name;
    }

    public void clear() {
        try {
            this.semaphore.acquire();
            this.count = 0;
            this.solid_prepop = new ChunkProfileData();
            this.solid = new ChunkProfileData();
            this.blockmaps = new HashMap<Block, ChunkProfileData>();
            for (Block block : watchedblocks) {
                this.blockmaps.put(block, new ChunkProfileData());
            }
            this.func_76185_a();
            this.semaphore.release();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to aquire semaphore to profile chunk!");
        }
    }

    static {
        DebugDataTracker.register("profiler.output", new DebugDataTracker.Callback(){

            @Override
            public void setState(boolean state) {
                outputfiles = state;
            }
        });
    }

    public static class ChunkProfileData {
        public int[] data = new int[65536];
        public int count = 0;

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("count", this.count);
            nbt.func_74783_a("data", this.data);
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.count = nbt.func_74762_e("count");
            this.data = nbt.func_74759_k("data");
            if (this.data == null || this.data.length < 65536) {
                this.data = new int[65536];
                this.count = 0;
            }
        }
    }
}

