/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import com.xcompwiz.mystcraft.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class SymbolTerrainGenFlat
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        TerrainGenerator gen = new TerrainGenerator(controller);
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.TERRAIN);
        if (block != null) {
            gen.setTerrainBlock(block.block, block.metadata);
        }
        if ((block = ModifierUtils.popBlockMatching(controller, BlockCategory.SEA)) != null) {
            gen.setSeaBlock(block.block, block.metadata);
        }
        controller.registerInterface(gen);
    }

    @Override
    public String identifier() {
        return "Flat";
    }

    private static class TerrainGenerator
    implements ITerrainGenerator {
        private IAgeController controller;
        private Block fillblock = Blocks.field_150348_b;
        private byte fillmeta = 0;
        private Block seablock = Blocks.field_150355_j;
        private byte seameta = 0;

        public TerrainGenerator(IAgeController controller) {
            this.controller = controller;
        }

        public void setTerrainBlock(Block block, byte metadata) {
            this.fillblock = block;
            this.fillmeta = metadata;
        }

        public void setSeaBlock(Block block, byte metadata) {
            this.seablock = block;
            this.seameta = metadata;
        }

        @Override
        public void generateTerrain(int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
            int plane = this.controller.getAverageGroundLevel();
            int sealevel = this.controller.getSeaLevel();
            int layers = blocks.length / 256;
            for (int y = 0; y < layers; ++y) {
                Block blockId = Blocks.field_150350_a;
                byte meta = 0;
                if (y == 0) {
                    blockId = Blocks.field_150357_h;
                } else if (y < plane) {
                    blockId = this.fillblock;
                    meta = this.fillmeta;
                } else if (y <= sealevel) {
                    blockId = this.seablock;
                    meta = this.seameta;
                }
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        blocks[y << 8 | z << 4 | x] = blockId;
                        metadata[y << 8 | z << 4 | x] = meta;
                    }
                }
            }
        }
    }
}

