/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class SymbolSkylands
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        NoiseGeneratorOctaves noise = new NoiseGeneratorOctaves(new Random(controller.getSeed()), 7);
        controller.registerInterface(new TerrainAlteration(noise));
        controller.setCloudHeight(42.5f);
        controller.setHorizon(0.0);
    }

    @Override
    public String identifier() {
        return "Skylands";
    }

    private static class TerrainAlteration
    implements ITerrainAlteration {
        private static final double factor = 0.03125;
        private double[] skyNoise = null;
        private NoiseGeneratorOctaves noiseGen;

        public TerrainAlteration(NoiseGeneratorOctaves noise) {
            this.noiseGen = noise;
        }

        @Override
        public void alterTerrain(World worldObj, int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
            this.skyNoise = this.noiseGen.func_76304_a(this.skyNoise, chunkX * 16, chunkZ * 16, 16, 16, 16, 1, 2.0, 1.0, 2.0);
            int layers = blocks.length / 256;
            for (int y = 0; y < layers; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int height = 76 + (int)this.skyNoise[z | x << 4];
                        int coords = y << 8 | z << 4 | x;
                        if (blocks[coords] == Blocks.field_150355_j && !this.isSupported(x, y, z, height, blocks)) {
                            blocks[coords] = Blocks.field_150350_a;
                        }
                        if (y > height) continue;
                        blocks[coords] = Blocks.field_150350_a;
                    }
                }
            }
        }

        private boolean isSupported(int x, int y, int z, int sky, Block[] blocks) {
            if (y < 1) {
                return false;
            }
            Block block = blocks[y - 1 << 8 | z << 4 | x];
            if (block == Blocks.field_150350_a) {
                return false;
            }
            if (block == Blocks.field_150355_j) {
                return false;
            }
            return false;
        }
    }
}

