/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SymbolObelisks
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.STRUCTURE);
        controller.registerInterface(new Populator(block));
    }

    @Override
    public String identifier() {
        return "Obelisks";
    }

    private class Populator
    implements IPopulate {
        private Block block;
        private byte metadata;

        public Populator(BlockDescriptor descriptor) {
            if (descriptor == null) {
                this.block = Blocks.field_150343_Z;
                this.metadata = 0;
            } else {
                this.block = descriptor.block;
                this.metadata = descriptor.metadata;
            }
        }

        @Override
        public boolean populate(World worldObj, Random rand, int i, int j, boolean flag) {
            if (rand.nextInt(128) == 0) {
                int j6 = i + rand.nextInt(16);
                int k10 = j + rand.nextInt(16);
                this.generate(worldObj, rand, j6, worldObj.func_72976_f(j6, k10), k10);
            }
            return false;
        }

        private void generate(World worldObj, Random random, int baseX, int baseY, int baseZ) {
            int x;
            int z;
            int y;
            if (baseY == 0) {
                return;
            }
            int height = 12;
            int width = 4;
            int maxDeep = 5;
            boolean foundBase = false;
            for (y = ++baseY; y > baseY - maxDeep && !foundBase; --y) {
                foundBase = true;
                for (z = 0; z < width; ++z) {
                    for (x = 0; x < width; ++x) {
                        worldObj.func_147465_d(baseX + x, y, baseZ + z, this.block, (int)this.metadata, 2);
                        Material material = worldObj.func_147439_a(baseX + x, y - 1, baseZ + z).func_149688_o();
                        if (!worldObj.func_147437_c(baseX + x, y - 1, baseZ + z) && worldObj.func_147439_a(baseX + x, y - 1, baseZ + z) != Blocks.field_150433_aE && material != Material.field_151586_h && material != Material.field_151587_i) continue;
                        foundBase = false;
                    }
                }
            }
            ++baseX;
            ++baseZ;
            width = 2;
            for (y = 0; y < height; ++y) {
                for (z = 0; z < width; ++z) {
                    for (x = 0; x < width; ++x) {
                        worldObj.func_147465_d(baseX + x, baseY + y, baseZ + z, this.block, (int)this.metadata, 2);
                    }
                }
            }
        }
    }
}

